set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9914576';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      4,
      0,
      1,
      2,
      1,
      2,
      '242',
      NULL,
      56,
      86,
      '4244222',
      0.649742,
      1,
      3,
      1,
      '4320',
      1.439931,
      1.078969,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      ' 1-18-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 9- 1-2002',
      2.792293,
      NULL,
      1.076192,
      3.343500,
      1,
      NULL,
      0,
      0,
      0.256207,
      6,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.341585,
      2,
      0,
      1,
      1,
      0,
      0.838897,
      NULL,
      1,
      NULL,
      0,
      3,
      3,
      NULL,
      2,
      0,
      1,
      2,
      4,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      2.653047,
      2,
      1,
      2,
      NULL,
      0.399450,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.030910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      7.414139,
      3,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      4,
      0,
      3,
      0,
      3,
      1,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0.959769,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      2,
      5,
      3,
      0,
      4,
      0,
      1,
      3,
      2,
      1,
      3,
      1,
      NULL,
      2,
      4,
      1,
      3,
      3,
      3,
      3.662089,
      1.604044,
      ' 5-29-1989',
      86,
      ' 2-25-1981',
      142.555754,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      0,
      0,
      2,
      1.664305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      4.394082,
      9,
      7.181232,
      7,
      4.316656,
      0,
      0.308017,
      NULL,
      NULL,
      NULL,
      1,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867445,
      NULL,
      0.588569,
      0,
      0.767983,
      1.783283,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0,
      3,
      NULL,
      1,
      2,
      NULL,
      3,
      0,
      3,
      NULL,
      1,
      3.037745,
      3,
      0.369827,
      1.799793,
      1,
      0.359016,
      NULL,
      NULL,
      0.724541,
      0.401501,
      1.243207,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      9.443333,
      5,
      NULL,
      0,
      3,
      NULL,
      1.267562,
      NULL,
      5.732903,
      1,
      0,
      1.984401,
      5,
      2,
      0,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      '10043',
      '20004',
      '42443',
      0.177734,
      '43143',
      '',
      '',
      0,
      NULL,
      '',
      '',
      2,
      NULL,
      22.027246,
      36,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.412115,
      3.775770,
      0,
      NULL,
      NULL,
      1.311189,
      NULL,
      NULL,
      1,
      1.808365,
      0.450829,
      1,
      NULL,
      NULL,
      0,
      2,
      3.589235,
      2.576313,
      1.822372,
      NULL,
      0.964957,
      NULL,
      1.548060,
      NULL,
      0.910921,
      2.003151,
      NULL,
      NULL,
      NULL,
      1.434383,
      NULL,
      NULL,
      1.934578,
      NULL,
      NULL,
      7.774233,
      1,
      NULL,
      NULL,
      1.795050,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.995141,
      3.657653,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196145,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.177826,
      3,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.905761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.840383,
      1,
      2,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3.641099,
      0,
      2,
      3.581853,
      NULL,
      NULL,
      1.326848,
      NULL,
      NULL,
      0,
      NULL,
      5.818834,
      NULL,
      NULL,
      NULL,
      1.679880,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.038613,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.337247,
      NULL,
      NULL,
      0.330849,
      0,
      3,
      3.847303,
      NULL,
      0.734625,
      0.315479,
      1,
      NULL,
      6.280182,
      9.700844,
      4,
      2.645466,
      NULL,
      NULL,
      2.225703,
      0,
      3,
      0,
      1,
      2.808843,
      3,
      0.275300,
      2.329554,
      8.357544,
      6,
      11,
      0.985017,
      0,
      2,
      NULL,
      3,
      3.937231,
      NULL,
      1,
      2,
      2,
      3,
      NULL,
      7.497036,
      3,
      3.605247,
      9.728015,
      8,
      1.827644,
      0.754314,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.928871,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023885,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.723710,
      NULL,
      NULL,
      3.777807,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1,
      1,
      0.893514,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.631162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.885218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549784,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.839297,
      NULL,
      NULL,
      0.715829,
      NULL,
      NULL,
      0.685044,
      NULL,
      NULL,
      0.094402,
      NULL,
      NULL,
      140,
      NULL,
      3,
      0.759213,
      1.219797,
      1,
      NULL,
      1,
      3.062328,
      0.020392,
      NULL,
      1.745925,
      2.208209,
      1.132226,
      1,
      1,
      0.652149,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.868937,
      NULL,
      3,
      NULL,
      0.470744,
      NULL,
      NULL,
      NULL,
      3.891718,
      NULL,
      8.911656,
      NULL,
      NULL,
      0.554466,
      NULL,
      2.078870,
      NULL,
      1.653570,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.584676,
      NULL,
      1.860406,
      NULL,
      1.972466,
      NULL,
      1.898758,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.489073,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253894,
      0,
      NULL,
      1.283215,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.377747,
      NULL,
      NULL,
      NULL,
      0.219505,
      0,
      1.696748,
      NULL,
      0.932819,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.989877,
      NULL,
      1.274456,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.048397,
      1.379218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.806985,
      1,
      0.519737,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.821748,
      NULL,
      1.476182,
      NULL,
      3.435044,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.250190,
      NULL,
      0,
      NULL,
      1,
      2,
      3,
      NULL,
      NULL,
      4.183656,
      1.798429,
      2,
      4,
      0,
      3,
      1,
      1,
      0.101876,
      NULL,
      0,
      NULL,
      NULL,
      0.734920,
      1.667175,
      NULL,
      1,
      0.172812,
      NULL,
      1,
      1.241063,
      NULL,
      3,
      0.657084,
      NULL,
      2,
      3,
      NULL,
      2,
      2,
      NULL,
      1,
      0.527944,
      NULL,
      1.093933,
      2.076436,
      NULL,
      0.451941,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.272131,
      NULL,
      1.409489,
      NULL,
      NULL,
      5,
      3,
      3,
      NULL,
      3.421070,
      71.559468,
      14.929937,
      1,
      0.336775,
      3,
      '33341',
      '11014',
      '12201',
      NULL,
      '20123',
      '',
      '',
      0.036584,
      '',
      '',
      '');
commit;
end;
/


