set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402430';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '0341344',
      NULL,
      0,
      0,
      1,
      '0411',
      3,
      1,
      NULL,
      NULL,
      ' 4- 7-1986',
      1,
      NULL,
      NULL,
      2.845500,
      NULL,
      ' 1-13-1974',
      1.687177,
      3,
      56.355865,
      177.869977,
      3,
      ' 6-22-1985',
      ' 9-21-2002',
      ' 8-14-2000',
      3.564074,
      3,
      1,
      1,
      3,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      16,
      7,
      NULL,
      17,
      1,
      13.491581,
      0,
      1,
      8.137687,
      0.003496,
      1,
      NULL,
      1.515700,
      1.255354,
      NULL,
      0,
      1.803683,
      0.792424,
      0.000674,
      0,
      0,
      0,
      4,
      3.110676,
      2,
      NULL,
      0,
      1,
      NULL,
      5,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      7,
      1,
      2,
      1,
      0,
      0.218615,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.663069,
      1,
      NULL,
      2,
      0,
      1,
      1,
      0.216061,
      0.882021,
      1,
      0,
      2,
      2.914461,
      0.531924,
      NULL,
      1,
      2,
      1,
      0,
      3.502656,
      NULL,
      2,
      5.090344,
      0.817423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      NULL,
      2,
      2,
      5,
      0,
      3,
      3,
      NULL,
      3,
      4,
      2,
      0,
      1,
      NULL,
      1,
      1,
      1.121813,
      NULL,
      0,
      5,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      5,
      0,
      0,
      NULL,
      2,
      3,
      5,
      0,
      4,
      3,
      4,
      0,
      NULL,
      5,
      NULL,
      3,
      0,
      NULL,
      0.631237,
      ' 4-22-1998',
      859,
      '11-17-1987',
      1523.750633,
      1.257239,
      1,
      1,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      2,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.007757,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      1,
      1,
      0.877014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.629570,
      7.711279,
      1.026414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1.339955,
      NULL,
      NULL,
      3.310464,
      NULL,
      0,
      0.211576,
      155,
      NULL,
      1277,
      3,
      0.331627,
      2.913862,
      NULL,
      0,
      3,
      1,
      0,
      1,
      3,
      NULL,
      2,
      3,
      NULL,
      3,
      NULL,
      3.380115,
      0.802060,
      1,
      3,
      1,
      NULL,
      0,
      0,
      0,
      3.524592,
      0,
      0.953519,
      0,
      NULL,
      5,
      0,
      7.859553,
      NULL,
      6.679423,
      6.934622,
      2,
      3,
      2.161881,
      1.310353,
      7,
      3.090785,
      3.121379,
      3,
      63,
      0,
      0,
      NULL,
      30,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      2,
      30,
      593.382278,
      34,
      2.216575,
      10,
      28,
      140.972101,
      2,
      1,
      NULL,
      3.645309,
      0.853441,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      3.371317,
      1,
      1.546521,
      3.512060,
      0,
      NULL,
      0,
      0.993201,
      1.806323,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.800998,
      NULL,
      NULL,
      0.924562,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.318128,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802981,
      NULL,
      NULL,
      NULL,
      NULL,
      2.335800,
      2.675367,
      3.726604,
      NULL,
      NULL,
      5.933346,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1.046480,
      1.050437,
      0.954105,
      1,
      1.900794,
      2,
      NULL,
      0.654892,
      NULL,
      0,
      2.119924,
      1.809665,
      1.684295,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.737374,
      4,
      4.413908,
      2.562579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.521952,
      3,
      3.431366,
      0,
      1,
      1.154216,
      NULL,
      NULL,
      9.909505,
      2,
      0.773860,
      1,
      0.298385,
      3.913764,
      1,
      0.739472,
      2.346601,
      7.473259,
      1.290837,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.763332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.532104,
      NULL,
      1,
      NULL,
      0.644271,
      3.977783,
      6.986919,
      3.977668,
      NULL,
      1.572901,
      4.313681,
      3,
      1.802393,
      1,
      2,
      2.908901,
      1,
      2.523948,
      2.413856,
      2.354315,
      NULL,
      1,
      1.897275,
      NULL,
      3,
      6.593634,
      1.569452,
      3.110796,
      0.840738,
      NULL,
      NULL,
      NULL,
      3.539127,
      1.644207,
      0,
      3,
      1,
      NULL,
      NULL,
      7.751058,
      4.255846,
      NULL,
      5.321217,
      3.310546,
      3.700418,
      1,
      4,
      0,
      0,
      1.682887,
      0,
      0,
      0.073577,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      26.260229,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.330592,
      NULL,
      NULL,
      0.707497,
      NULL,
      NULL,
      1.689483,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.763971,
      NULL,
      NULL,
      1.307128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.099692,
      1.380821,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.936605,
      NULL,
      NULL,
      NULL,
      0.779311,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.725576,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.383443,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.622733,
      NULL,
      NULL,
      NULL,
      1.544160,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.585467,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.640899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      296,
      327.186647,
      2.734977,
      12,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973336,
      3.748059,
      4.394773,
      2,
      0.914114,
      NULL,
      NULL,
      0,
      6.321963,
      0,
      948,
      60,
      1.529594,
      1.379514,
      0.244692,
      1.688191,
      0,
      0.681626,
      1.413997,
      1,
      0.811033,
      0.473453,
      0.583026,
      NULL,
      0.270608,
      0.110423,
      1.793950,
      1.145982,
      0.920350,
      0.283707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.575763,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.419061,
      NULL,
      NULL,
      NULL,
      NULL,
      1.190120,
      1.758343,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.266268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822864,
      NULL,
      0.363474,
      NULL,
      NULL,
      4,
      7,
      3.598077,
      2,
      2.495409,
      41.390639,
      54,
      4,
      NULL,
      2,
      '24241',
      NULL,
      '',
      1.224455,
      '',
      '',
      NULL,
      1,
      '2200',
      '',
      '');
commit;
end;
/


