set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      '3001',
      1,
      0.315545,
      NULL,
      NULL,
      ' 0-18-1979',
      5.237584,
      NULL,
      1,
      0,
      0.960658,
      ' 6- 3-1978',
      25.459866,
      0,
      89,
      NULL,
      0,
      NULL,
      NULL,
      ' 6-12-1997',
      2.390682,
      1,
      0.212430,
      1.145746,
      1,
      NULL,
      NULL,
      0.882505,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      27.283399,
      5,
      1,
      1,
      1,
      2,
      0,
      3,
      1,
      0,
      1.338292,
      1.052842,
      1.675632,
      0.232111,
      0.323945,
      0,
      1,
      NULL,
      5,
      4,
      1,
      3,
      0,
      NULL,
      NULL,
      1,
      0,
      3,
      4,
      1,
      4,
      2,
      NULL,
      5.915620,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.710634,
      NULL,
      NULL,
      0.654824,
      1.548082,
      NULL,
      1,
      NULL,
      3,
      1,
      1.108620,
      NULL,
      1,
      NULL,
      0.140812,
      NULL,
      1.597339,
      1,
      0,
      1,
      0.769892,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5,
      1,
      0,
      5,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      3,
      0,
      0,
      0,
      4,
      5,
      1,
      0,
      0,
      0,
      1,
      2,
      1,
      2,
      '11-27-1996',
      155.447535,
      '10- 7-2000',
      163,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      0,
      NULL,
      2,
      3,
      1.969141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.372502,
      1,
      2.023716,
      NULL,
      0.183686,
      1.470449,
      0.909851,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.483886,
      0,
      1.932816,
      0.160708,
      0,
      NULL,
      1.468690,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.813952,
      NULL,
      3,
      2,
      3,
      1,
      NULL,
      2,
      1,
      2,
      2,
      2.574200,
      1,
      2.572637,
      NULL,
      NULL,
      NULL,
      3.409555,
      1.727478,
      1.704763,
      1.649574,
      1.243801,
      1,
      1,
      0.751921,
      NULL,
      1,
      1.795061,
      2.299075,
      0.256030,
      2,
      10,
      0,
      9.888096,
      2,
      1.654237,
      0.198023,
      2,
      7.104482,
      1.913205,
      2.079563,
      1,
      10.848107,
      NULL,
      0,
      68,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      '43233',
      '',
      '',
      0.816293,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      14,
      43.684932,
      12.407800,
      1.067882,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.142685,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584644,
      NULL,
      NULL,
      0.871547,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.189425,
      2.667351,
      NULL,
      1.220536,
      3.336258,
      2,
      3,
      2,
      3,
      3.605753,
      NULL,
      3,
      2.123688,
      0.901004,
      NULL,
      NULL,
      2,
      NULL,
      1.849644,
      1.351922,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062361,
      NULL,
      NULL,
      NULL,
      2.557881,
      0.804149,
      1,
      2,
      3.320476,
      1.003226,
      1.859637,
      NULL,
      NULL,
      1,
      1.926546,
      0.426597,
      3.774664,
      1.743268,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      2.486960,
      0.988673,
      1.603448,
      3.476143,
      0,
      1,
      1,
      1,
      1.085111,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.819325,
      4.486157,
      0.720720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.009392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.696550,
      NULL,
      1,
      NULL,
      NULL,
      0.094037,
      NULL,
      NULL,
      3.897231,
      1.808411,
      NULL,
      0.086122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.507494,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      3.222227,
      3.915744,
      2.120065,
      4.813941,
      1,
      NULL,
      0,
      1,
      1.722758,
      1.899882,
      1,
      0,
      NULL,
      NULL,
      3.007576,
      2,
      0,
      1,
      NULL,
      3.468317,
      1.412707,
      NULL,
      NULL,
      3.894178,
      3,
      2,
      0,
      0.997712,
      1,
      NULL,
      1,
      0.574719,
      NULL,
      NULL,
      0.523308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666408,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.966069,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899599,
      NULL,
      NULL,
      1.307045,
      NULL,
      NULL,
      2.672163,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      0.169711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.390663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319758,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.584836,
      NULL,
      NULL,
      2,
      NULL,
      1.276215,
      NULL,
      NULL,
      NULL,
      1.170996,
      NULL,
      NULL,
      1.323229,
      NULL,
      1.135739,
      NULL,
      0,
      NULL,
      0.302180,
      NULL,
      1,
      0.761160,
      0.066240,
      0.740493,
      1.640618,
      1,
      1,
      1.002315,
      NULL,
      0.408621,
      0.733098,
      1.095449,
      0,
      1.217415,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      3,
      3,
      7,
      0.464098,
      NULL,
      17.107608,
      NULL,
      3,
      0.766189,
      3.046004,
      3,
      NULL,
      2.057701,
      3.514817,
      NULL,
      0.871341,
      0,
      NULL,
      0,
      2,
      NULL,
      2,
      0,
      NULL,
      1,
      0,
      NULL,
      1.594383,
      3,
      NULL,
      0,
      1.996279,
      NULL,
      1.780730,
      NULL,
      NULL,
      NULL,
      0.165079,
      NULL,
      NULL,
      NULL,
      NULL,
      3.134661,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.182077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134440,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      47,
      4,
      1,
      NULL,
      '43442',
      '',
      '',
      1.705475,
      '',
      '',
      NULL,
      1.551581,
      '',
      NULL,
      '');
commit;
end;
/


