set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '0031123',
      2.098808,
      1.079924,
      5,
      NULL,
      '0220',
      NULL,
      1.378653,
      NULL,
      NULL,
      ' 2-13-1974',
      2,
      NULL,
      3,
      NULL,
      0.616600,
      ' 5- 7-2000',
      NULL,
      NULL,
      109,
      NULL,
      4,
      NULL,
      NULL,
      '10-29-1994',
      0,
      0,
      0.732692,
      1.780683,
      1.342678,
      1,
      1,
      1.539487,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      19,
      20.687521,
      4,
      22.742666,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0.591468,
      1,
      1.157827,
      1,
      0.434614,
      3,
      1,
      3,
      2,
      1,
      2,
      2,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      2,
      1,
      NULL,
      1,
      0,
      0.911579,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      2,
      0.173843,
      0.423018,
      NULL,
      0,
      1,
      0.824256,
      NULL,
      0,
      0.182649,
      0,
      0.812789,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      6,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0.504082,
      NULL,
      ' 7-27-1997',
      16,
      ' 3-25-2003',
      212,
      0.001281,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.456657,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.329443,
      1.823282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.921258,
      1,
      NULL,
      1,
      0.921642,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.777593,
      1,
      3,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      3,
      2,
      2,
      0.825861,
      NULL,
      NULL,
      0.588806,
      0,
      0,
      3.270707,
      1,
      1,
      NULL,
      1,
      NULL,
      0.202091,
      NULL,
      0,
      0,
      3.426546,
      0.418896,
      1.964205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      2,
      0.944173,
      1,
      '03332',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      3.936642,
      NULL,
      NULL,
      37,
      0.773643,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.856763,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328862,
      NULL,
      NULL,
      0.883618,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.179315,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.538918,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853925,
      5,
      NULL,
      1,
      0.050351,
      NULL,
      NULL,
      NULL,
      1.587550,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.676232,
      1.725560,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.401258,
      1.509173,
      0.472770,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      0.687970,
      0.161928,
      0.551551,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794518,
      NULL,
      NULL,
      7,
      7.954819,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.435502,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.784133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.104421,
      0.246319,
      3,
      0.088733,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.943860,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.037802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.251183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.908151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.131813,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.410863,
      NULL,
      NULL,
      0.663875,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.145473,
      NULL,
      NULL,
      1,
      2.423859,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.492066,
      2,
      2,
      0,
      1,
      1.117709,
      0.136860,
      0.907442,
      0.964687,
      NULL,
      NULL,
      0.027726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145463,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.601630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520405,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.187321,
      NULL,
      NULL,
      1.087049,
      NULL,
      NULL,
      0,
      0.695304,
      0,
      1,
      0.568553,
      0,
      0,
      NULL,
      NULL,
      3.989995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.774549,
      NULL,
      NULL,
      NULL,
      1.995528,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.539566,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.253633,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.214406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.539471,
      2.008570,
      NULL,
      1.489815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989417,
      NULL,
      1.266983,
      NULL,
      NULL,
      0.673596,
      0,
      0.361543,
      NULL,
      1,
      1,
      1.955134,
      0.489855,
      0,
      1,
      NULL,
      0.936787,
      1,
      1.750267,
      0.175193,
      0.991224,
      1.116015,
      0.280573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      7,
      1.338327,
      2.434076,
      0,
      3,
      8,
      NULL,
      2,
      0.249776,
      1.948807,
      1,
      NULL,
      0.567567,
      1.292512,
      NULL,
      1.866387,
      0,
      NULL,
      1.334701,
      0.418913,
      NULL,
      0.740192,
      1.759268,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.918296,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.553457,
      NULL,
      0,
      1.740965,
      NULL,
      1.783577,
      1,
      NULL,
      3.999733,
      1,
      0.591837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.025835,
      NULL,
      1.622726,
      NULL,
      2,
      0,
      0,
      0.185214,
      NULL,
      NULL,
      NULL,
      156,
      1,
      1.787738,
      3,
      '01340',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


