set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '3343220',
      2.130021,
      0.833724,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      '11-17-1992',
      NULL,
      NULL,
      1,
      3.557672,
      3.196090,
      ' 8-15-1996',
      NULL,
      NULL,
      NULL,
      15,
      0,
      NULL,
      NULL,
      ' 8- 0-1986',
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.980035,
      0,
      1.941081,
      NULL,
      NULL,
      NULL,
      0,
      0,
      24.245126,
      5,
      2,
      10,
      NULL,
      NULL,
      0.630494,
      0,
      2,
      0,
      NULL,
      1.530072,
      1,
      0,
      2.644838,
      1.716370,
      1,
      1.149000,
      0,
      3,
      1,
      3.674079,
      0,
      NULL,
      0,
      3,
      1,
      2,
      1,
      0,
      0,
      4,
      NULL,
      1,
      9,
      1,
      2,
      0,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      1,
      1.951402,
      2,
      0,
      0,
      0.462082,
      1.825684,
      1,
      1.679921,
      NULL,
      0,
      0.753710,
      NULL,
      1.141610,
      1,
      1,
      0,
      NULL,
      5.663463,
      NULL,
      1,
      0,
      1.823589,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      1.503951,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      4,
      5,
      4,
      1,
      3,
      2,
      3,
      5,
      1,
      2,
      NULL,
      1,
      ' 3- 6-1991',
      172,
      NULL,
      36,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905130,
      1.802737,
      3.876455,
      NULL,
      3,
      NULL,
      1.910098,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714370,
      NULL,
      NULL,
      NULL,
      0.543159,
      0,
      NULL,
      NULL,
      1.772462,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.219355,
      1,
      0,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      2,
      2,
      0,
      2,
      NULL,
      1.243736,
      1,
      0,
      1,
      1,
      1.781267,
      NULL,
      1.783186,
      NULL,
      0.096608,
      0,
      1,
      1,
      3.123035,
      0.296008,
      1.021527,
      9.110809,
      8.985150,
      0.883639,
      NULL,
      5.730066,
      7,
      3.672912,
      2,
      6.752909,
      0,
      3.913989,
      1.112616,
      NULL,
      0,
      NULL,
      60,
      NULL,
      NULL,
      NULL,
      0,
      0.860514,
      NULL,
      '21114',
      '',
      '',
      0.196037,
      '',
      '',
      '',
      1.647019,
      '',
      '',
      '',
      2,
      NULL,
      55,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035328,
      NULL,
      0,
      1.187547,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.256449,
      NULL,
      0.025148,
      1.751784,
      0,
      2,
      NULL,
      2.379814,
      1.872721,
      0.266631,
      2,
      2.500874,
      NULL,
      1.448464,
      NULL,
      1,
      3,
      3.456793,
      NULL,
      1.602011,
      4.848720,
      2.005472,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      1,
      1.413937,
      NULL,
      NULL,
      0.710117,
      0.190099,
      0.575784,
      1,
      1,
      0,
      1.145688,
      1,
      0,
      2.104826,
      1.376701,
      NULL,
      3.513313,
      0,
      0,
      1,
      2.480798,
      3.126029,
      1.810587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0.666527,
      1,
      1.696358,
      NULL,
      NULL,
      NULL,
      0.798082,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.235706,
      1,
      0.007211,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.105463,
      1.601691,
      0,
      0.374379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772256,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.996641,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269104,
      NULL,
      NULL,
      0.891815,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      2.313214,
      0.436303,
      NULL,
      NULL,
      NULL,
      4,
      4.038991,
      NULL,
      2.036581,
      1,
      NULL,
      NULL,
      1.289181,
      1.227852,
      0,
      2.051978,
      NULL,
      0,
      3,
      5.273886,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.693934,
      1.819267,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.115993,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.100252,
      NULL,
      NULL,
      1.324578,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.308413,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.544003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.406239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140447,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.076989,
      NULL,
      NULL,
      NULL,
      1.025873,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.332261,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.643158,
      NULL,
      NULL,
      1.961481,
      NULL,
      NULL,
      3,
      0,
      2.081051,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      50.705949,
      NULL,
      0,
      0,
      0,
      1.972545,
      NULL,
      0,
      1,
      0.271162,
      NULL,
      1.638362,
      0.055973,
      NULL,
      0,
      NULL,
      0.754393,
      0.948906,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.594259,
      3,
      2.859917,
      3,
      7.695600,
      2,
      3.636935,
      NULL,
      3.018969,
      1.323582,
      NULL,
      3,
      1.351101,
      NULL,
      1,
      NULL,
      NULL,
      0.412735,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.050081,
      NULL,
      NULL,
      0.244013,
      NULL,
      NULL,
      0.751312,
      1.735052,
      NULL,
      1.067841,
      NULL,
      NULL,
      1.539079,
      0,
      NULL,
      2.182697,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022087,
      NULL,
      0,
      NULL,
      0.313405,
      NULL,
      2,
      4,
      NULL,
      0,
      NULL,
      NULL,
      9,
      50.485609,
      NULL,
      0,
      1.972438,
      '04113',
      '',
      '',
      0.525604,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


