set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7826448';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      2.019335,
      0,
      2,
      NULL,
      '0331',
      0.848295,
      0,
      NULL,
      NULL,
      NULL,
      23.803723,
      NULL,
      NULL,
      2,
      0,
      NULL,
      8.231875,
      0,
      NULL,
      98.038092,
      NULL,
      ' 9-15-1981',
      ' 4-26-2001',
      '11-26-1997',
      3,
      2.786253,
      3.161804,
      3.479975,
      0,
      0.515812,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      5,
      2.899013,
      3.815617,
      1,
      6.218175,
      2,
      0,
      4,
      0,
      2,
      1,
      1,
      0,
      0,
      NULL,
      1.184145,
      0.485081,
      1.467820,
      1,
      2,
      1,
      3,
      2.687247,
      0,
      0,
      3,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      7,
      0,
      0,
      1,
      NULL,
      1.987170,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2,
      1,
      0.656958,
      NULL,
      1.009934,
      NULL,
      NULL,
      0.680480,
      NULL,
      2,
      3,
      0.449420,
      0,
      3.387524,
      0,
      1,
      NULL,
      1,
      1.085398,
      NULL,
      1,
      NULL,
      4.139378,
      NULL,
      2,
      1.779115,
      NULL,
      NULL,
      NULL,
      3.644501,
      1,
      0,
      1,
      3,
      0,
      1,
      5,
      1,
      0,
      1,
      0,
      2,
      1,
      0,
      0,
      2.874689,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.510243,
      NULL,
      3,
      3,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      2,
      3,
      4,
      5,
      3,
      1,
      NULL,
      5,
      2,
      4,
      5,
      4,
      0,
      0,
      3,
      1,
      7.750014,
      NULL,
      NULL,
      69,
      ' 9-16-1976',
      3,
      1,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1.910475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      0,
      0,
      2,
      0.712480,
      0,
      1,
      0.389460,
      8.486136,
      3,
      NULL,
      3,
      NULL,
      1,
      3.154574,
      1,
      NULL,
      1,
      1,
      1,
      7.033359,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.241236,
      2,
      NULL,
      3,
      3,
      9,
      ' 3-24-2003',
      67,
      NULL,
      0.716070,
      NULL,
      2,
      1.501037,
      NULL,
      0,
      0,
      3.925396,
      NULL,
      NULL,
      NULL,
      2.024694,
      19.905889,
      3.996867,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.381379,
      2,
      3,
      0,
      2,
      1,
      3,
      2,
      0,
      2,
      1,
      0,
      3.473850,
      3,
      1.858306,
      3,
      0,
      1.538722,
      0,
      1,
      1.649306,
      0.552150,
      1.920424,
      0,
      1,
      NULL,
      0.677941,
      1,
      0.466036,
      2.005016,
      1,
      5.301377,
      NULL,
      NULL,
      0,
      6,
      7.023871,
      5.711585,
      1,
      6,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      1.636246,
      NULL,
      22,
      36,
      NULL,
      NULL,
      NULL,
      3,
      '22111',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.100784,
      '4302',
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.422146,
      2,
      1.104223,
      0,
      1.107443,
      NULL,
      NULL,
      0.272023,
      NULL,
      1,
      0.507804,
      NULL,
      NULL,
      0.961274,
      NULL,
      NULL,
      0.073001,
      NULL,
      NULL,
      NULL,
      0,
      0.326749,
      0,
      1,
      0,
      NULL,
      1.088895,
      0.281941,
      1.727070,
      0,
      0,
      NULL,
      0.991042,
      0.161162,
      1.376477,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.562437,
      1.657673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.370262,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.407128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.541578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041188,
      1.733953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.925670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177629,
      0.383100,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.304872,
      1.807983,
      NULL,
      2,
      0,
      NULL,
      0.117328,
      1,
      1.648704,
      0.499492,
      NULL,
      NULL,
      0.198035,
      NULL,
      0,
      2,
      NULL,
      0.780584,
      0,
      NULL,
      NULL,
      3.067151,
      NULL,
      1.995856,
      0,
      NULL,
      1,
      3.570238,
      NULL,
      1.701184,
      0.403407,
      NULL,
      0.024935,
      0,
      NULL,
      0,
      2.234167,
      NULL,
      0,
      0.678851,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.606218,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      97.899728,
      99,
      2,
      0,
      0.408847,
      '34143',
      '',
      '',
      0.437035,
      '',
      '',
      NULL,
      1.670130,
      '',
      '',
      '');
commit;
end;
/


