set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9680781';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32',
      '44',
      23.895910,
      26.394055,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '2303',
      2.066044,
      0.512835,
      NULL,
      NULL,
      ' 6- 9-1995',
      1.338153,
      8.832214,
      NULL,
      NULL,
      0,
      ' 2- 9-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 5-11-1988',
      ' 2-25-2000',
      NULL,
      NULL,
      3,
      2,
      0.052797,
      0.000360,
      0,
      1,
      1.258619,
      1.579702,
      1.682321,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      7,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      5,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0.664647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.824376,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      3,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      3,
      4,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      0,
      2,
      1,
      0,
      0,
      5,
      1,
      5,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      2,
      2,
      3,
      3,
      5,
      1,
      5,
      2,
      2,
      ' 4- 7-2003',
      397,
      ' 5- 4-1980',
      471,
      3,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.127346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      6,
      4.027036,
      NULL,
      0.615100,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431431,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.683995,
      NULL,
      0,
      1,
      3,
      14,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.837954,
      1,
      0,
      0,
      0,
      3,
      NULL,
      0,
      2,
      1,
      2,
      NULL,
      0.201784,
      0,
      7.274009,
      0.403173,
      1,
      0,
      1,
      0,
      0.529053,
      1.413878,
      0,
      0.128911,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      11,
      5.692457,
      7.705807,
      2.738059,
      6.113764,
      2.632340,
      1.378288,
      3.769386,
      2,
      2,
      2,
      NULL,
      3,
      2.944970,
      NULL,
      NULL,
      NULL,
      55.805008,
      NULL,
      5.901243,
      NULL,
      '00342',
      NULL,
      '',
      1.055928,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.245229,
      10,
      NULL,
      24,
      3,
      38,
      7,
      NULL,
      3,
      1,
      3.023373,
      3.222322,
      0.560663,
      NULL,
      NULL,
      0.771634,
      NULL,
      NULL,
      0.032976,
      NULL,
      NULL,
      1.538309,
      NULL,
      NULL,
      1.878571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.879112,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.152557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.051550,
      0.704616,
      1.959321,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754744,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.288904,
      NULL,
      NULL,
      2,
      1,
      0,
      0.730705,
      0,
      0.519454,
      NULL,
      0.560022,
      0.491982,
      NULL,
      0.559534,
      1,
      1,
      0.475247,
      0.127391,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.058213,
      NULL,
      0,
      4,
      0,
      1.050723,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.473050,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.737681,
      3,
      3.347070,
      2.255889,
      2,
      3.488228,
      1.781883,
      2.085126,
      6,
      NULL,
      1,
      0,
      2.862542,
      2,
      0,
      NULL,
      NULL,
      0.430262,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.929699,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.061089,
      NULL,
      NULL,
      2.990684,
      0,
      3,
      NULL,
      2,
      1,
      2,
      2,
      4.962479,
      8,
      1.253726,
      1.484530,
      0,
      NULL,
      NULL,
      3,
      2.579657,
      0,
      3,
      NULL,
      1,
      NULL,
      3.037771,
      0,
      11.508791,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3.811673,
      NULL,
      2,
      1,
      2.697529,
      3.868916,
      2,
      NULL,
      0,
      NULL,
      1.590893,
      0,
      5.061448,
      0,
      2,
      NULL,
      1.565895,
      0,
      0.105863,
      1.795091,
      NULL,
      1.406547,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.132494,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.377219,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.048116,
      1,
      1,
      0.043024,
      3.807764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.918570,
      NULL,
      NULL,
      NULL,
      0.263017,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.326815,
      NULL,
      NULL,
      NULL,
      1.700296,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.765733,
      NULL,
      NULL,
      NULL,
      0.562105,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.201324,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.567807,
      NULL,
      NULL,
      NULL,
      2,
      14,
      34,
      3,
      NULL,
      4.771667,
      0.459077,
      NULL,
      NULL,
      1.085026,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.735853,
      NULL,
      NULL,
      0.326833,
      NULL,
      0.174322,
      350.005709,
      NULL,
      0.463001,
      0.184945,
      0.779355,
      0,
      1,
      0.619110,
      1.427365,
      0,
      0.794159,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0.048540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.409175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      7.347056,
      1.381490,
      3.626748,
      5,
      3,
      17.167965,
      3.210169,
      2.944427,
      NULL,
      0,
      1,
      NULL,
      0.231765,
      1,
      NULL,
      1,
      1,
      NULL,
      1.284697,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.621330,
      0,
      NULL,
      3,
      3,
      NULL,
      1,
      0.794495,
      NULL,
      1.684742,
      3,
      NULL,
      0.297197,
      2,
      NULL,
      1.813888,
      NULL,
      NULL,
      0.428248,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1.277349,
      1,
      1,
      42.304461,
      56,
      5,
      4,
      0.846563,
      '22024',
      '',
      '',
      1.978872,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


