set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8321532';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '3424110',
      NULL,
      0,
      0,
      NULL,
      '1011',
      NULL,
      3,
      2,
      63,
      NULL,
      3.569684,
      NULL,
      0,
      NULL,
      0,
      ' 3-23-2003',
      50.511123,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '11- 9-1979',
      1,
      1.763557,
      NULL,
      0,
      3.255543,
      NULL,
      3,
      0.597918,
      1.478300,
      17.345722,
      4,
      13,
      6,
      9,
      13,
      1,
      7.932850,
      3,
      3,
      0.032653,
      1.907211,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      137.582478,
      NULL,
      0,
      7,
      3.176417,
      4,
      0,
      0,
      0,
      0,
      1,
      4,
      1,
      0,
      1,
      0,
      2,
      4.292299,
      1,
      0,
      NULL,
      1,
      1.841026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      NULL,
      0.642705,
      1.037410,
      0,
      NULL,
      1,
      1,
      1,
      1.487220,
      1,
      NULL,
      1,
      0.692563,
      1.561940,
      NULL,
      1.272469,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0.974457,
      NULL,
      NULL,
      0.679303,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1,
      1,
      0,
      3,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      4,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      2,
      3,
      1,
      NULL,
      1,
      3,
      7,
      NULL,
      ' 8-24-1993',
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      6,
      3,
      1,
      0.842244,
      NULL,
      NULL,
      NULL,
      0.951871,
      3,
      0.861921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.169633,
      1,
      0.873225,
      1.238947,
      1.600901,
      1,
      1.480091,
      NULL,
      1.742243,
      0.563281,
      NULL,
      NULL,
      NULL,
      3,
      0.746938,
      2,
      NULL,
      2,
      1,
      NULL,
      2,
      2,
      2,
      0,
      3,
      3,
      2,
      10.008054,
      4.770698,
      1,
      1.214119,
      1.851701,
      1,
      0.952547,
      1.001901,
      1.246844,
      NULL,
      0.315658,
      NULL,
      1.794008,
      1,
      NULL,
      0,
      2,
      NULL,
      6,
      3.267633,
      1,
      8.032009,
      7,
      0,
      2.535869,
      3,
      2.308801,
      NULL,
      0,
      NULL,
      7.801123,
      2,
      0.916882,
      46,
      NULL,
      NULL,
      NULL,
      1,
      1.220956,
      1,
      '42304',
      '',
      NULL,
      1.326179,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3,
      25,
      254.724127,
      27.095546,
      0,
      4,
      1.905952,
      4,
      3,
      0,
      2.044213,
      2.711346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925739,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.553174,
      NULL,
      NULL,
      2,
      1,
      0.143550,
      1.097348,
      NULL,
      NULL,
      2.686551,
      NULL,
      1,
      0,
      0.477607,
      1,
      1,
      NULL,
      NULL,
      3.002538,
      3.199317,
      0,
      2.330552,
      NULL,
      3.197693,
      NULL,
      0.506182,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.346617,
      NULL,
      NULL,
      2.757817,
      0,
      0,
      3,
      NULL,
      0,
      0.431866,
      0,
      1,
      1,
      2.696719,
      1,
      0,
      0,
      1.254629,
      1.170950,
      1,
      NULL,
      NULL,
      1.058165,
      NULL,
      NULL,
      1,
      3,
      1,
      2,
      1.072768,
      7.583761,
      0,
      0.406395,
      NULL,
      NULL,
      NULL,
      0.544786,
      NULL,
      NULL,
      NULL,
      0.077389,
      3,
      NULL,
      3,
      2.493535,
      3.942870,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      2.534711,
      3.550923,
      2,
      3,
      NULL,
      2.711928,
      1,
      3,
      1,
      8.525609,
      3.926929,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.260714,
      NULL,
      NULL,
      1.394742,
      0.511758,
      1.965833,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254511,
      0.626177,
      3,
      0.975775,
      3.169412,
      NULL,
      0,
      1,
      NULL,
      2.926914,
      NULL,
      7.741393,
      0,
      6,
      0.905152,
      2.736536,
      7.174617,
      NULL,
      1.435905,
      1,
      1,
      1,
      1.246551,
      2,
      2,
      NULL,
      9,
      5.659861,
      6,
      NULL,
      1.873580,
      NULL,
      NULL,
      NULL,
      1.415088,
      2.213667,
      1,
      0.598382,
      3.216446,
      3.045127,
      NULL,
      11.212963,
      11.128660,
      4,
      NULL,
      1.515422,
      7,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0.261737,
      1,
      3.860390,
      NULL,
      NULL,
      0.103639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208627,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.789774,
      NULL,
      NULL,
      0.324403,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.894349,
      NULL,
      NULL,
      0.070106,
      NULL,
      NULL,
      NULL,
      1.918494,
      0.468093,
      1.690766,
      1.503863,
      0,
      0,
      9.539285,
      NULL,
      1,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.147883,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834903,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.435099,
      NULL,
      2.524374,
      NULL,
      0,
      NULL,
      0.039104,
      NULL,
      3,
      NULL,
      2.767732,
      NULL,
      0.772057,
      NULL,
      1.244688,
      NULL,
      2.322966,
      NULL,
      1.545204,
      NULL,
      0.438434,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.247198,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.140793,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.618552,
      96,
      7,
      0.757660,
      7,
      8,
      0.297827,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.186017,
      NULL,
      1.184596,
      71,
      1,
      1,
      1.461298,
      0.835466,
      0,
      1,
      0,
      1,
      0,
      1.322477,
      1,
      0,
      0.334114,
      0,
      1.728152,
      1,
      0.318620,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      7.739858,
      3.157905,
      1.573616,
      NULL,
      21.718096,
      2,
      0.369362,
      NULL,
      0.557600,
      0.410698,
      NULL,
      1.524471,
      3,
      2.539291,
      0.658145,
      NULL,
      3.955417,
      NULL,
      NULL,
      0,
      3.381781,
      3,
      0,
      0.960652,
      0.109448,
      1,
      NULL,
      2.345258,
      3.537571,
      NULL,
      2.224120,
      1.448550,
      NULL,
      0,
      1.733727,
      2,
      NULL,
      0,
      0.236976,
      NULL,
      1,
      NULL,
      2.598994,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042470,
      1.372950,
      1.776856,
      0,
      NULL,
      3,
      2,
      4,
      1,
      NULL,
      NULL,
      52.020499,
      NULL,
      5,
      1,
      1,
      '03243',
      '40243',
      NULL,
      0,
      '40144',
      '',
      '',
      0.311273,
      '1110',
      '',
      '');
commit;
end;
/


