set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7505195';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      3,
      1.749466,
      NULL,
      NULL,
      ' 7-24-1992',
      16,
      NULL,
      3,
      0,
      1.922975,
      '11-19-1981',
      19,
      2.807142,
      125.554599,
      NULL,
      1,
      ' 4-20-1995',
      '11-10-1986',
      ' 9-17-1996',
      NULL,
      1.488482,
      3.241889,
      1,
      1,
      3.895483,
      NULL,
      1,
      NULL,
      303,
      7,
      NULL,
      NULL,
      121,
      NULL,
      NULL,
      1,
      0,
      1,
      18,
      1.924408,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0.680179,
      9,
      6,
      6,
      3,
      0,
      0,
      1,
      0,
      0,
      4,
      1,
      0,
      0,
      1,
      0,
      0,
      11.472691,
      1,
      2,
      2,
      1,
      0.753156,
      NULL,
      NULL,
      0.464781,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0.118853,
      1.485416,
      0,
      0.894184,
      0.774425,
      1,
      3,
      3.644411,
      0,
      0,
      2,
      0.627944,
      1.228591,
      NULL,
      0.353761,
      0.695288,
      1,
      1,
      1,
      NULL,
      0,
      2,
      2,
      0.362071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      5,
      0,
      3,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      9,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      3,
      1,
      0,
      3,
      NULL,
      1,
      0,
      1,
      2,
      3,
      1,
      2,
      5,
      2,
      2,
      NULL,
      1,
      2,
      NULL,
      3,
      2.538501,
      '10- 7-1990',
      347,
      ' 4- 9-1976',
      1625.082199,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909682,
      0,
      0,
      0,
      1,
      2.532402,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.454157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703678,
      2,
      NULL,
      1.028299,
      3.624520,
      0.633678,
      2,
      3.813692,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      3,
      2,
      2,
      2,
      3,
      3,
      0,
      NULL,
      1,
      3.547606,
      8.762465,
      NULL,
      32,
      97,
      106.749258,
      184,
      88.822216,
      135.567710,
      0.730545,
      1,
      0,
      0.469865,
      0.800144,
      0.511111,
      1,
      4,
      4,
      0.236543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      31,
      18,
      32,
      5,
      0.430578,
      2.697009,
      '13130',
      '23040',
      '12202',
      NULL,
      NULL,
      '',
      '',
      1.953200,
      '3134',
      '',
      '',
      NULL,
      NULL,
      254.584345,
      0,
      NULL,
      NULL,
      3,
      110.799309,
      5,
      1,
      0.914164,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.430198,
      3.964912,
      NULL,
      15.765670,
      0,
      3,
      8.648668,
      NULL,
      NULL,
      NULL,
      1,
      0.605210,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.389559,
      11.308748,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      2,
      1,
      1.273910,
      0,
      1.487068,
      0.172083,
      1,
      0,
      1.182477,
      NULL,
      0.297335,
      0.775228,
      1,
      NULL,
      1.271524,
      1,
      2,
      16.635467,
      0,
      1,
      NULL,
      NULL,
      0.850482,
      0,
      1.157655,
      NULL,
      2.094833,
      NULL,
      0,
      1.146632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      2,
      3,
      2,
      0,
      0.788923,
      1,
      NULL,
      NULL,
      NULL,
      5.156601,
      4.264109,
      4,
      3,
      1.722295,
      3.119665,
      2,
      1.432578,
      1.410173,
      4.507505,
      5,
      5,
      0.481373,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498910,
      NULL,
      NULL,
      1.074445,
      NULL,
      NULL,
      1.646285,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      5.686273,
      4.513114,
      0,
      NULL,
      3,
      0.815257,
      0.401248,
      2,
      2,
      2.711165,
      NULL,
      0,
      6,
      1.458602,
      0,
      0.960928,
      1.204106,
      0,
      0,
      3.382782,
      NULL,
      0,
      2,
      2.952273,
      3.874205,
      3,
      1.477756,
      NULL,
      NULL,
      0.207550,
      4,
      3,
      5,
      3,
      1,
      3,
      0,
      0,
      NULL,
      1.905130,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593120,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503301,
      NULL,
      NULL,
      0.411105,
      NULL,
      NULL,
      0.714458,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.479094,
      NULL,
      0,
      1,
      1,
      0.255536,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.800229,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330023,
      NULL,
      NULL,
      NULL,
      1.469467,
      NULL,
      NULL,
      NULL,
      0.835901,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.269701,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.207176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      349.063574,
      681,
      NULL,
      8,
      NULL,
      1,
      NULL,
      NULL,
      0.893285,
      NULL,
      NULL,
      2,
      16,
      13,
      1,
      NULL,
      NULL,
      NULL,
      420,
      0.227053,
      7073,
      46.392990,
      NULL,
      NULL,
      NULL,
      1,
      0.619583,
      1.067693,
      0,
      NULL,
      0.529398,
      3.909183,
      NULL,
      0.694957,
      1,
      0,
      0.239884,
      NULL,
      1.807012,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.334472,
      13.926521,
      0,
      1.285228,
      1.032801,
      NULL,
      NULL,
      1.258843,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.736611,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.541867,
      NULL,
      0.594540,
      NULL,
      0.374486,
      NULL,
      1,
      NULL,
      1.161395,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.690485,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.197669,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475457,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.448679,
      NULL,
      1.385129,
      NULL,
      NULL,
      NULL,
      3.986178,
      NULL,
      0,
      NULL,
      1.105354,
      NULL,
      1.805104,
      NULL,
      NULL,
      0.686518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.537423,
      1.841118,
      0.819201,
      8,
      NULL,
      10,
      17.387535,
      NULL,
      18,
      7.400708,
      NULL,
      NULL,
      NULL,
      NULL,
      4.658501,
      5,
      NULL,
      NULL,
      18,
      NULL,
      13,
      17,
      NULL,
      4.965996,
      NULL,
      NULL,
      3.842307,
      0.780430,
      NULL,
      NULL,
      18.720571,
      NULL,
      0,
      7,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      0,
      2,
      2,
      4,
      38,
      5,
      NULL,
      6,
      '11333',
      '22113',
      '31023',
      NULL,
      '',
      NULL,
      '',
      3.771716,
      '3242',
      '',
      '');
commit;
end;
/


