set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8931056';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '0322211',
      7.845199,
      0.152712,
      2,
      2,
      '4341',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.923823,
      NULL,
      1,
      NULL,
      1,
      ' 0- 7-1976',
      NULL,
      1.372763,
      NULL,
      36.390856,
      1,
      ' 3- 9-1983',
      ' 6-13-2000',
      NULL,
      2.977178,
      0,
      0,
      3.066117,
      0,
      3,
      2,
      1.102757,
      NULL,
      NULL,
      3,
      8,
      0.090917,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      5,
      0,
      0,
      1,
      1.968566,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.662654,
      0.332748,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      4,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      9,
      1,
      0,
      2,
      1,
      1.436827,
      NULL,
      NULL,
      1.786529,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2.876444,
      1,
      0.687188,
      1.060734,
      NULL,
      0.094248,
      0.488940,
      1.563166,
      0.501682,
      1,
      NULL,
      NULL,
      0.678230,
      1.873533,
      2,
      0.385714,
      1,
      NULL,
      0,
      4.327553,
      NULL,
      NULL,
      0,
      0.112952,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      4,
      1,
      4,
      1,
      1,
      NULL,
      4,
      0,
      3,
      9,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0.036108,
      0,
      5,
      NULL,
      1,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      0,
      5,
      2,
      4,
      1,
      2,
      0,
      NULL,
      NULL,
      1,
      8.457505,
      2.344095,
      ' 1-17-1978',
      7,
      ' 2-16-1990',
      NULL,
      1.643379,
      2,
      0,
      3,
      3,
      NULL,
      5,
      0,
      3,
      0,
      4,
      5,
      3,
      0,
      NULL,
      3,
      4,
      7.114174,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.108877,
      3,
      NULL,
      0.617958,
      7,
      1,
      1.311934,
      1.087341,
      0,
      1,
      0.252683,
      NULL,
      NULL,
      NULL,
      0,
      2.346778,
      0.780375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.949761,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      12.652986,
      0,
      1.894735,
      NULL,
      NULL,
      NULL,
      1,
      1.659567,
      2,
      2,
      3,
      0,
      3,
      3,
      2,
      1,
      3,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0.225104,
      0,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907120,
      NULL,
      1,
      1,
      NULL,
      1.429107,
      3,
      8.783303,
      1.315974,
      2,
      2.215689,
      6,
      NULL,
      2,
      3,
      2,
      NULL,
      1.409802,
      43.665859,
      1,
      3,
      NULL,
      24,
      28,
      55.374869,
      2,
      1.228303,
      3.767845,
      '20400',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      NULL,
      28.828225,
      465,
      NULL,
      1.839227,
      18,
      1.717522,
      58.205608,
      0,
      2.776522,
      0.982276,
      1,
      1,
      NULL,
      NULL,
      2.370852,
      0,
      0.802011,
      0.515256,
      1,
      NULL,
      2.829428,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.592581,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.018585,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.045786,
      NULL,
      1,
      NULL,
      NULL,
      1.158995,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      2.148855,
      1,
      3,
      2.468026,
      1.603063,
      2,
      1,
      3.928221,
      0.765172,
      0,
      3,
      0.714066,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.488353,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.633911,
      0,
      2.500646,
      0.142795,
      0,
      3.771001,
      0,
      1,
      2.174103,
      0,
      1.409538,
      4,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557626,
      3,
      3,
      2,
      0,
      0.342167,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.269575,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.002000,
      2,
      1,
      2,
      NULL,
      NULL,
      10,
      2,
      4,
      NULL,
      3.267180,
      0.715350,
      NULL,
      1.466854,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.325095,
      2,
      0.092803,
      1.171637,
      0,
      1,
      0.324642,
      0.422546,
      1.610087,
      NULL,
      0.300543,
      NULL,
      NULL,
      2.092398,
      0.731229,
      0,
      6.252198,
      1,
      0,
      NULL,
      2,
      0.472289,
      3,
      1.155684,
      0,
      0,
      2,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      13.397394,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574285,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.810382,
      NULL,
      NULL,
      1.505475,
      NULL,
      NULL,
      3.913349,
      NULL,
      NULL,
      3.021187,
      NULL,
      NULL,
      1.039822,
      NULL,
      NULL,
      3.570829,
      NULL,
      NULL,
      NULL,
      1.725578,
      NULL,
      0,
      0.573864,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.790132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      3,
      0.971848,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.975758,
      0.484147,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      1.969354,
      NULL,
      NULL,
      3.067825,
      1,
      NULL,
      NULL,
      NULL,
      1.460481,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911002,
      NULL,
      NULL,
      1.375624,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      48.992618,
      1.278649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      13,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.075818,
      NULL,
      0,
      1,
      1.078395,
      1.152935,
      0,
      0,
      NULL,
      0,
      1.061133,
      0.463983,
      0,
      0.026789,
      0.907060,
      NULL,
      0,
      0.486171,
      1,
      1.023457,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.282329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1.625642,
      NULL,
      2,
      2,
      7.579710,
      2.703158,
      2,
      0,
      1,
      0.234099,
      0.310208,
      1,
      NULL,
      NULL,
      0.719978,
      0,
      NULL,
      0.684385,
      0,
      0,
      1.209574,
      0.317182,
      1.957960,
      1.225178,
      NULL,
      1.210317,
      0.234258,
      1,
      3.163330,
      1.140406,
      1,
      0.137592,
      0,
      NULL,
      1.785084,
      0.128797,
      1.627399,
      3,
      0.158692,
      0,
      1,
      3,
      2.230887,
      0,
      NULL,
      1.274821,
      NULL,
      3.502534,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.765830,
      NULL,
      0.079804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.030884,
      NULL,
      3,
      NULL,
      2.287914,
      NULL,
      1,
      NULL,
      NULL,
      12.120721,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830652,
      3.836644,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      71.799313,
      4,
      0,
      3,
      '04423',
      '',
      NULL,
      1,
      '',
      NULL,
      NULL,
      1,
      NULL,
      '',
      '');
commit;
end;
/


