set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8931056';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      '11',
      18.164482,
      9,
      '3333114',
      9.989212,
      NULL,
      2,
      1,
      '3332',
      2,
      0,
      NULL,
      NULL,
      ' 8- 8-1993',
      NULL,
      8,
      NULL,
      NULL,
      1,
      ' 8- 0-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '10-12-2003',
      ' 8-24-1991',
      ' 5-28-1985',
      1.234520,
      2.658692,
      1,
      1,
      NULL,
      2.965026,
      0,
      0,
      0,
      649.234283,
      8,
      5,
      6.297495,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      0,
      0.517166,
      0.107945,
      NULL,
      0.030463,
      0.485245,
      NULL,
      1.340695,
      0,
      5,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      5,
      0,
      NULL,
      5,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      1,
      5,
      0,
      1,
      0,
      4,
      NULL,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      2.561563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891747,
      2,
      2.088822,
      3,
      0,
      NULL,
      1.584545,
      1,
      1,
      0.301521,
      1.092153,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.869611,
      0,
      1.857635,
      NULL,
      2.632777,
      0.248964,
      1,
      3,
      0.758453,
      0,
      0.946893,
      NULL,
      NULL,
      NULL,
      3,
      1.289192,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0,
      3,
      3,
      1,
      0,
      1,
      0,
      1,
      0.176526,
      0,
      1,
      NULL,
      1,
      1.483483,
      0,
      1.395440,
      0.469599,
      0,
      NULL,
      1.759888,
      1,
      0,
      2.923863,
      1,
      10.841202,
      7,
      6.508962,
      4.025264,
      4.833147,
      NULL,
      0.121932,
      NULL,
      7.893656,
      3,
      3,
      2,
      46.201814,
      0,
      NULL,
      61,
      NULL,
      59,
      37.100625,
      0,
      NULL,
      1,
      '32211',
      NULL,
      '',
      1.316981,
      '',
      '',
      '',
      1.442756,
      '',
      '',
      '',
      3.353791,
      27,
      745.485080,
      30,
      1.656204,
      13.023088,
      24,
      14.224658,
      1,
      2.487266,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.659990,
      3.979105,
      1.794497,
      1.491435,
      1,
      1,
      2,
      0.015172,
      NULL,
      1.358982,
      NULL,
      NULL,
      1,
      1.008632,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.696474,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.850013,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.184225,
      2,
      1,
      1.743675,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.492967,
      1.116789,
      NULL,
      NULL,
      NULL,
      NULL,
      2.433876,
      0.249944,
      0.478354,
      3,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.149213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      8,
      3.653336,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.461009,
      NULL,
      1.210308,
      2.515070,
      0.030263,
      NULL,
      3,
      NULL,
      1,
      2,
      NULL,
      1,
      6,
      NULL,
      3,
      1.853821,
      NULL,
      1,
      0.186278,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0.879046,
      2,
      0.169419,
      0,
      NULL,
      NULL,
      NULL,
      10,
      7,
      0.910307,
      0.097562,
      0.271767,
      1.440575,
      3.279399,
      NULL,
      2,
      0.077642,
      NULL,
      NULL,
      4,
      1.105815,
      5,
      NULL,
      2.839633,
      0.770045,
      2,
      1.724414,
      NULL,
      2,
      1,
      1.760337,
      0.302195,
      NULL,
      0.896769,
      4,
      5.728458,
      0.618000,
      NULL,
      2,
      0,
      0,
      3,
      1,
      2,
      3,
      1,
      0,
      0.931059,
      3,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      10.361473,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.271220,
      NULL,
      NULL,
      0.326871,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.481560,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.551754,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206568,
      NULL,
      1,
      1.679841,
      NULL,
      NULL,
      NULL,
      0.053875,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.901416,
      NULL,
      NULL,
      0.942323,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.784029,
      3.963320,
      NULL,
      NULL,
      0,
      1.522716,
      NULL,
      NULL,
      0,
      1.036416,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.372194,
      1,
      NULL,
      NULL,
      NULL,
      1.334898,
      NULL,
      NULL,
      6.593635,
      0,
      NULL,
      NULL,
      0.482313,
      NULL,
      NULL,
      NULL,
      0.207165,
      NULL,
      651.973259,
      NULL,
      NULL,
      0.805118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      226,
      66,
      0.789869,
      NULL,
      NULL,
      NULL,
      10.674019,
      NULL,
      1,
      NULL,
      NULL,
      1.258925,
      0,
      0.751989,
      0,
      1.087758,
      0,
      0,
      0.677130,
      1,
      0.351739,
      0,
      0.863554,
      0.657481,
      0.642964,
      0.568996,
      NULL,
      0.421225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1.870664,
      0.396689,
      2,
      1,
      9.263175,
      2,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0.365666,
      0.632428,
      0.107735,
      1.947584,
      0.045203,
      0.016355,
      1.711623,
      NULL,
      0,
      0,
      3.317449,
      0.951526,
      0.912036,
      1.941428,
      1.471042,
      1,
      0,
      1,
      0,
      NULL,
      0,
      3.880529,
      3,
      1,
      1.896439,
      0.319791,
      3.203167,
      2,
      1.437768,
      NULL,
      NULL,
      0,
      2,
      1.967266,
      0.624284,
      1,
      NULL,
      0.919607,
      0,
      0.582999,
      1,
      NULL,
      NULL,
      0.111168,
      0,
      NULL,
      0.783847,
      0,
      3.057110,
      0.689797,
      3.543703,
      1.055329,
      0,
      1.255715,
      1,
      26,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.267684,
      0.271259,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0.777342,
      3.123686,
      48,
      41.451844,
      1,
      4.982041,
      1,
      '00001',
      NULL,
      '',
      0.257042,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


