set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7620831';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-3-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1320144',
      1,
      0.453667,
      NULL,
      3,
      '4301',
      3,
      0.187614,
      NULL,
      NULL,
      ' 7-20-1981',
      19,
      NULL,
      2,
      1,
      0,
      ' 7- 8-2000',
      40,
      2,
      157,
      180,
      2,
      ' 9-12-2002',
      ' 6-23-1989',
      ' 6-23-1979',
      NULL,
      0.087045,
      3,
      3.820943,
      0,
      3.677199,
      3,
      NULL,
      0,
      35.624725,
      0,
      17,
      4,
      7.671948,
      13,
      5,
      NULL,
      3,
      NULL,
      1,
      0.511964,
      0,
      1,
      1.395032,
      0.358714,
      1,
      1.918870,
      0,
      1.543028,
      1.218884,
      1.557958,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.409105,
      0.444925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      0,
      0,
      4,
      1,
      NULL,
      2,
      NULL,
      1,
      3,
      5,
      1,
      NULL,
      NULL,
      3,
      5,
      4,
      5,
      0,
      NULL,
      5,
      0,
      0,
      NULL,
      1.653880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3.456666,
      1.828722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0,
      3.846329,
      NULL,
      0.536690,
      3,
      0.932315,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.257634,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.494990,
      1.352370,
      NULL,
      1,
      NULL,
      NULL,
      3.270236,
      34,
      NULL,
      0.784179,
      NULL,
      NULL,
      NULL,
      NULL,
      0.337968,
      3,
      2,
      0,
      0,
      3,
      1,
      3,
      2,
      1,
      2,
      0,
      3.572014,
      7.541553,
      3,
      0.282868,
      1.024678,
      1,
      1,
      1,
      0,
      0.911878,
      NULL,
      0,
      1.354620,
      1.660640,
      1,
      3,
      0.611740,
      NULL,
      1,
      NULL,
      5.328630,
      2,
      5,
      1,
      0.818131,
      0,
      NULL,
      5.362979,
      1.093298,
      2,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      52,
      24,
      2,
      1.407041,
      6.333940,
      '20210',
      '12343',
      NULL,
      NULL,
      '',
      '',
      '',
      2,
      NULL,
      '',
      '',
      0.170300,
      53.392546,
      NULL,
      NULL,
      2.395315,
      46.278194,
      8.757402,
      1,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.689576,
      NULL,
      NULL,
      3.186830,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.948101,
      0.097410,
      0,
      NULL,
      NULL,
      1.077180,
      NULL,
      NULL,
      1.314477,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.740570,
      3.636579,
      2,
      1.126934,
      NULL,
      NULL,
      NULL,
      1,
      0.753497,
      0,
      NULL,
      0.338585,
      1.777215,
      0.743181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.683115,
      1.359443,
      0.757493,
      3,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      0.390806,
      2.413700,
      1.734441,
      0.397414,
      0.965459,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.386806,
      NULL,
      NULL,
      2.067675,
      1.699456,
      0,
      NULL,
      1.138455,
      NULL,
      NULL,
      NULL,
      0.029054,
      1,
      0,
      0.655010,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.832253,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      6.198674,
      NULL,
      NULL,
      2,
      1.535524,
      0.701378,
      3.836001,
      1,
      1,
      7,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.640472,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.041774,
      NULL,
      NULL,
      0.038318,
      NULL,
      NULL,
      0,
      0.457176,
      1.522563,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      6,
      0,
      3.707322,
      NULL,
      NULL,
      0,
      0,
      1.462410,
      NULL,
      0,
      1.359006,
      NULL,
      0,
      0.437666,
      3,
      NULL,
      5.747595,
      3,
      2.052998,
      2.718882,
      11,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1.217828,
      0,
      3,
      8,
      6,
      1.350978,
      0.772208,
      1.275230,
      0,
      2,
      NULL,
      0.688258,
      3,
      0,
      1.649331,
      NULL,
      3,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.572543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.798063,
      NULL,
      NULL,
      0.339716,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.975516,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      2.741750,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.180757,
      NULL,
      NULL,
      NULL,
      6.946540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706369,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.584499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.373783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.557291,
      1.110299,
      NULL,
      0,
      NULL,
      NULL,
      0.073671,
      NULL,
      NULL,
      0.990806,
      0.663767,
      NULL,
      NULL,
      0,
      0.533420,
      NULL,
      3.333344,
      1.009990,
      822.090819,
      2.282913,
      1.957253,
      0.401445,
      1,
      0,
      1.329993,
      0.601965,
      1.296268,
      NULL,
      NULL,
      1.423638,
      1.217160,
      1,
      1.303440,
      1.492296,
      0,
      NULL,
      NULL,
      1.517262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      3,
      NULL,
      0.079518,
      NULL,
      124.507525,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.864103,
      0.428136,
      0.232788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.924412,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      3,
      NULL,
      1,
      NULL,
      1.348434,
      NULL,
      437,
      NULL,
      1.084399,
      NULL,
      2,
      NULL,
      2.075469,
      NULL,
      3,
      1.648391,
      2.710092,
      NULL,
      3.292644,
      NULL,
      NULL,
      NULL,
      474,
      NULL,
      3,
      1.212523,
      0,
      NULL,
      NULL,
      NULL,
      0.174774,
      NULL,
      184,
      NULL,
      3.663729,
      NULL,
      0.974221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.630700,
      NULL,
      3,
      0,
      2.158734,
      14,
      NULL,
      0.464119,
      0.513453,
      0.897058,
      1,
      1,
      0,
      1,
      3.198327,
      3,
      2.803226,
      NULL,
      0,
      6.900823,
      3,
      2,
      2.856085,
      NULL,
      1,
      NULL,
      0.742588,
      0,
      1,
      NULL,
      0,
      3,
      1,
      0,
      1.850575,
      0,
      NULL,
      0,
      2.198125,
      0.095274,
      2.428284,
      0,
      NULL,
      2.200326,
      0,
      0,
      1,
      0,
      1.721488,
      3.160769,
      NULL,
      1.885243,
      NULL,
      1.691148,
      NULL,
      NULL,
      1.800379,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      4,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      79,
      NULL,
      0,
      1,
      '01442',
      NULL,
      '20423',
      1,
      '',
      '',
      '',
      0,
      '00304',
      '',
      '');
commit;
end;
/


