set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8900787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '4021234',
      3,
      NULL,
      2,
      2,
      '1431',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-24-1984',
      48,
      NULL,
      NULL,
      1.168696,
      3,
      NULL,
      20,
      3,
      NULL,
      96,
      0,
      ' 6-12-1981',
      ' 8- 7-1992',
      NULL,
      0,
      1,
      1.095408,
      0.870935,
      1.069715,
      2.022421,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9,
      4,
      34,
      27.385305,
      0,
      10,
      2,
      NULL,
      3,
      1,
      NULL,
      1,
      0.600940,
      1.791632,
      NULL,
      NULL,
      NULL,
      1.387358,
      NULL,
      0.223926,
      3,
      3,
      4,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.077245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1.628212,
      NULL,
      0.323170,
      0,
      2,
      1,
      5,
      1,
      5,
      NULL,
      2,
      3,
      0,
      5,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      3,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0.040701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      0,
      NULL,
      5,
      0,
      0.410422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1.513897,
      1,
      0,
      3.095707,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.715135,
      NULL,
      2,
      NULL,
      1.381887,
      0.080345,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.572251,
      0,
      0,
      0,
      0,
      38,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.972751,
      NULL,
      1,
      1,
      3,
      2,
      0,
      0,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      2.435846,
      0,
      1,
      0.173043,
      0,
      1,
      1.687607,
      0.236843,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      3.601808,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.171447,
      NULL,
      14,
      47,
      59,
      NULL,
      NULL,
      5.943334,
      '30433',
      '01032',
      NULL,
      NULL,
      '23322',
      '',
      '',
      0.661727,
      NULL,
      '',
      '',
      NULL,
      NULL,
      2,
      1.955402,
      3,
      NULL,
      NULL,
      3.058021,
      2,
      0,
      NULL,
      NULL,
      0.581679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.922548,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.400253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429275,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.446311,
      NULL,
      NULL,
      0.035919,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654344,
      NULL,
      NULL,
      0.032760,
      NULL,
      NULL,
      0.074828,
      NULL,
      NULL,
      0.374727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093763,
      NULL,
      NULL,
      0.015183,
      NULL,
      NULL,
      0.061822,
      1.904267,
      0,
      0,
      4,
      NULL,
      1,
      0.728958,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.442843,
      0.624479,
      3,
      1.110640,
      3.047234,
      0.553583,
      NULL,
      NULL,
      3.991852,
      6.463469,
      4,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3,
      6,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.047823,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.478427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.667877,
      2.126830,
      0.818083,
      3,
      NULL,
      NULL,
      2,
      3.269128,
      1.253174,
      1.163928,
      1.124246,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.880073,
      3,
      NULL,
      NULL,
      3,
      5.140942,
      5.838734,
      0.410395,
      2.034251,
      0,
      3,
      0,
      1,
      NULL,
      0,
      0.848785,
      0.560965,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449823,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.219368,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.571514,
      NULL,
      NULL,
      NULL,
      0.855806,
      2.897535,
      0.552883,
      0,
      NULL,
      3.664138,
      NULL,
      NULL,
      0.926144,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948375,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.851469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111881,
      0.725609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.454814,
      0.943018,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0.102493,
      NULL,
      NULL,
      NULL,
      1.451247,
      NULL,
      NULL,
      NULL,
      1.970873,
      NULL,
      NULL,
      3,
      0.067291,
      NULL,
      NULL,
      5.509040,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      3.733922,
      51,
      NULL,
      NULL,
      0,
      NULL,
      0.664237,
      NULL,
      NULL,
      3,
      9.785770,
      NULL,
      2.803345,
      42.744448,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      14135,
      937.103301,
      0.644691,
      0.348590,
      0.400213,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1.315785,
      1.792098,
      0,
      0.771576,
      1.318558,
      0.681561,
      NULL,
      1,
      0.865640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.854099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.563073,
      NULL,
      0.514809,
      NULL,
      0,
      NULL,
      0,
      1,
      0.759907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.899909,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564705,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.972693,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7.294354,
      2.022374,
      NULL,
      0.283946,
      2,
      NULL,
      NULL,
      3.735369,
      3,
      1,
      1.690527,
      NULL,
      NULL,
      0,
      2,
      0.678985,
      2.413011,
      2,
      1.245482,
      NULL,
      1,
      3.387272,
      0.869997,
      0,
      1.054432,
      1.546100,
      1,
      1,
      1.586627,
      2,
      0.166085,
      2.839381,
      NULL,
      0.554392,
      1.718381,
      3,
      0.621079,
      0.059852,
      3.002179,
      0,
      0,
      NULL,
      3,
      2.324146,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1,
      1.544715,
      1.777868,
      NULL,
      2,
      3,
      3.038163,
      2.524066,
      NULL,
      0,
      NULL,
      1.330480,
      1,
      1,
      2,
      NULL,
      NULL,
      1,
      2.272350,
      1,
      0,
      0,
      2,
      180.826249,
      0,
      445,
      0.714044,
      0,
      0.314413,
      1.892562,
      NULL,
      NULL,
      NULL,
      6,
      6,
      1.086954,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '40040',
      '00004',
      '',
      1.323178,
      '24042',
      '',
      '',
      1.803263,
      '',
      '',
      '');
commit;
end;
/


