set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8900787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '0322130',
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      ' 1- 8-2000',
      NULL,
      NULL,
      2,
      2.327385,
      1,
      ' 2- 5-1991',
      28,
      1,
      NULL,
      NULL,
      3,
      ' 4- 2-1975',
      ' 9- 6-1992',
      '10-24-1981',
      2.298012,
      NULL,
      2,
      2.097293,
      0.156549,
      0,
      1,
      1,
      0.671302,
      NULL,
      1,
      3.556521,
      2,
      31.524288,
      17,
      4,
      14.129064,
      NULL,
      5,
      0,
      0.458391,
      NULL,
      0,
      NULL,
      0.525692,
      NULL,
      1.100333,
      0,
      3.757891,
      1.086744,
      0.889045,
      NULL,
      3,
      0,
      3.445328,
      NULL,
      0,
      4,
      3,
      5,
      NULL,
      0,
      1,
      1,
      1,
      3,
      3,
      NULL,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.756865,
      NULL,
      0.249069,
      2,
      NULL,
      1.538143,
      0.406979,
      2,
      1,
      0,
      1,
      1,
      0.352466,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1.326314,
      NULL,
      NULL,
      1.945635,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1,
      1.769808,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      5,
      0,
      2,
      4,
      NULL,
      0,
      0,
      2,
      5,
      4,
      0,
      4,
      3,
      2,
      1,
      1,
      3,
      NULL,
      4,
      NULL,
      1,
      0,
      4.713030,
      0,
      ' 7- 6-2000',
      157.752916,
      ' 8-23-2001',
      217.397912,
      2.312202,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      4,
      3,
      1.622207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4,
      NULL,
      1.106017,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.620798,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113173,
      5.896431,
      3,
      4.294638,
      NULL,
      3,
      0.405127,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.552471,
      NULL,
      1,
      2,
      NULL,
      0.019234,
      NULL,
      2.085300,
      70,
      2,
      NULL,
      28,
      47.869490,
      9,
      3,
      NULL,
      0,
      3,
      1,
      3,
      3,
      0,
      1,
      1,
      1,
      1,
      3,
      3,
      1.534800,
      3.035812,
      1.268159,
      1.283116,
      0,
      3.361361,
      0,
      NULL,
      0.985726,
      0,
      NULL,
      0,
      0.760762,
      1.943255,
      1,
      1.229951,
      3,
      0,
      1,
      6,
      1,
      1.422064,
      NULL,
      0,
      2.408224,
      3,
      0.665043,
      1,
      3.284552,
      0,
      30,
      3,
      NULL,
      NULL,
      NULL,
      37,
      46.106237,
      2,
      1.866666,
      NULL,
      '11413',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.893590,
      NULL,
      '',
      '',
      0.485430,
      18.767236,
      NULL,
      13,
      2.480723,
      NULL,
      3.237054,
      0.892960,
      2,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.507824,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.827774,
      0,
      1,
      NULL,
      NULL,
      1.168385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      8.884496,
      1.447442,
      1,
      1.533581,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.414988,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      2.806614,
      NULL,
      1,
      0.426153,
      0.544473,
      0.306930,
      NULL,
      0.783533,
      1,
      1.506477,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.156821,
      NULL,
      NULL,
      0.740873,
      3.557137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.538316,
      NULL,
      NULL,
      NULL,
      0.351653,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.207491,
      NULL,
      NULL,
      7,
      3,
      0.681556,
      NULL,
      3,
      1,
      1.612975,
      NULL,
      NULL,
      0,
      5,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.777732,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.437397,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.387292,
      1.335477,
      1,
      2,
      3.100967,
      3,
      3,
      4.291182,
      NULL,
      5,
      2,
      0,
      NULL,
      NULL,
      0.502260,
      1,
      1.724154,
      2,
      2.969694,
      NULL,
      NULL,
      0,
      NULL,
      2.363305,
      NULL,
      3.373598,
      NULL,
      0,
      2,
      3.349431,
      0.176134,
      NULL,
      1.525290,
      NULL,
      NULL,
      2,
      1,
      2.622887,
      NULL,
      1.950747,
      NULL,
      3.418061,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.173976,
      NULL,
      0.440030,
      1,
      0,
      2.766439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298329,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728881,
      NULL,
      NULL,
      0.236115,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.624671,
      0,
      3,
      0,
      2,
      3.611637,
      2.401353,
      NULL,
      3.804374,
      NULL,
      2,
      NULL,
      5.780327,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110933,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.435521,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.071361,
      0,
      0,
      NULL,
      1.543415,
      NULL,
      NULL,
      NULL,
      3.018012,
      0,
      2,
      NULL,
      0.995604,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      3,
      NULL,
      1.566885,
      NULL,
      2.035820,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      2.359419,
      NULL,
      NULL,
      1.764673,
      1.122352,
      0,
      NULL,
      13.232017,
      0.578767,
      7.641094,
      NULL,
      3,
      0.868038,
      NULL,
      NULL,
      NULL,
      1,
      97.927282,
      6,
      2,
      NULL,
      862.282893,
      1.688255,
      NULL,
      NULL,
      2,
      1566.676652,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186189,
      NULL,
      NULL,
      NULL,
      NULL,
      0.872482,
      465.978944,
      1080.954736,
      NULL,
      NULL,
      1.957005,
      0,
      1.456350,
      1.264968,
      1.741927,
      0.624044,
      1,
      1.584077,
      NULL,
      1,
      0,
      0.874916,
      0.201104,
      0,
      0.973474,
      1.803152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      12.717155,
      6.111739,
      NULL,
      NULL,
      NULL,
      11,
      2,
      3.346386,
      3,
      1,
      1,
      NULL,
      1.607180,
      NULL,
      1.504149,
      1.580614,
      1.838935,
      1,
      NULL,
      0.885874,
      1,
      0,
      0,
      0,
      0,
      0,
      3,
      NULL,
      3,
      0,
      3.652557,
      0,
      1.857261,
      1,
      1.485822,
      1.188170,
      1,
      0.699406,
      2.873500,
      0.140986,
      1,
      0.325761,
      0.973175,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      0.624007,
      0.702011,
      1,
      NULL,
      0.041403,
      3,
      1.635564,
      1,
      NULL,
      1,
      3.110460,
      0.687519,
      0.082284,
      1,
      1.113952,
      NULL,
      NULL,
      0.071354,
      0,
      NULL,
      0,
      1.073020,
      1,
      18,
      1.833783,
      NULL,
      0,
      1.529964,
      2.591694,
      2,
      1,
      NULL,
      4,
      1,
      2,
      1.364729,
      1.557098,
      1.492888,
      23,
      73,
      3,
      NULL,
      3,
      '01130',
      '',
      '',
      0,
      '',
      '',
      '',
      1.824609,
      '',
      '',
      NULL);
commit;
end;
/


