set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8900787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '2421021',
      NULL,
      NULL,
      4,
      2,
      '3403',
      NULL,
      0,
      NULL,
      NULL,
      ' 4- 0-1974',
      23,
      NULL,
      1,
      1.588561,
      NULL,
      ' 2-25-1976',
      12,
      0,
      237.906644,
      NULL,
      1,
      ' 4-22-1983',
      ' 7-28-1993',
      ' 7- 1-1984',
      3,
      3.845911,
      NULL,
      1.154836,
      1,
      1,
      2,
      3.181506,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      20.620001,
      9.842974,
      1,
      3.449723,
      NULL,
      3,
      0,
      0.004107,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      3,
      1.175459,
      1,
      NULL,
      NULL,
      1,
      2.821856,
      NULL,
      0,
      4,
      5,
      1,
      0,
      2,
      1,
      0,
      0,
      2,
      0,
      2.576637,
      1,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      1.848586,
      1.746046,
      1.762333,
      0.828266,
      3,
      1.949415,
      2,
      1.192925,
      1,
      0,
      0,
      0,
      NULL,
      1,
      3,
      1,
      1.965854,
      0,
      1,
      NULL,
      3,
      1,
      2,
      0.600882,
      0,
      NULL,
      NULL,
      1.351270,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0.264921,
      NULL,
      1,
      2,
      0,
      NULL,
      4,
      1,
      4,
      NULL,
      2,
      NULL,
      0,
      2,
      4,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      3,
      NULL,
      1,
      2,
      1,
      0,
      NULL,
      2,
      ' 3-19-1976',
      248.210819,
      ' 5-18-2002',
      198,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      4,
      5.545222,
      2,
      3.369600,
      NULL,
      6.655117,
      7.066433,
      0,
      NULL,
      NULL,
      1.672241,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.405786,
      3.747479,
      0,
      NULL,
      NULL,
      0.218809,
      1,
      1.333415,
      104.159715,
      3.282254,
      0,
      38,
      NULL,
      15.525597,
      0,
      NULL,
      NULL,
      0,
      2,
      3,
      3,
      1,
      0,
      0,
      3,
      1,
      NULL,
      2,
      NULL,
      1.956277,
      1.253680,
      0.734313,
      1,
      NULL,
      1.692834,
      NULL,
      0.088997,
      1,
      0.831010,
      0,
      NULL,
      1.412477,
      1,
      0,
      1.651579,
      1.567695,
      10,
      5.215178,
      NULL,
      NULL,
      2,
      6,
      3.431046,
      0,
      1.181040,
      2.126273,
      NULL,
      3,
      NULL,
      2,
      2,
      NULL,
      15,
      45,
      54,
      3,
      NULL,
      4,
      '21133',
      '22323',
      '',
      1.674939,
      '04140',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      1,
      13.425143,
      77,
      6.411266,
      2,
      13,
      NULL,
      NULL,
      NULL,
      2,
      2.826430,
      3.394525,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.290004,
      3,
      1,
      0.322361,
      NULL,
      NULL,
      1.047599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.083089,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3.136036,
      1,
      2.437588,
      1,
      1.829273,
      1.055474,
      NULL,
      NULL,
      NULL,
      1.079843,
      NULL,
      3.386988,
      3,
      0,
      0.201897,
      3,
      NULL,
      0,
      0.760575,
      1,
      2,
      NULL,
      0,
      NULL,
      0.981494,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.451668,
      NULL,
      NULL,
      6.241609,
      3,
      5.676260,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.585774,
      NULL,
      NULL,
      2,
      2,
      1,
      1,
      0,
      NULL,
      0.372496,
      NULL,
      NULL,
      NULL,
      9,
      5.250179,
      1.620566,
      3,
      0.347051,
      0,
      NULL,
      NULL,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.916902,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681761,
      2.437609,
      NULL,
      NULL,
      2,
      3,
      1.556180,
      3,
      0,
      2.817140,
      0.649125,
      0.330545,
      3,
      0.117833,
      NULL,
      0.127088,
      NULL,
      NULL,
      0,
      3.524125,
      3,
      0,
      2,
      NULL,
      2.777925,
      NULL,
      6.933166,
      NULL,
      7,
      NULL,
      0,
      0,
      2,
      0.645052,
      1.166747,
      1.424597,
      0.748827,
      NULL,
      2.872229,
      NULL,
      NULL,
      1.397228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.520506,
      NULL,
      NULL,
      0.420966,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.729480,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.516584,
      1.813041,
      0.366140,
      1.480648,
      1.881533,
      3.265455,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.826904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.550324,
      NULL,
      NULL,
      NULL,
      2.955633,
      NULL,
      NULL,
      NULL,
      1.776568,
      NULL,
      NULL,
      NULL,
      0.568037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      4.348861,
      NULL,
      NULL,
      NULL,
      1.147005,
      NULL,
      NULL,
      3,
      3.556399,
      NULL,
      3.125959,
      1.969242,
      NULL,
      0.158047,
      NULL,
      NULL,
      NULL,
      2.859193,
      1,
      NULL,
      2.994638,
      NULL,
      8.762559,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.604019,
      13554.039052,
      1633.305923,
      1,
      1.297564,
      1,
      0,
      0.086861,
      NULL,
      0,
      1.387089,
      0,
      1,
      NULL,
      0.951809,
      0.883933,
      1.318290,
      1.630092,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459774,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.167063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.891597,
      0.828078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.916074,
      1.051083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.613189,
      NULL,
      1.871369,
      NULL,
      NULL,
      NULL,
      0.226963,
      NULL,
      NULL,
      NULL,
      1,
      0.527981,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      10.643472,
      0,
      1,
      1.547131,
      NULL,
      8.905059,
      3.207119,
      0,
      1,
      1.945605,
      0.077738,
      NULL,
      NULL,
      1.713177,
      NULL,
      NULL,
      2,
      NULL,
      1.422815,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.728120,
      3,
      NULL,
      1.244672,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.836945,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3.181991,
      1.434696,
      0.649858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3.140624,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2.334367,
      NULL,
      0.468023,
      NULL,
      NULL,
      NULL,
      1.164001,
      NULL,
      3.071709,
      NULL,
      0,
      NULL,
      1.624528,
      NULL,
      1.225337,
      NULL,
      5,
      0.747323,
      NULL,
      0.023923,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      4,
      2,
      2.907843,
      0,
      2,
      56.212618,
      27,
      NULL,
      0,
      4.348787,
      '34413',
      NULL,
      '',
      3.210506,
      NULL,
      '',
      NULL,
      1,
      '',
      NULL,
      NULL);
commit;
end;
/


