set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9106629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '0413334',
      3.333989,
      NULL,
      1,
      3,
      '2333',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 2-1975',
      36.689262,
      NULL,
      NULL,
      2,
      1,
      ' 1-27-1984',
      37,
      NULL,
      142.895249,
      136.327894,
      1,
      NULL,
      NULL,
      ' 6-19-1983',
      0,
      1,
      0,
      0,
      1.084734,
      1,
      2,
      0,
      1,
      1,
      NULL,
      13.219787,
      3.627245,
      1.491594,
      22,
      5,
      9,
      4,
      1,
      6,
      0,
      NULL,
      1,
      1,
      1.334645,
      NULL,
      0.616026,
      0.168788,
      1,
      0,
      1,
      2,
      5,
      2,
      NULL,
      1,
      1,
      1,
      5,
      1,
      0,
      2,
      0,
      NULL,
      0,
      0,
      1,
      4,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.265775,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      1,
      0,
      0,
      2,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      4,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      5,
      0,
      0,
      5,
      1,
      NULL,
      5,
      1.977704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.471166,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      1.743734,
      0.777651,
      2.643724,
      0,
      1,
      1.292257,
      2.074642,
      NULL,
      0,
      NULL,
      0,
      3.115244,
      4.795720,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.716461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.827413,
      0.490065,
      0.791127,
      NULL,
      NULL,
      0.980636,
      1.132596,
      13,
      1.811785,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      1,
      2,
      2,
      2,
      2,
      0,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      1.285922,
      1.422505,
      0.222272,
      0.055903,
      1.334263,
      1.359733,
      0,
      NULL,
      1.942946,
      1.783667,
      NULL,
      0,
      0,
      1,
      0,
      3.232854,
      1,
      NULL,
      NULL,
      1.878944,
      3.949985,
      4,
      2.812118,
      6.577081,
      2,
      2.541924,
      2,
      1,
      0,
      NULL,
      NULL,
      35,
      16,
      NULL,
      2,
      1,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '31000',
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.964421,
      NULL,
      NULL,
      0.230528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.543405,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.213041,
      NULL,
      0,
      1,
      NULL,
      0.014854,
      0.591275,
      1.573184,
      1,
      NULL,
      0.191913,
      0,
      0.503406,
      0.810390,
      1.777977,
      1.580941,
      0.059054,
      1,
      1.947019,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.136344,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      0.951897,
      NULL,
      4.976728,
      5,
      0,
      10,
      NULL,
      1,
      1,
      1.913019,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.768471,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.550265,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.517259,
      0,
      1.006126,
      1.796748,
      NULL,
      1.793318,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.528643,
      NULL,
      1.625898,
      NULL,
      1,
      NULL,
      3.310986,
      NULL,
      NULL,
      NULL,
      22,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.473890,
      NULL,
      1.813281,
      NULL,
      0,
      NULL,
      1.285320,
      NULL,
      0.263119,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.785877,
      2.539291,
      NULL,
      NULL,
      NULL,
      0.781862,
      NULL,
      3.124541,
      NULL,
      0,
      6,
      NULL,
      3.081497,
      3,
      1.844584,
      70,
      38.972719,
      5,
      1,
      2,
      '43410',
      NULL,
      NULL,
      3.116347,
      '44333',
      '',
      '',
      0.040779,
      NULL,
      '',
      '');
commit;
end;
/


