set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '4010343',
      2.823782,
      0.793525,
      0,
      3,
      '0241',
      1,
      0,
      NULL,
      NULL,
      '10-18-1987',
      34.408209,
      NULL,
      5,
      1,
      2,
      NULL,
      30,
      3,
      NULL,
      94.823626,
      1,
      ' 5-21-1980',
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      4.750032,
      28.264225,
      24,
      3,
      NULL,
      3,
      5,
      4,
      0,
      0,
      1,
      NULL,
      0,
      1.172072,
      NULL,
      0.966854,
      0,
      1,
      0.669519,
      0,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      4,
      2,
      0,
      1,
      1,
      NULL,
      2,
      1,
      6.653808,
      NULL,
      1,
      2,
      0,
      0.215356,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      0.656661,
      NULL,
      0.671203,
      1.551306,
      NULL,
      0,
      0.232123,
      1,
      0,
      1,
      NULL,
      1,
      3,
      0.914551,
      0.434717,
      1,
      5,
      NULL,
      1,
      3,
      1,
      NULL,
      1.449793,
      0.668629,
      NULL,
      NULL,
      0.395202,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      4,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0.834154,
      NULL,
      0.553105,
      NULL,
      0,
      NULL,
      5,
      0,
      3,
      5,
      4,
      2,
      5,
      5,
      4,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      2,
      4,
      0,
      4,
      2,
      1,
      NULL,
      4.845608,
      0,
      ' 7-21-1985',
      11.826596,
      ' 7- 9-1983',
      7,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.656202,
      2.238373,
      NULL,
      1.640883,
      5,
      3,
      1,
      NULL,
      1,
      1,
      0.414472,
      4.085274,
      5,
      NULL,
      NULL,
      NULL,
      4.041833,
      NULL,
      NULL,
      NULL,
      NULL,
      0.015553,
      4.056364,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.179973,
      2.539511,
      1,
      0,
      0.933002,
      NULL,
      178.280759,
      1.920354,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.486853,
      2.009336,
      0,
      1,
      0,
      0,
      0,
      0,
      3,
      NULL,
      0,
      1,
      2,
      3,
      0.942080,
      NULL,
      1.232089,
      1,
      0.012552,
      1,
      0.258312,
      NULL,
      0,
      0,
      0,
      1,
      1.231951,
      1,
      0.604733,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      41,
      8,
      51.394592,
      1,
      0,
      2.684082,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.368084,
      25,
      6.564929,
      31,
      1,
      30,
      NULL,
      1.161775,
      4,
      1.220237,
      1.779597,
      0,
      1,
      NULL,
      NULL,
      1.909139,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.500417,
      NULL,
      0.643112,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.719665,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.020483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0.333334,
      NULL,
      1.313778,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0.394135,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.960799,
      NULL,
      NULL,
      6,
      NULL,
      0,
      NULL,
      1.981188,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      0.275836,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      8.163839,
      NULL,
      3.885105,
      3,
      NULL,
      2.438660,
      1.093990,
      1.804598,
      1.344800,
      2.595221,
      1.216935,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658265,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.274250,
      NULL,
      NULL,
      1.922250,
      0.127052,
      0.687939,
      NULL,
      4.017783,
      0,
      4.947452,
      NULL,
      0.434922,
      0,
      NULL,
      NULL,
      3.963579,
      0,
      0.520903,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.468956,
      1.889628,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      1,
      0,
      1.883887,
      3,
      2,
      NULL,
      0.701016,
      1.972471,
      1,
      1,
      1.432392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018598,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.760746,
      NULL,
      NULL,
      1.294097,
      NULL,
      NULL,
      1.767440,
      NULL,
      NULL,
      0.608961,
      NULL,
      NULL,
      0.986346,
      NULL,
      NULL,
      4.136440,
      NULL,
      NULL,
      NULL,
      0.338655,
      NULL,
      0.418314,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.747635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.568519,
      0.101212,
      NULL,
      NULL,
      2.898252,
      NULL,
      NULL,
      NULL,
      1.524051,
      NULL,
      NULL,
      NULL,
      1.202070,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.425998,
      NULL,
      NULL,
      1.289095,
      NULL,
      NULL,
      NULL,
      1.424699,
      0.387356,
      NULL,
      NULL,
      2.608858,
      0.756805,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.217027,
      0,
      NULL,
      NULL,
      3,
      0.667355,
      NULL,
      NULL,
      16,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      9.504114,
      NULL,
      0,
      875,
      NULL,
      0,
      NULL,
      NULL,
      2.325112,
      310.163992,
      NULL,
      1.173614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.237966,
      437.733398,
      1,
      1.806280,
      1.426730,
      1,
      0,
      0,
      1.794451,
      1,
      1,
      1.723238,
      0,
      1,
      1.580920,
      1.109034,
      1,
      0.704508,
      1.646776,
      NULL,
      1.960704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.560585,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886343,
      0.050414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.311088,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1.296000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.900177,
      1,
      1.178764,
      0,
      NULL,
      NULL,
      0.612922,
      0,
      0.608155,
      0.015078,
      1.155892,
      0,
      1.582079,
      1.631544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      7,
      NULL,
      3.107604,
      0,
      3,
      7,
      3,
      NULL,
      2,
      1,
      1.174429,
      1.917033,
      NULL,
      0,
      1,
      0.748954,
      1,
      NULL,
      1,
      1.277643,
      1,
      0.999425,
      1.041591,
      1,
      1.216911,
      1.618752,
      0.634861,
      0.732545,
      1,
      0,
      0.704949,
      1,
      0,
      NULL,
      0.444364,
      0.673983,
      1,
      0,
      0,
      1,
      1,
      0.850453,
      3,
      1.405145,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.932104,
      1,
      0.239181,
      0.356926,
      1,
      0,
      2,
      2,
      5,
      0.350834,
      NULL,
      NULL,
      91,
      159,
      1,
      0.882766,
      1.380418,
      '34310',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.769594,
      '',
      '',
      '');
commit;
end;
/


