set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '0344140',
      0,
      0.533433,
      NULL,
      0,
      '3001',
      0.583486,
      NULL,
      NULL,
      NULL,
      ' 9- 9-1975',
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      113.787361,
      1,
      ' 4-11-2002',
      ' 9- 3-1975',
      '10-11-1997',
      NULL,
      3,
      1.813545,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.240502,
      NULL,
      18,
      0,
      16.840047,
      4,
      0,
      4.072409,
      NULL,
      3,
      NULL,
      0,
      0.574050,
      NULL,
      1.498454,
      1,
      1,
      0,
      0.035909,
      3,
      2,
      2,
      1.470934,
      2,
      0,
      4,
      3,
      4,
      0,
      5,
      2,
      1,
      3,
      NULL,
      NULL,
      10.880925,
      NULL,
      2,
      2,
      0,
      0.810589,
      NULL,
      NULL,
      0.507227,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.293786,
      2,
      NULL,
      0.268896,
      0.480148,
      NULL,
      2.206877,
      NULL,
      2,
      NULL,
      2,
      0,
      0,
      2,
      1.294281,
      1,
      NULL,
      0,
      3,
      3.891502,
      2,
      1,
      1.685326,
      0,
      NULL,
      NULL,
      1.893129,
      NULL,
      NULL,
      5,
      4,
      0,
      1,
      4,
      1,
      3,
      1,
      0,
      NULL,
      4,
      0,
      0,
      5,
      1,
      0,
      1,
      NULL,
      2,
      0,
      1,
      0,
      4,
      5,
      NULL,
      0,
      4,
      3,
      5,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      5,
      0,
      2,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      ' 0-27-1976',
      NULL,
      ' 5- 9-1999',
      NULL,
      2,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      0,
      NULL,
      0,
      3,
      0.235648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.909451,
      1.122229,
      1.095346,
      0,
      2.232454,
      5,
      1.314574,
      0.533482,
      0.568220,
      0,
      NULL,
      5.211253,
      4,
      2.391551,
      0.049603,
      0.760868,
      7.198747,
      4.775132,
      0.414299,
      NULL,
      NULL,
      NULL,
      4.492110,
      1.528284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273406,
      1.892278,
      1.070663,
      1.044056,
      0,
      NULL,
      NULL,
      NULL,
      0.398838,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.494609,
      3.780015,
      3,
      0,
      3,
      NULL,
      1,
      1,
      2,
      2,
      NULL,
      NULL,
      1,
      2.632211,
      NULL,
      NULL,
      0.622298,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.167896,
      1,
      0.468040,
      0,
      0,
      0,
      0.265156,
      NULL,
      1,
      2.588326,
      9.681396,
      1.749388,
      1,
      9,
      3,
      NULL,
      2,
      2,
      0,
      3,
      1,
      13.674885,
      1,
      1.997590,
      NULL,
      29,
      39,
      8.776977,
      5,
      0.328340,
      0,
      '43032',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      9,
      9.838608,
      NULL,
      1.950801,
      32.827539,
      2.762443,
      0.333802,
      5,
      1,
      2,
      1.311369,
      1.186587,
      NULL,
      NULL,
      1.509264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.967087,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.322590,
      0.247043,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.065594,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.304157,
      4.328242,
      1,
      1,
      1.613031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331278,
      0.904267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      NULL,
      0.769056,
      1.989296,
      0,
      3.825667,
      0.567614,
      1.670574,
      NULL,
      1.923336,
      2.068794,
      0.635042,
      0.224796,
      0.597069,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255088,
      NULL,
      NULL,
      6,
      4.191103,
      1.233694,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711407,
      NULL,
      NULL,
      NULL,
      1.964586,
      NULL,
      NULL,
      1.460031,
      0,
      0,
      1,
      NULL,
      1.576031,
      1.046547,
      NULL,
      NULL,
      5,
      6.384363,
      0,
      2,
      NULL,
      0.504409,
      1.669524,
      2,
      0,
      5,
      NULL,
      0.314756,
      0.965070,
      NULL,
      NULL,
      0.808044,
      NULL,
      NULL,
      0.942999,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.310380,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.734528,
      1,
      1.870320,
      0,
      5.822800,
      1.991639,
      4,
      0,
      NULL,
      1.993867,
      NULL,
      NULL,
      0.599764,
      NULL,
      0.772365,
      3.388559,
      1.061731,
      1.532920,
      2.688016,
      0,
      NULL,
      NULL,
      0.952710,
      NULL,
      0,
      NULL,
      NULL,
      0.738238,
      NULL,
      NULL,
      1.858412,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      2.344635,
      1,
      0.307802,
      2,
      0,
      1.164739,
      0.354852,
      0,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0.766667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.041883,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.160228,
      NULL,
      NULL,
      1.154714,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.069061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.122045,
      0.373547,
      1.371010,
      3.124773,
      2.079838,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.411333,
      0,
      NULL,
      NULL,
      0.051242,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.380708,
      NULL,
      NULL,
      0.815639,
      NULL,
      NULL,
      NULL,
      1.851670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525092,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.747093,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.652652,
      1.943341,
      NULL,
      NULL,
      0,
      0.985013,
      NULL,
      NULL,
      3.369450,
      0.331180,
      NULL,
      NULL,
      15.255076,
      0,
      NULL,
      NULL,
      1.038019,
      NULL,
      NULL,
      NULL,
      1.369660,
      13.228355,
      17,
      3,
      1,
      NULL,
      1.379159,
      NULL,
      NULL,
      2.094493,
      6.718535,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.403225,
      NULL,
      1,
      387,
      4,
      0,
      0.424949,
      1.778180,
      0,
      1,
      0,
      1,
      1.414687,
      0,
      1,
      1,
      1,
      0,
      1,
      1.338877,
      1.610944,
      0.742676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864735,
      1.808862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749624,
      NULL,
      NULL,
      0.870347,
      NULL,
      1.437739,
      NULL,
      NULL,
      NULL,
      1.327630,
      NULL,
      0.977674,
      NULL,
      0.181236,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.105107,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.605687,
      1.959653,
      3.857015,
      1,
      3.794654,
      2,
      NULL,
      2,
      1.673693,
      1.115502,
      1,
      NULL,
      1.116025,
      2,
      1,
      3.964529,
      NULL,
      0.329597,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      7.884666,
      1.208906,
      NULL,
      1,
      2,
      11,
      NULL,
      NULL,
      1.983898,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.025972,
      1.072900,
      1.193370,
      1,
      0,
      1.531312,
      1,
      NULL,
      0,
      NULL,
      0,
      0.915299,
      0,
      0.793907,
      1.663713,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      0.190985,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.367557,
      0.430583,
      0.975870,
      0.397371,
      0.460609,
      0,
      NULL,
      4,
      2,
      1.151969,
      NULL,
      NULL,
      NULL,
      105,
      2,
      1.471131,
      0,
      '10443',
      '',
      '',
      0.160985,
      '',
      '',
      '',
      1.016027,
      '',
      '',
      '');
commit;
end;
/


