set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9697949';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '04',
      '13',
      35.152072,
      7.369338,
      '0301402',
      1.982007,
      1.865420,
      3,
      1,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      '10- 2-1974',
      53,
      8,
      NULL,
      2,
      0.345266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 8-12-1991',
      NULL,
      ' 4-18-1991',
      0,
      3.498544,
      NULL,
      2,
      NULL,
      0.527059,
      2,
      0.174538,
      NULL,
      NULL,
      NULL,
      7,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      1,
      NULL,
      4,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      6,
      1,
      NULL,
      NULL,
      1,
      0.869318,
      NULL,
      NULL,
      0.391949,
      NULL,
      NULL,
      NULL,
      1,
      0.279475,
      NULL,
      NULL,
      1,
      2.090677,
      NULL,
      2.027470,
      0,
      3,
      2,
      3.892241,
      1,
      3.961454,
      0.224051,
      1.226414,
      1,
      3,
      4,
      1,
      1,
      1,
      0,
      1,
      2.937916,
      1.226625,
      NULL,
      NULL,
      1.526799,
      NULL,
      NULL,
      0,
      2,
      3,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      1.754821,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0.642882,
      1,
      0,
      1,
      1,
      1,
      NULL,
      5,
      5,
      NULL,
      1,
      0,
      2,
      3,
      3,
      4,
      2,
      0,
      3,
      5,
      2,
      2,
      5,
      0,
      1,
      NULL,
      3,
      NULL,
      '10-14-2001',
      472,
      ' 6-14-1986',
      433.485508,
      1.631268,
      2,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974765,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3.284990,
      0,
      1.813120,
      1,
      0.331185,
      1,
      NULL,
      2.793242,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.392915,
      0,
      NULL,
      NULL,
      1.382213,
      NULL,
      1,
      NULL,
      3.250683,
      0.563146,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.574021,
      2,
      0,
      3,
      2,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1.547238,
      1.469531,
      2.567832,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.650923,
      0.069264,
      0.629705,
      0.551614,
      0,
      0,
      1,
      1,
      3.138409,
      NULL,
      2,
      11.600968,
      6.387434,
      7,
      NULL,
      5,
      2.138283,
      2,
      NULL,
      1.795896,
      2,
      0,
      NULL,
      3,
      NULL,
      24,
      NULL,
      61,
      63,
      4,
      0.419438,
      3.798113,
      '13322',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      59,
      NULL,
      1.805096,
      8.734849,
      0.816758,
      9.664802,
      3,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.680223,
      0,
      0.868388,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.966726,
      NULL,
      0,
      NULL,
      1.770311,
      3,
      0.550089,
      0.152557,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0.436829,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.595200,
      0,
      1.499835,
      NULL,
      NULL,
      NULL,
      1.160947,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.047278,
      0,
      0.907713,
      0.425422,
      0,
      3.167383,
      1.327120,
      0,
      0,
      NULL,
      1.195630,
      3.534666,
      0.792205,
      2,
      NULL,
      1,
      0.881715,
      NULL,
      NULL,
      2.228936,
      NULL,
      NULL,
      4.002225,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.673246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.749626,
      NULL,
      NULL,
      1.406395,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0.157216,
      NULL,
      1.828844,
      0,
      0,
      NULL,
      NULL,
      3.549108,
      0.033446,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.484962,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.148475,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5.429979,
      7,
      1.396450,
      6.159479,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524057,
      0,
      1.764286,
      1.182038,
      NULL,
      0,
      6.888976,
      0,
      4,
      2,
      1.708277,
      2.973263,
      3,
      0.759717,
      0.815109,
      2.639845,
      3,
      0.803833,
      2,
      1,
      1.195355,
      3,
      3,
      0,
      5,
      NULL,
      1,
      NULL,
      3,
      3,
      1.758986,
      0.806707,
      1.171093,
      0.914468,
      0,
      1,
      NULL,
      NULL,
      0.032193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249337,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.182818,
      1,
      1,
      0,
      3,
      0.509050,
      7,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      2,
      NULL,
      2.353520,
      NULL,
      1.833299,
      NULL,
      3.476590,
      NULL,
      0.449787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.080155,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.045027,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.466050,
      NULL,
      NULL,
      NULL,
      3.833813,
      NULL,
      1.569315,
      NULL,
      0.118246,
      NULL,
      0.976730,
      NULL,
      1.458663,
      NULL,
      0.785183,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.611629,
      NULL,
      0,
      NULL,
      0.470701,
      NULL,
      1.194757,
      NULL,
      NULL,
      NULL,
      2.024002,
      45.912464,
      45,
      NULL,
      14.210773,
      10,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.282459,
      NULL,
      NULL,
      1.704659,
      NULL,
      NULL,
      1.401975,
      NULL,
      1,
      NULL,
      1.404581,
      1,
      1.465706,
      NULL,
      0.827243,
      1.842610,
      NULL,
      0.955869,
      0.950887,
      1.888733,
      NULL,
      0,
      NULL,
      1,
      1.716857,
      1,
      0,
      1.014148,
      0.800257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      0.459946,
      1.964892,
      2.103353,
      2,
      0,
      11,
      2,
      NULL,
      0.798188,
      1,
      0.148116,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.950173,
      1.355061,
      NULL,
      1,
      2.657523,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.836114,
      0,
      NULL,
      0,
      0,
      NULL,
      3,
      0.915636,
      NULL,
      NULL,
      1,
      NULL,
      0.541246,
      1,
      1.048776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.976178,
      0.086154,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.266998,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1.374095,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      6,
      3.867716,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      7,
      1.083285,
      NULL,
      NULL,
      0.022243,
      36.159349,
      1,
      0,
      3,
      '41142',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


