set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100613';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '2223033',
      3,
      1,
      1,
      1,
      '1124',
      0,
      1,
      NULL,
      NULL,
      ' 7- 1-1991',
      75,
      NULL,
      3,
      3.952214,
      1.806085,
      '11-28-1997',
      7,
      NULL,
      34,
      104,
      0,
      '11- 7-1997',
      NULL,
      ' 4-14-2002',
      0.836403,
      0,
      NULL,
      0.252642,
      1,
      NULL,
      0,
      1,
      1,
      494.171054,
      5,
      2,
      NULL,
      NULL,
      12,
      NULL,
      16,
      2,
      0,
      5.975873,
      0.097213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      3,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.128602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      5,
      2,
      3,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0.227059,
      1,
      1,
      0,
      0,
      0.650038,
      NULL,
      1.500418,
      1,
      0,
      NULL,
      1,
      2,
      3,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      4,
      1,
      0,
      1,
      0,
      3,
      0,
      2,
      NULL,
      1,
      1,
      0,
      NULL,
      0.854728,
      ' 1- 2-1975',
      1693.128353,
      ' 4- 0-1999',
      210,
      3.321741,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.469442,
      3,
      1.991709,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.784964,
      0.800408,
      2.759961,
      1.941255,
      0.981153,
      NULL,
      NULL,
      NULL,
      NULL,
      1.792200,
      0.263842,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.915871,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      103.519652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      1.196058,
      1.754630,
      NULL,
      0.076330,
      1,
      NULL,
      NULL,
      1,
      0,
      0.131604,
      0,
      1.778853,
      1,
      1,
      1,
      1,
      1,
      0,
      11,
      6.746776,
      NULL,
      7.180260,
      2,
      3,
      0,
      2,
      7.792478,
      0.171646,
      NULL,
      2.666977,
      NULL,
      1,
      1,
      NULL,
      5,
      70,
      86.345782,
      1,
      1.583868,
      1.992584,
      '42224',
      '34344',
      '',
      0.764513,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.994552,
      NULL,
      607,
      0,
      NULL,
      14.988147,
      4,
      225,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.395514,
      NULL,
      NULL,
      1.587649,
      2,
      1,
      0,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.693474,
      NULL,
      NULL,
      1.686904,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      0.579397,
      1,
      1.456731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.608353,
      NULL,
      0.660753,
      0.461092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795647,
      1.811312,
      0.877543,
      2.640316,
      1.421152,
      1.133144,
      1,
      1.680826,
      1.321587,
      0.605421,
      1,
      1,
      1,
      1.902147,
      1.626004,
      0,
      2.796713,
      NULL,
      0.573132,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.356836,
      3.298220,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.803193,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.174714,
      NULL,
      NULL,
      1.943708,
      NULL,
      NULL,
      NULL,
      0.218609,
      3,
      NULL,
      NULL,
      NULL,
      0.302560,
      NULL,
      NULL,
      0.133235,
      NULL,
      NULL,
      1.512185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089574,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.622042,
      2,
      1,
      2,
      5,
      0.113270,
      7.026554,
      3.706173,
      NULL,
      1,
      4,
      3.168083,
      0.445807,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      0.303375,
      1.094537,
      NULL,
      0.192835,
      NULL,
      0.340809,
      0,
      NULL,
      NULL,
      0.773963,
      NULL,
      NULL,
      0.682459,
      NULL,
      NULL,
      4.114834,
      5.938333,
      3,
      2.753606,
      1,
      1.891668,
      1.465444,
      NULL,
      3,
      NULL,
      1.687230,
      1.070030,
      1.601941,
      NULL,
      0.146083,
      NULL,
      NULL,
      3.215999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.746754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.206165,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.616326,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.374709,
      NULL,
      1.981021,
      0,
      1.861009,
      0,
      NULL,
      NULL,
      1.403833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.485286,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.313586,
      NULL,
      NULL,
      NULL,
      0.338357,
      NULL,
      NULL,
      NULL,
      2.967550,
      771,
      8.368988,
      1.787144,
      NULL,
      NULL,
      0.685581,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.156833,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      101,
      3,
      1,
      0,
      0,
      1.297904,
      NULL,
      0,
      0.654071,
      1.651566,
      0.876760,
      0,
      1,
      0,
      1.004164,
      1.871967,
      1,
      0,
      0.880686,
      1,
      0,
      1.508807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.624030,
      2.367575,
      3.324557,
      0,
      2,
      4,
      NULL,
      1,
      NULL,
      1.840062,
      1,
      NULL,
      0.590670,
      0,
      NULL,
      0.236046,
      1,
      NULL,
      1.200395,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.223238,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931333,
      NULL,
      0.356829,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      100.543770,
      3,
      0,
      4,
      '20234',
      '33103',
      NULL,
      1,
      NULL,
      '',
      '',
      0.130153,
      '',
      '',
      '');
commit;
end;
/


