set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9020917';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '1301023',
      0,
      NULL,
      NULL,
      2,
      NULL,
      2.963972,
      NULL,
      NULL,
      NULL,
      ' 1-21-1980',
      NULL,
      NULL,
      4,
      0.530051,
      1,
      ' 4-29-1981',
      56.111315,
      0.220780,
      118,
      32,
      3,
      NULL,
      ' 3-11-1988',
      '10-28-1987',
      3,
      1.339632,
      2,
      2.857917,
      0,
      0,
      NULL,
      0.501318,
      0,
      1,
      1,
      15.977767,
      2,
      7,
      6,
      NULL,
      1.619468,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.625340,
      NULL,
      0,
      NULL,
      NULL,
      1.883270,
      1.258019,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0.855128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.188432,
      1,
      NULL,
      NULL,
      3.696866,
      3.781516,
      0,
      1.201839,
      1,
      1.511657,
      0.820798,
      0.585925,
      0,
      3.426403,
      0.213485,
      0,
      NULL,
      1,
      1,
      1,
      7.737733,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      3,
      NULL,
      2,
      1,
      0,
      0,
      1,
      NULL,
      0,
      2.701470,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      5,
      3,
      0,
      3,
      NULL,
      0,
      3,
      2,
      1,
      NULL,
      4,
      1,
      3,
      0,
      0,
      4,
      1,
      4,
      NULL,
      NULL,
      5,
      5,
      5,
      0,
      0,
      7,
      3,
      ' 3-19-1994',
      3,
      ' 9-13-2003',
      41.543839,
      3.724279,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.407457,
      0.595894,
      NULL,
      0.002039,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.227793,
      3,
      1.600213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.744621,
      1.571416,
      NULL,
      0,
      NULL,
      0.980507,
      1.960281,
      NULL,
      32.450310,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.646042,
      3.609608,
      3,
      3,
      2,
      1,
      0,
      1,
      2,
      1,
      3,
      NULL,
      1,
      1,
      2.480419,
      0,
      0,
      0.321083,
      0,
      0,
      0.518855,
      1,
      0,
      1,
      NULL,
      0.416447,
      1.900660,
      0,
      0.907081,
      3.777610,
      NULL,
      2.926994,
      0,
      2.910808,
      1.168934,
      6,
      7.217211,
      2.612451,
      1.151671,
      6,
      1.596207,
      1,
      NULL,
      18.593065,
      1,
      NULL,
      NULL,
      29,
      46,
      72,
      3,
      0.538622,
      2.548934,
      '14324',
      '',
      NULL,
      0.278802,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      2,
      375.553937,
      NULL,
      3,
      NULL,
      1.516366,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.408504,
      0.424461,
      0,
      NULL,
      NULL,
      NULL,
      1.828532,
      NULL,
      NULL,
      NULL,
      3,
      0.537617,
      NULL,
      NULL,
      NULL,
      1.128842,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.885589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.914955,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.281883,
      NULL,
      0,
      3.597931,
      1.329871,
      1,
      3,
      1.217003,
      0.277532,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.564802,
      0,
      0,
      3,
      0.583519,
      1,
      0.603010,
      NULL,
      2.066617,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.273470,
      1.247321,
      0.567114,
      6,
      2,
      NULL,
      1,
      0.872336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.692836,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.680161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.308855,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.080378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357459,
      2.868549,
      0.041047,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.216374,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.234475,
      NULL,
      2,
      NULL,
      3.696684,
      1,
      1.894526,
      NULL,
      4,
      NULL,
      5.385622,
      2.515550,
      3.648298,
      1.963090,
      2,
      0,
      0.239529,
      NULL,
      0,
      2,
      3.672875,
      2,
      NULL,
      NULL,
      1,
      1,
      1,
      6.195107,
      1.653035,
      2,
      NULL,
      3,
      NULL,
      0,
      1.123759,
      0,
      NULL,
      0.505580,
      NULL,
      NULL,
      0.129116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.820334,
      NULL,
      NULL,
      3.231874,
      NULL,
      NULL,
      0.519153,
      NULL,
      NULL,
      2.238830,
      NULL,
      NULL,
      1.690728,
      NULL,
      NULL,
      5.087914,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.685222,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.652828,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.278087,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.500832,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.081614,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564827,
      NULL,
      NULL,
      3.447940,
      0,
      NULL,
      NULL,
      3.997317,
      0.299521,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.468693,
      NULL,
      NULL,
      1,
      1.202765,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.074795,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5.191234,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.426388,
      NULL,
      NULL,
      0.835600,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.593147,
      12,
      0,
      0,
      0.133130,
      1,
      1,
      1,
      1,
      0.051978,
      1.810942,
      1.122082,
      NULL,
      1.214888,
      1,
      1,
      0,
      1.339516,
      1.514567,
      0.772012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.381918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      2,
      0.082260,
      0.205161,
      NULL,
      2.033571,
      0,
      2.157270,
      0,
      1,
      2,
      1,
      NULL,
      1,
      0.139933,
      0,
      0.135435,
      0.431707,
      0,
      0.257483,
      NULL,
      0,
      1.875494,
      1,
      0,
      NULL,
      0.462278,
      1,
      1.606153,
      1.118438,
      0,
      3.132901,
      0.352844,
      1,
      0,
      NULL,
      1.752395,
      0,
      1.858499,
      1.470600,
      0.388400,
      1.890911,
      1,
      1,
      2.572185,
      1.925256,
      0.561803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686968,
      0.334270,
      NULL,
      NULL,
      1,
      1,
      4,
      5,
      3,
      0.825236,
      NULL,
      NULL,
      30.808368,
      NULL,
      2,
      0,
      NULL,
      '32021',
      '02320',
      NULL,
      1.013724,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


