set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      0.941495,
      3,
      2,
      '1401',
      NULL,
      1,
      NULL,
      NULL,
      ' 3- 9-1987',
      21,
      NULL,
      NULL,
      0,
      NULL,
      ' 3- 2-1984',
      7,
      1,
      120.088520,
      173,
      NULL,
      ' 9-26-1991',
      ' 6-25-2002',
      ' 6-22-1977',
      NULL,
      NULL,
      1,
      2,
      1,
      1.057372,
      1,
      0.796182,
      NULL,
      NULL,
      NULL,
      2.755259,
      3,
      7.802542,
      11.990567,
      5,
      8.807689,
      3,
      NULL,
      0.077370,
      NULL,
      2,
      0,
      0.814220,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      5,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      5,
      0,
      0,
      3,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.220016,
      NULL,
      1,
      2,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      3,
      NULL,
      1,
      1,
      2.832706,
      NULL,
      0.273993,
      1.960224,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      NULL,
      0,
      0,
      0.374323,
      1,
      NULL,
      NULL,
      3,
      2,
      0,
      0,
      4,
      3,
      0,
      5,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.444868,
      1,
      0,
      0,
      0,
      0,
      2,
      NULL,
      0,
      5,
      0,
      NULL,
      0,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      3,
      2,
      3,
      NULL,
      5,
      3,
      5,
      4.556796,
      3.403698,
      ' 6- 1-1996',
      NULL,
      '11-12-1986',
      NULL,
      1.956289,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      20,
      1.754508,
      2,
      0,
      3,
      1.182287,
      0.841472,
      1.503846,
      NULL,
      1,
      3.573935,
      NULL,
      NULL,
      NULL,
      NULL,
      7.869044,
      NULL,
      9.144185,
      1,
      2,
      0,
      4.027260,
      1,
      NULL,
      NULL,
      0,
      9,
      3,
      1,
      3,
      3,
      6,
      ' 9-22-1996',
      NULL,
      NULL,
      NULL,
      1.653876,
      1,
      1,
      0.716212,
      2.954401,
      NULL,
      0.936129,
      0,
      0,
      1,
      3.331400,
      NULL,
      2.244512,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      1,
      3,
      NULL,
      NULL,
      3,
      2,
      NULL,
      2,
      1,
      1.293949,
      5.398911,
      NULL,
      2,
      1,
      0,
      1,
      NULL,
      1.670812,
      0.864734,
      0,
      0.211840,
      1.812683,
      1,
      0,
      1,
      0,
      5.456656,
      NULL,
      4,
      11.164290,
      6.211043,
      9.521129,
      1,
      1.179094,
      1,
      3,
      0.682206,
      1,
      2.467006,
      3.194634,
      12.355402,
      1,
      3,
      NULL,
      NULL,
      17,
      67,
      0,
      0,
      2,
      '00214',
      '4021',
      '',
      0,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      1.286005,
      3,
      9.721198,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.718807,
      3.967515,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.018624,
      3,
      2.770888,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.527215,
      7,
      1,
      0,
      1.342003,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.770919,
      3.096432,
      1,
      3,
      2,
      1.000445,
      NULL,
      2.538412,
      3.718412,
      2,
      NULL,
      2,
      NULL,
      0.090883,
      1.192095,
      3.804891,
      NULL,
      1.032571,
      1.710985,
      3,
      2.764372,
      3.424940,
      NULL,
      0.981380,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.869499,
      0.300982,
      NULL,
      3.344706,
      7,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.810942,
      NULL,
      NULL,
      NULL,
      0.613553,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.419311,
      NULL,
      3.453234,
      1.492319,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.895061,
      NULL,
      NULL,
      0.882501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427031,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.527910,
      1.810005,
      2,
      1.235067,
      NULL,
      NULL,
      2.484147,
      2.577022,
      6,
      1,
      NULL,
      5,
      7.823630,
      3,
      4.735097,
      1.960432,
      NULL,
      NULL,
      2,
      2.922690,
      2,
      2.457565,
      NULL,
      1.475763,
      1,
      2,
      5,
      1.125823,
      3,
      3,
      0,
      NULL,
      1,
      2.411540,
      3,
      3,
      2.587797,
      3.971137,
      NULL,
      NULL,
      0.728691,
      NULL,
      7,
      2.844278,
      NULL,
      1,
      NULL,
      4,
      1.535707,
      0.115225,
      0,
      0.545672,
      NULL,
      1.042482,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562735,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.147746,
      NULL,
      NULL,
      0.660607,
      NULL,
      NULL,
      1.615149,
      NULL,
      NULL,
      3.973556,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.985323,
      0.359164,
      1.052105,
      0,
      0.740270,
      0.428889,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.011208,
      NULL,
      NULL,
      NULL,
      1.852544,
      NULL,
      NULL,
      NULL,
      1.705051,
      NULL,
      NULL,
      NULL,
      3.768051,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.800523,
      NULL,
      NULL,
      NULL,
      1.621375,
      NULL,
      NULL,
      NULL,
      1.136891,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      41.982728,
      NULL,
      3,
      15,
      NULL,
      0,
      NULL,
      NULL,
      0.311580,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.181178,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.672969,
      NULL,
      0,
      1.991645,
      0.470283,
      0,
      1.335297,
      NULL,
      NULL,
      0.750572,
      NULL,
      1.194939,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      1,
      0.631351,
      3,
      1,
      NULL,
      1.913327,
      1.389813,
      0,
      0,
      NULL,
      1,
      1.981640,
      NULL,
      1.660683,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.954598,
      0.234520,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3.562155,
      NULL,
      1,
      0,
      NULL,
      0.153128,
      0.035730,
      NULL,
      0.453061,
      1.247575,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484626,
      NULL,
      1.685271,
      NULL,
      0,
      NULL,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      2,
      66.945285,
      0,
      0.973591,
      5.388971,
      '03011',
      '0004',
      '',
      1.549457,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


