set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6956684';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '3324202',
      3,
      NULL,
      3,
      1,
      '3231',
      1,
      1,
      NULL,
      NULL,
      ' 2-11-1981',
      8,
      NULL,
      0,
      1.999401,
      0.807399,
      '10-27-1974',
      34,
      NULL,
      212,
      151,
      0,
      ' 8-17-2003',
      ' 3-12-1974',
      ' 8- 6-1978',
      3.118154,
      1.596848,
      3,
      1,
      0.497621,
      3.779109,
      NULL,
      NULL,
      1,
      NULL,
      5,
      7.680337,
      5,
      11.185811,
      21,
      5,
      3,
      4,
      NULL,
      5,
      1,
      1,
      NULL,
      1.216731,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      4,
      2.634935,
      5,
      NULL,
      2,
      3,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      1.840107,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      2,
      NULL,
      0.580688,
      1,
      1,
      2.899896,
      0,
      1.740079,
      0,
      NULL,
      1.977496,
      1,
      0.909006,
      NULL,
      1.555723,
      0,
      2.491600,
      3,
      0,
      1,
      3,
      2.732749,
      1,
      NULL,
      1.042037,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      0,
      4,
      1,
      4,
      5,
      1,
      1,
      5,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      5.364758,
      NULL,
      1.033538,
      0,
      0,
      3,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1,
      2,
      1,
      0,
      1,
      5,
      NULL,
      0,
      2,
      0,
      3,
      1,
      2,
      0,
      0.810481,
      ' 2- 2-1990',
      359,
      NULL,
      427.423411,
      1.492775,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435053,
      1,
      NULL,
      0,
      0,
      0,
      1.815426,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.540409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0.291736,
      2,
      0.244500,
      NULL,
      0,
      82.441916,
      0.613656,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.535920,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      NULL,
      2,
      1,
      0,
      2.658633,
      1,
      2.021512,
      4,
      NULL,
      1.771348,
      3.183876,
      0.436290,
      1.315021,
      NULL,
      0,
      1,
      0,
      1.724548,
      0,
      1,
      0,
      0,
      1.006388,
      5,
      8,
      NULL,
      7,
      9,
      2.756354,
      2,
      2,
      NULL,
      0,
      1,
      1,
      NULL,
      2,
      1.774191,
      NULL,
      11,
      1,
      33,
      2,
      4,
      0,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.711418,
      '',
      '',
      NULL,
      0,
      10.506645,
      348,
      1.714773,
      2,
      1,
      10.358980,
      10.391463,
      3,
      0.081211,
      2.498500,
      1.011943,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      2,
      0.937967,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647327,
      0.149728,
      1.554193,
      NULL,
      0.658992,
      NULL,
      NULL,
      0.604490,
      1.267615,
      0.896187,
      3,
      2,
      1,
      0,
      0,
      0.273539,
      1,
      2.050130,
      1,
      9.472380,
      1.009473,
      NULL,
      NULL,
      1.579125,
      NULL,
      NULL,
      NULL,
      0.217102,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2.737883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.203810,
      1,
      0,
      NULL,
      0,
      3.726790,
      NULL,
      1,
      1.709701,
      1,
      1.824757,
      1.650874,
      0.844806,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.114487,
      0,
      0.114908,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.982142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.352378,
      1,
      0.059440,
      0.666284,
      NULL,
      1.424794,
      4,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.344738,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.957187,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.746987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498220,
      NULL,
      NULL,
      0.954439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.219581,
      0,
      NULL,
      NULL,
      1,
      3,
      0.754297,
      NULL,
      7,
      3,
      5.684203,
      NULL,
      NULL,
      0.998010,
      1,
      1.104924,
      0.713481,
      2.820398,
      1,
      1.606369,
      2.024503,
      3.064819,
      3.847202,
      6.759445,
      4,
      4,
      0,
      0.789908,
      1.737682,
      0.869525,
      1,
      NULL,
      1,
      0.105278,
      1,
      0.888198,
      1,
      3.614435,
      NULL,
      NULL,
      3.335386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.716082,
      NULL,
      NULL,
      3.757496,
      NULL,
      NULL,
      3.879937,
      NULL,
      NULL,
      1.761310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1.894895,
      0.567820,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.728254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.081536,
      NULL,
      NULL,
      NULL,
      0.463128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.943670,
      NULL,
      NULL,
      1.606203,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.263847,
      1.498225,
      NULL,
      NULL,
      0.885980,
      NULL,
      NULL,
      NULL,
      0,
      1.402323,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.285131,
      0,
      NULL,
      NULL,
      2.150670,
      NULL,
      0,
      5,
      2,
      108.653801,
      34.585433,
      0.270027,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      8.742785,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8,
      1,
      0,
      NULL,
      0.002799,
      NULL,
      0,
      0.638017,
      1.357744,
      1.420763,
      0.132895,
      NULL,
      1.004671,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.273687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143490,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.645192,
      NULL,
      1.213623,
      NULL,
      0.533308,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.075188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4.454490,
      3.106285,
      1,
      1.182547,
      0,
      4,
      0.846631,
      0.190741,
      0.832663,
      0.319676,
      0.372365,
      3.964158,
      3,
      NULL,
      3,
      0.155353,
      NULL,
      3,
      0.719258,
      0.742089,
      1.987178,
      1.288988,
      2,
      3,
      0,
      0,
      1.215507,
      1.008058,
      2.366888,
      3.513396,
      NULL,
      1.751194,
      1,
      NULL,
      0,
      3.696416,
      1,
      0.832798,
      1.224855,
      1,
      NULL,
      1.331564,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.014384,
      1.475292,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      78.461052,
      9.414447,
      4,
      0,
      NULL,
      '0043',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL);
commit;
end;
/


