set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9624097';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      '30',
      2.863861,
      NULL,
      '2430423',
      3.248617,
      NULL,
      1,
      1,
      '0341',
      2.353155,
      NULL,
      NULL,
      NULL,
      NULL,
      33.122550,
      28,
      NULL,
      1.825612,
      0.456609,
      ' 4-22-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '10- 7-1979',
      '11- 6-1994',
      ' 6- 0-1984',
      1.363106,
      NULL,
      1,
      0.712684,
      1.234936,
      0,
      3,
      2.267431,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.660206,
      1,
      0,
      0,
      1,
      0,
      51.038880,
      1.049382,
      2,
      NULL,
      5,
      0,
      2,
      1,
      0,
      3,
      0,
      3,
      NULL,
      NULL,
      4,
      0,
      0,
      1,
      8.796964,
      0,
      NULL,
      NULL,
      1,
      0.624570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      1,
      2,
      1.578880,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      2,
      0,
      4,
      1,
      1,
      NULL,
      0,
      NULL,
      5,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      ' 3-22-1993',
      177.988152,
      NULL,
      88,
      2.977338,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.314060,
      2.667634,
      0,
      0,
      4.482732,
      NULL,
      2,
      0,
      3,
      1,
      NULL,
      1.342953,
      NULL,
      NULL,
      0.834584,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325862,
      1,
      0.555722,
      1.050323,
      0,
      NULL,
      1.003434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.674188,
      0.021752,
      2,
      2,
      0,
      3,
      NULL,
      0,
      NULL,
      1,
      3,
      0,
      NULL,
      0.816598,
      2,
      1.542181,
      0.345050,
      0.134291,
      NULL,
      1.505593,
      0.497886,
      1,
      0,
      0.742096,
      0,
      NULL,
      0.800757,
      NULL,
      3.716407,
      2.429059,
      1,
      10.454282,
      6,
      5,
      NULL,
      5,
      6.238527,
      3.567972,
      3,
      NULL,
      1.789088,
      NULL,
      0,
      5.062549,
      0,
      3,
      62,
      NULL,
      NULL,
      45.191302,
      1,
      1,
      4,
      '40024',
      '03211',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      9.561962,
      19,
      2,
      1.565875,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979261,
      2,
      0.699253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.344290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235316,
      NULL,
      NULL,
      2,
      1.795936,
      1.148269,
      0,
      NULL,
      NULL,
      0,
      0.180924,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.587017,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      3.005227,
      1,
      1.723970,
      NULL,
      1,
      0.173053,
      3.146206,
      0.544006,
      1,
      3.246329,
      1.227489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006392,
      0.873588,
      NULL,
      3.661333,
      NULL,
      1,
      1.716582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.701590,
      3.157304,
      0.464535,
      3,
      0,
      1.606248,
      1,
      2.909749,
      NULL,
      5,
      3,
      NULL,
      0.099677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808478,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1.054177,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.075944,
      1.808662,
      NULL,
      4.666894,
      5,
      2,
      3,
      3.597950,
      0.109546,
      2.186073,
      0,
      0,
      NULL,
      1,
      3.076440,
      1,
      3.593564,
      1,
      4.677952,
      9.198142,
      3,
      0,
      NULL,
      NULL,
      2.143208,
      3,
      0,
      NULL,
      0,
      1.168166,
      0,
      1.206151,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.908565,
      NULL,
      NULL,
      1.724827,
      NULL,
      NULL,
      2.476137,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.647678,
      1,
      3.459303,
      0.828420,
      1,
      2.000316,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.839776,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.499709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400797,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.505626,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.014189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254621,
      1,
      17,
      NULL,
      0,
      NULL,
      0.111124,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.114952,
      NULL,
      NULL,
      0.796412,
      NULL,
      NULL,
      225,
      62.058095,
      1.571471,
      1.705968,
      NULL,
      NULL,
      1.233512,
      1.799555,
      2,
      NULL,
      1.317444,
      0.160596,
      0.449840,
      1,
      2,
      0,
      1,
      0.764960,
      2,
      0,
      1,
      NULL,
      3,
      NULL,
      1.372047,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      47,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.167604,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.609249,
      NULL,
      3.452594,
      NULL,
      1.357445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.675608,
      NULL,
      2,
      NULL,
      1.311145,
      NULL,
      0.965019,
      NULL,
      1,
      NULL,
      3.257233,
      NULL,
      0.122091,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      NULL,
      1.916299,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.651258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.718733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.044820,
      NULL,
      NULL,
      1.302567,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.584648,
      0,
      NULL,
      0,
      NULL,
      349.606342,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      1.082774,
      0,
      NULL,
      3,
      3.405495,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      3.545747,
      4,
      3.561347,
      3,
      15,
      1.958640,
      0,
      0.881073,
      NULL,
      3,
      NULL,
      NULL,
      2.316048,
      NULL,
      1,
      NULL,
      NULL,
      0.680453,
      NULL,
      NULL,
      3.885832,
      3.193621,
      NULL,
      1,
      1.905497,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.707822,
      NULL,
      1.465158,
      2.724054,
      NULL,
      3.146957,
      2.475740,
      NULL,
      1.152627,
      2,
      NULL,
      2.361481,
      NULL,
      0.008413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496075,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.366986,
      NULL,
      1,
      NULL,
      3.209287,
      NULL,
      1.805355,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      0.033606,
      NULL,
      1.670542,
      NULL,
      NULL,
      NULL,
      1.904719,
      NULL,
      4,
      2,
      0,
      0.948394,
      NULL,
      2.919165,
      NULL,
      NULL,
      2,
      NULL,
      0.803202,
      '40140',
      '32134',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


