set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9790285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      1.023861,
      NULL,
      2,
      2,
      NULL,
      2.516362,
      3.029048,
      NULL,
      '41214414',
      16,
      32,
      '2100031',
      1.675930,
      1,
      NULL,
      2,
      '0302',
      0.615920,
      NULL,
      NULL,
      NULL,
      ' 0-23-1982',
      57.642336,
      48.919512,
      NULL,
      NULL,
      1.798143,
      ' 0-13-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 4- 3-1998',
      0.265440,
      1.780720,
      3,
      1,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      10.362859,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.058536,
      1.554894,
      0.436363,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      5,
      5,
      0.616420,
      3,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      6.740097,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3,
      0.524697,
      1,
      2.132040,
      0,
      1,
      0,
      2,
      0,
      1.073948,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.820755,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      5,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      1.614557,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      2,
      1,
      3,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      2,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      2,
      0,
      4,
      1,
      0,
      NULL,
      10,
      ' 1-26-1990',
      39.651584,
      NULL,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.205430,
      1.522390,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.352534,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      6.408196,
      NULL,
      0.080676,
      NULL,
      NULL,
      NULL,
      NULL,
      6.817279,
      1,
      1,
      1,
      NULL,
      8,
      NULL,
      34.151270,
      ' 6-17-1975',
      57,
      0,
      2,
      0.271041,
      1,
      NULL,
      NULL,
      1.923765,
      0.578541,
      1,
      0.112528,
      0,
      NULL,
      NULL,
      0.452228,
      NULL,
      NULL,
      NULL,
      1,
      0.993456,
      2.271977,
      3,
      3,
      3,
      0,
      2,
      0,
      2,
      1,
      1,
      0,
      3.127462,
      2.887281,
      3,
      1,
      1.507731,
      1,
      0,
      1,
      1,
      0.765691,
      1.615008,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2.995286,
      1.150797,
      3.795754,
      5,
      NULL,
      4,
      11.198178,
      NULL,
      NULL,
      0.601175,
      NULL,
      1.555671,
      3.625357,
      2.738279,
      8.630751,
      1,
      NULL,
      41,
      NULL,
      NULL,
      NULL,
      4,
      4.911214,
      NULL,
      '44104',
      NULL,
      NULL,
      0.898328,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      1,
      85,
      22,
      0.560615,
      11,
      1,
      2,
      1,
      NULL,
      1.915433,
      3,
      1.143377,
      NULL,
      NULL,
      NULL,
      NULL,
      1.169720,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.283043,
      0,
      2,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.124074,
      NULL,
      NULL,
      3.269420,
      5.200485,
      6,
      NULL,
      1.158557,
      NULL,
      NULL,
      NULL,
      NULL,
      3.361823,
      2,
      1,
      1.247069,
      NULL,
      NULL,
      1,
      0,
      0,
      3.901570,
      1.554055,
      NULL,
      2,
      1,
      0,
      3.036871,
      0.336229,
      0.062196,
      3,
      2.257462,
      NULL,
      0,
      1,
      0.506929,
      0.364446,
      2,
      NULL,
      2.552399,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      0.019380,
      NULL,
      NULL,
      NULL,
      0,
      1.083936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.401792,
      NULL,
      NULL,
      3.407564,
      0,
      1.492971,
      2,
      3,
      NULL,
      5,
      5,
      NULL,
      1.761339,
      0.508983,
      0.910047,
      0,
      NULL,
      NULL,
      0,
      1.770380,
      1,
      0.383227,
      NULL,
      NULL,
      0.948334,
      NULL,
      NULL,
      0.140278,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.184128,
      NULL,
      NULL,
      0.753155,
      NULL,
      NULL,
      0.272434,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.707209,
      5,
      0.391905,
      0.693116,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.729034,
      2.503673,
      2,
      0,
      2,
      NULL,
      1.711475,
      6.551014,
      9,
      2.667324,
      3.569107,
      3,
      0.185807,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.497464,
      2.969382,
      5,
      7.724955,
      2.231946,
      3.304276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.639070,
      0,
      0,
      0,
      0.879684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      0.959201,
      0.597271,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.673159,
      NULL,
      NULL,
      NULL,
      0.702601,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.784742,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.925792,
      NULL,
      NULL,
      NULL,
      3.330524,
      NULL,
      NULL,
      NULL,
      0.050866,
      NULL,
      NULL,
      NULL,
      0.340568,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.662281,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.275831,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      4,
      0,
      NULL,
      5,
      2.155236,
      2,
      1.420291,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.258734,
      NULL,
      NULL,
      1.592872,
      NULL,
      NULL,
      1.713922,
      NULL,
      NULL,
      0,
      1.833439,
      0,
      1.616053,
      NULL,
      0,
      0,
      1.656380,
      1.317914,
      1,
      1,
      1,
      1.945300,
      0.253876,
      1.680128,
      1.713730,
      1,
      0.039752,
      0.531792,
      1.164574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.219959,
      3,
      0.148646,
      NULL,
      0.886431,
      2,
      NULL,
      0,
      0.897005,
      NULL,
      1.069304,
      0.821125,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.785576,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2.287612,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.781355,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      NULL,
      34.012289,
      98,
      1,
      2,
      2,
      '32403',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


