set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8834646';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '2313133',
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.899185,
      0,
      NULL,
      NULL,
      '10- 7-1996',
      NULL,
      NULL,
      3,
      NULL,
      0,
      '10-10-2003',
      43.653353,
      NULL,
      151.108347,
      45,
      NULL,
      ' 0- 5-1983',
      '10- 2-2001',
      '11-27-1979',
      0,
      1.523586,
      0.691403,
      0.413623,
      1.634225,
      1.347500,
      0,
      1.689626,
      1,
      16,
      1,
      4,
      13,
      NULL,
      35,
      1,
      18,
      5,
      1,
      1.984418,
      0.194011,
      0,
      1,
      0.580303,
      0.985108,
      0.680622,
      NULL,
      1.777899,
      0,
      1,
      0.389138,
      1,
      1,
      1,
      2.665685,
      2,
      0,
      1,
      1,
      NULL,
      1,
      0,
      2,
      0,
      0,
      0,
      NULL,
      1,
      2,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      3,
      1.240336,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.435567,
      1.681919,
      0,
      1,
      1.799647,
      0.614970,
      NULL,
      1,
      0,
      5.405993,
      0,
      NULL,
      0.419042,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      5,
      0,
      2,
      5,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      7.800808,
      0,
      1,
      0,
      NULL,
      1.195485,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      4,
      2,
      0,
      0,
      NULL,
      5,
      0,
      3,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      4,
      2,
      2,
      1,
      NULL,
      1,
      5,
      3.855202,
      ' 1-25-1995',
      337.622912,
      NULL,
      65.362171,
      0,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      5,
      NULL,
      2.215003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      7,
      NULL,
      1.672831,
      3,
      0.522672,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.872366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.637927,
      1,
      1.075975,
      1,
      NULL,
      1,
      6.100411,
      NULL,
      0.095533,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      15,
      1.742953,
      NULL,
      1.534750,
      NULL,
      0.606196,
      0,
      0,
      0.662285,
      0.468592,
      1.407583,
      1.374392,
      0.667596,
      1,
      NULL,
      13,
      9.407293,
      1.775281,
      6,
      7,
      0.732308,
      1.244343,
      0.278490,
      0.309317,
      1,
      2,
      1,
      3.950685,
      3,
      2.154361,
      33,
      NULL,
      1,
      NULL,
      1,
      71,
      57,
      5,
      1.510795,
      NULL,
      '31040',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.553131,
      0,
      75.180892,
      39.183089,
      0,
      31.907417,
      5.388933,
      3.713166,
      4,
      NULL,
      3.986948,
      2,
      1.707551,
      NULL,
      NULL,
      0.420627,
      NULL,
      NULL,
      1.142736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.928467,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.690780,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.708040,
      NULL,
      4,
      NULL,
      0.725987,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.023741,
      2,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465006,
      1,
      1,
      0,
      0,
      1.134277,
      1,
      NULL,
      1,
      0,
      NULL,
      1.579070,
      1.024845,
      0,
      0,
      0.841982,
      1,
      NULL,
      NULL,
      0.993430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.657323,
      NULL,
      1,
      0.635502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136471,
      NULL,
      NULL,
      3,
      2.840341,
      3,
      0.907769,
      NULL,
      NULL,
      1.704832,
      NULL,
      NULL,
      2.887775,
      2.853661,
      NULL,
      NULL,
      3.461592,
      2.595243,
      1.693755,
      3,
      NULL,
      5,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.847662,
      NULL,
      NULL,
      0.820943,
      NULL,
      NULL,
      1.952512,
      NULL,
      NULL,
      0.094632,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0,
      NULL,
      6.422611,
      0.611331,
      NULL,
      4,
      4.486757,
      5.102812,
      6,
      0,
      0,
      NULL,
      NULL,
      2,
      2.220457,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      2.232928,
      0,
      0,
      1.663956,
      2.331629,
      NULL,
      3,
      2,
      0,
      1,
      0.439765,
      5.525004,
      6.037048,
      2,
      4.967336,
      NULL,
      3,
      3,
      1,
      1.228602,
      NULL,
      NULL,
      1.737748,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.243391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971598,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.111430,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.241885,
      NULL,
      NULL,
      0.105787,
      1.451478,
      NULL,
      1,
      1,
      1.999777,
      1,
      NULL,
      NULL,
      1.636585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959802,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.975903,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.809040,
      8,
      4,
      NULL,
      NULL,
      NULL,
      0.858294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.130319,
      8908,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0.677380,
      1,
      NULL,
      0.826527,
      1.171779,
      0.118265,
      NULL,
      0,
      0,
      0.721999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      4.074430,
      5,
      2,
      NULL,
      0,
      NULL,
      0,
      9,
      1.985944,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1.654218,
      NULL,
      13,
      NULL,
      NULL,
      14.734072,
      3.216027,
      NULL,
      9.260783,
      0.586125,
      NULL,
      NULL,
      1.608932,
      NULL,
      11,
      1,
      NULL,
      3,
      3,
      NULL,
      14.712070,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.737601,
      1.015602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877775,
      NULL,
      NULL,
      NULL,
      1.071031,
      NULL,
      2,
      4,
      2,
      1.426337,
      1.182875,
      0,
      43,
      59,
      NULL,
      1.029583,
      3,
      '02231',
      '',
      '',
      1.951854,
      '',
      NULL,
      NULL,
      1.187836,
      NULL,
      NULL,
      '');
commit;
end;
/


