set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9709528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03',
      NULL,
      NULL,
      NULL,
      '1014323',
      NULL,
      1.388131,
      1,
      1,
      '4422',
      2.172433,
      0.604085,
      NULL,
      NULL,
      '10- 3-2000',
      58,
      NULL,
      NULL,
      3,
      0,
      ' 7-11-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 9- 6-1998',
      ' 7- 5-1976',
      ' 9-28-1979',
      2,
      3.301488,
      NULL,
      1.226777,
      2.770739,
      3,
      NULL,
      NULL,
      1.060493,
      13.582110,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.446295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.321135,
      2,
      0,
      1,
      0,
      1,
      2,
      1,
      0,
      0,
      1,
      1,
      1,
      4.316007,
      NULL,
      2,
      NULL,
      0,
      0.439042,
      NULL,
      NULL,
      1.201579,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.941510,
      0.206768,
      1.863245,
      NULL,
      1.404756,
      NULL,
      0.723099,
      1.352137,
      NULL,
      0.316993,
      1,
      1,
      0,
      NULL,
      0.120278,
      3,
      0,
      NULL,
      2,
      2.182859,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0.960628,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4,
      5,
      4,
      3,
      1,
      0,
      0,
      0,
      ' 9- 7-2001',
      192.278221,
      ' 9-28-1983',
      67,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8.170906,
      0.889877,
      1,
      NULL,
      0.514762,
      0.350340,
      0,
      NULL,
      NULL,
      1,
      1.401857,
      1,
      NULL,
      NULL,
      NULL,
      0.222681,
      2.438988,
      1.922643,
      2,
      7,
      3,
      4,
      0.073438,
      NULL,
      NULL,
      0.876097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457359,
      0.865153,
      1,
      NULL,
      1.458792,
      1.176522,
      1.729458,
      NULL,
      20,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.340462,
      2,
      NULL,
      2,
      2,
      NULL,
      NULL,
      3,
      2,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.137654,
      1.316246,
      NULL,
      NULL,
      0.106437,
      0.810557,
      0,
      1.900527,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0.307151,
      NULL,
      3.542099,
      NULL,
      10,
      3,
      5.925812,
      2.464845,
      5.269597,
      0.727764,
      NULL,
      NULL,
      44.840428,
      1,
      2.158559,
      71,
      NULL,
      5,
      2.372686,
      0,
      NULL,
      1,
      '00343',
      '22411',
      '',
      0,
      '',
      '',
      NULL,
      0.333668,
      '',
      '',
      '',
      3,
      10.500799,
      NULL,
      NULL,
      1.253753,
      29,
      NULL,
      NULL,
      1,
      1.678241,
      3,
      0.861260,
      1.323631,
      NULL,
      NULL,
      2.417405,
      3,
      2.782546,
      1,
      NULL,
      NULL,
      3,
      2,
      1.393421,
      NULL,
      2.026801,
      1.894526,
      0,
      3,
      2,
      1.441551,
      NULL,
      NULL,
      1.337580,
      NULL,
      NULL,
      0.182606,
      NULL,
      NULL,
      0.092560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      5.743504,
      2.347913,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.201995,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.323751,
      NULL,
      1.453143,
      3.127215,
      0,
      1,
      1,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      3.679764,
      0.617162,
      1,
      1,
      NULL,
      NULL,
      2.100640,
      0,
      NULL,
      0,
      1,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.400764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.503769,
      NULL,
      NULL,
      0.631999,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.566973,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.158336,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968097,
      NULL,
      NULL,
      0.718413,
      NULL,
      NULL,
      1.461589,
      NULL,
      NULL,
      0.538087,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      2,
      3.497172,
      0,
      2.471259,
      1.491315,
      2,
      NULL,
      3.489725,
      NULL,
      0,
      0.801631,
      0.867662,
      0,
      NULL,
      3.549413,
      2,
      1.610728,
      0.922790,
      3,
      2,
      2.448000,
      5,
      0,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1.846713,
      0.524772,
      1.289372,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.619640,
      NULL,
      NULL,
      0.678028,
      NULL,
      NULL,
      0.403422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.285646,
      2.872622,
      NULL,
      0,
      0.650983,
      NULL,
      NULL,
      NULL,
      8.224464,
      NULL,
      NULL,
      NULL,
      0.227511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.880440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655201,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736499,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.903440,
      0,
      1.876235,
      3.296260,
      3.912410,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.501986,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.272610,
      888,
      8,
      0.184323,
      0.787911,
      1.523108,
      1,
      1,
      1.697141,
      NULL,
      1.156351,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0.879866,
      0.129034,
      0.538890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.907289,
      NULL,
      0.679674,
      NULL,
      NULL,
      NULL,
      1.381544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.461048,
      1.445798,
      NULL,
      1,
      NULL,
      0.972800,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.962185,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747562,
      3,
      NULL,
      0.821384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809059,
      0.684001,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      78.488575,
      NULL,
      NULL,
      NULL,
      0.042717,
      NULL,
      1.989638,
      NULL,
      2.028671,
      NULL,
      NULL,
      2,
      NULL,
      0.640552,
      6.283132,
      1,
      3,
      NULL,
      1,
      3,
      0,
      1.958367,
      1,
      7.541600,
      2.361685,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.073339,
      0.065429,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.838448,
      NULL,
      0,
      0.662123,
      NULL,
      NULL,
      1,
      NULL,
      1.012657,
      1.181163,
      NULL,
      1.479088,
      NULL,
      NULL,
      2.073778,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.283415,
      1.750052,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1.520105,
      NULL,
      NULL,
      NULL,
      3.863491,
      NULL,
      NULL,
      NULL,
      0.458968,
      NULL,
      3.343138,
      NULL,
      1.712138,
      NULL,
      0.410308,
      NULL,
      0,
      NULL,
      0.131962,
      NULL,
      1.769364,
      NULL,
      31.169957,
      NULL,
      NULL,
      0.836079,
      NULL,
      3,
      NULL,
      1.964715,
      NULL,
      1,
      0,
      NULL,
      1.398827,
      NULL,
      1,
      84,
      90.193663,
      5,
      0,
      NULL,
      '43222',
      '42031',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


