set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7010603';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24',
      0,
      10,
      '1410203',
      2,
      1.163133,
      2,
      0,
      '3402',
      3,
      1.367657,
      NULL,
      NULL,
      ' 9-13-1991',
      10.265823,
      3,
      NULL,
      2.441522,
      1,
      ' 5-23-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 1-18-1999',
      1.193871,
      0,
      1.066223,
      0,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      5.143395,
      6.153469,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.737290,
      NULL,
      2,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.536863,
      0.868809,
      NULL,
      1,
      NULL,
      NULL,
      0.812492,
      5,
      1,
      1,
      5,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1.237187,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.439395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      5,
      NULL,
      1,
      1,
      1,
      1,
      1,
      5,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      4,
      0,
      0,
      NULL,
      1,
      0,
      4,
      1,
      4,
      2,
      3,
      NULL,
      3,
      1,
      2,
      4,
      0,
      1,
      1,
      0,
      0,
      NULL,
      788,
      '10-13-1994',
      593.965408,
      1.557942,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0.001786,
      0,
      5,
      1.051753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.814296,
      0,
      0,
      0,
      1.351217,
      1.817532,
      NULL,
      NULL,
      NULL,
      0,
      0.804949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0.894669,
      1.921356,
      1,
      0.821203,
      0,
      NULL,
      NULL,
      0.034430,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      2,
      3,
      NULL,
      1,
      NULL,
      3,
      2,
      2,
      0,
      1,
      NULL,
      3,
      0,
      0,
      1.346789,
      0,
      0.583629,
      3,
      1.073724,
      NULL,
      1.898610,
      0.086890,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      8,
      1.907437,
      7.859181,
      0.955189,
      6.036967,
      4.357232,
      3.899849,
      2,
      0,
      2,
      3,
      27.394027,
      NULL,
      0.130385,
      29,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      '21233',
      NULL,
      '',
      0.794498,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      67,
      181,
      87.928196,
      1.690143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.554168,
      3.859430,
      1.939953,
      NULL,
      NULL,
      0.307783,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.905340,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.521636,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.137053,
      NULL,
      NULL,
      NULL,
      1.469443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.916517,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.950989,
      NULL,
      NULL,
      1.112945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.781769,
      NULL,
      NULL,
      0.959994,
      NULL,
      3.149716,
      2,
      3,
      2,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      0,
      2,
      1.449133,
      NULL,
      NULL,
      3.056675,
      6.452301,
      6.127697,
      0,
      NULL,
      NULL,
      0.717049,
      NULL,
      NULL,
      0.823464,
      NULL,
      NULL,
      1.377722,
      NULL,
      NULL,
      0.776467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917599,
      3.649194,
      NULL,
      0,
      NULL,
      NULL,
      0.077640,
      NULL,
      NULL,
      NULL,
      0.538323,
      1,
      NULL,
      0.516395,
      0.456639,
      1,
      NULL,
      NULL,
      1,
      1.295833,
      2,
      NULL,
      NULL,
      NULL,
      3.546093,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.047351,
      0,
      2,
      1.139728,
      0,
      0.762248,
      0.048059,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616306,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.106637,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.698790,
      0,
      0,
      NULL,
      1.218591,
      NULL,
      NULL,
      1.585755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.373079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.588725,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.651880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649987,
      0.793052,
      0,
      NULL,
      NULL,
      1.776602,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.061531,
      NULL,
      NULL,
      0.566542,
      NULL,
      NULL,
      1,
      NULL,
      0.274207,
      NULL,
      93,
      1,
      1.045978,
      NULL,
      0.759686,
      1,
      0.549801,
      0,
      0.217344,
      0.867359,
      0,
      0.053753,
      1.912215,
      1,
      0.449188,
      0,
      0.776167,
      0.810065,
      0.278237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.444820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499473,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.547445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.141011,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.219296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.327934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      10.928827,
      2,
      3,
      3.250135,
      NULL,
      5,
      3.557752,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.933061,
      NULL,
      1,
      3,
      NULL,
      0,
      1.976410,
      NULL,
      2,
      3,
      NULL,
      1.019500,
      NULL,
      NULL,
      1.948534,
      0.009733,
      NULL,
      NULL,
      1.392628,
      NULL,
      0.220539,
      1.247171,
      NULL,
      0.271062,
      NULL,
      NULL,
      1.920936,
      1,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.247037,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5,
      4,
      1,
      NULL,
      NULL,
      46.490052,
      65.954218,
      NULL,
      4.863625,
      0.235565,
      '24311',
      '',
      '',
      0,
      '',
      '',
      '',
      1.573583,
      '',
      '',
      '');
commit;
end;
/


