set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8331407';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '3413011',
      0.355277,
      1,
      0,
      0,
      NULL,
      0.095130,
      1,
      NULL,
      NULL,
      ' 6- 1-1985',
      6,
      NULL,
      1,
      3,
      2.117820,
      NULL,
      3.198040,
      NULL,
      4.490092,
      98,
      1,
      '11- 7-1975',
      ' 0- 8-2001',
      ' 0-24-1978',
      0.143726,
      0,
      1,
      2.862036,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.146501,
      1.958094,
      NULL,
      7,
      NULL,
      17,
      3,
      0,
      NULL,
      3.444210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      2,
      4,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      2,
      3,
      2,
      1,
      1,
      0.002204,
      NULL,
      NULL,
      0.096874,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.374654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      4,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      1,
      3,
      3,
      1,
      3,
      3,
      5,
      1,
      0,
      3,
      2,
      2,
      5,
      2,
      NULL,
      2,
      4,
      3,
      4,
      NULL,
      5,
      2.642210,
      1,
      ' 2-28-1994',
      470.001213,
      ' 8- 4-1979',
      42,
      3.341045,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733316,
      0,
      NULL,
      1.467165,
      0.015030,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.601660,
      NULL,
      0,
      1.133228,
      1,
      0,
      3.341091,
      42,
      1.401373,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3,
      1,
      1,
      3,
      1,
      1,
      1,
      1,
      NULL,
      0,
      0,
      5,
      NULL,
      116.633794,
      14.166885,
      163.519793,
      129.593092,
      46,
      31,
      1,
      1.222605,
      0,
      0.563670,
      1.322855,
      1,
      NULL,
      6.070446,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      73.067440,
      5,
      0,
      0,
      '04043',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      93,
      26.750653,
      1.343927,
      NULL,
      NULL,
      1.848364,
      0,
      NULL,
      0,
      0.810914,
      0,
      NULL,
      NULL,
      0.004965,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508042,
      NULL,
      NULL,
      0.030342,
      NULL,
      NULL,
      1.751345,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.468101,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.297950,
      NULL,
      NULL,
      1.665871,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.175802,
      NULL,
      NULL,
      1.619794,
      NULL,
      NULL,
      1.117302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      2,
      1.370681,
      0.301119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460376,
      5.399972,
      4,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.600619,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.528705,
      NULL,
      NULL,
      0.193509,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.093381,
      NULL,
      1,
      1,
      NULL,
      NULL,
      4,
      5.396572,
      5,
      NULL,
      NULL,
      4.246915,
      NULL,
      NULL,
      NULL,
      0.673115,
      0.475786,
      1.366150,
      3.108526,
      1.184651,
      1,
      NULL,
      3.596379,
      3,
      0,
      3.603774,
      4.434486,
      1,
      2.419471,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.370685,
      3.714616,
      NULL,
      2,
      3.721858,
      4,
      3,
      NULL,
      NULL,
      0,
      3,
      1,
      1.870473,
      NULL,
      0,
      0.003061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079975,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.604982,
      NULL,
      NULL,
      0.470440,
      NULL,
      NULL,
      1.397628,
      NULL,
      NULL,
      1.181859,
      NULL,
      NULL,
      0.677655,
      1.670727,
      0,
      1,
      NULL,
      2,
      0.258208,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.264732,
      NULL,
      NULL,
      NULL,
      0.896465,
      NULL,
      NULL,
      NULL,
      0.184299,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.187994,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.947270,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.927628,
      1.625068,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      5.071362,
      NULL,
      1.992192,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1372.579395,
      NULL,
      0.715509,
      1,
      1.769077,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0.681014,
      0.230527,
      0.785661,
      1,
      0.862745,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.000586,
      0.455211,
      0.631698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.693474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.650918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.408060,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.830396,
      NULL,
      1.527265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.885069,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      7.375185,
      5.121185,
      5,
      0,
      3,
      8.361276,
      3.642126,
      0,
      0,
      0.339483,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      0,
      1.712628,
      NULL,
      0.072332,
      3.602209,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.436588,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.941498,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.521256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.348976,
      NULL,
      NULL,
      4,
      NULL,
      0.955952,
      NULL,
      NULL,
      7,
      NULL,
      5,
      0.062052,
      3.411952,
      '43022',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      0.186026,
      NULL,
      '',
      '');
commit;
end;
/


