set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8331407';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-4-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      3.806254,
      0.605482,
      0,
      2,
      '3203',
      0,
      NULL,
      NULL,
      NULL,
      ' 0-10-2001',
      17.570602,
      NULL,
      0,
      NULL,
      1.023928,
      ' 9- 7-1994',
      38.508657,
      5,
      267,
      NULL,
      1,
      ' 4-20-2003',
      ' 9-27-1997',
      ' 7-10-1997',
      0.598579,
      1,
      NULL,
      1.589313,
      0,
      0.477912,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.377638,
      NULL,
      30,
      1.629014,
      2,
      22,
      2,
      0,
      5,
      3.631472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      2,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      2,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      1.774161,
      NULL,
      0,
      0,
      3,
      1,
      1,
      NULL,
      0,
      0,
      0,
      2,
      0,
      0,
      1,
      5,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      0,
      4,
      NULL,
      1,
      1,
      1.828869,
      NULL,
      113,
      ' 7-15-1978',
      NULL,
      0.395021,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.624857,
      1.773803,
      0.926169,
      0.147466,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.290270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058044,
      1.759784,
      NULL,
      NULL,
      0.841630,
      1,
      0.038267,
      0.644608,
      1.573339,
      0.712447,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.225335,
      2.766812,
      NULL,
      1,
      3,
      1,
      NULL,
      1,
      NULL,
      3,
      0,
      2,
      0,
      NULL,
      19.242919,
      185,
      192.782781,
      56.682589,
      20,
      160,
      64.374135,
      NULL,
      1.302010,
      1,
      0,
      1.873647,
      1.167568,
      0,
      5.464643,
      18,
      NULL,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      4.261490,
      2,
      4.768169,
      NULL,
      3.161667,
      0.098153,
      67,
      1,
      3,
      NULL,
      82,
      17,
      NULL,
      2,
      0,
      2,
      '01320',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.524663,
      24,
      238,
      NULL,
      0.128882,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583961,
      NULL,
      3,
      0.006607,
      NULL,
      NULL,
      0.217037,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.783510,
      NULL,
      NULL,
      0.448933,
      NULL,
      NULL,
      1.856358,
      NULL,
      NULL,
      0.498130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.639085,
      NULL,
      NULL,
      1.754677,
      0.927576,
      3.908156,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165498,
      NULL,
      NULL,
      0.366695,
      NULL,
      NULL,
      1.455096,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536736,
      NULL,
      NULL,
      1.205454,
      NULL,
      NULL,
      0.468905,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085115,
      NULL,
      0.315698,
      0,
      1.727412,
      NULL,
      NULL,
      NULL,
      1,
      0.992432,
      1,
      NULL,
      NULL,
      0.419160,
      NULL,
      NULL,
      0.329551,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.182742,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.639699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834078,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.737175,
      NULL,
      NULL,
      1.137161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.316343,
      NULL,
      NULL,
      0.294609,
      NULL,
      NULL,
      0.264400,
      NULL,
      NULL,
      1.664672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      0.058695,
      1.392983,
      NULL,
      NULL,
      4.489476,
      2,
      NULL,
      NULL,
      2.606700,
      0,
      0,
      1.767990,
      1,
      NULL,
      0.781277,
      1.431611,
      2.633841,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.501101,
      NULL,
      NULL,
      0.612554,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.195561,
      NULL,
      NULL,
      1.542411,
      NULL,
      NULL,
      0.755393,
      NULL,
      NULL,
      1.281764,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.290891,
      NULL,
      NULL,
      1,
      2.357173,
      1.546426,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.100206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.174990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975086,
      NULL,
      NULL,
      NULL,
      2.233805,
      3.722598,
      NULL,
      1,
      NULL,
      NULL,
      1.311599,
      NULL,
      NULL,
      0.851958,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.189244,
      NULL,
      0,
      117.872945,
      1.585715,
      0,
      0,
      1.909804,
      NULL,
      0,
      0,
      1.185334,
      0,
      0,
      0,
      1.074858,
      0.729618,
      NULL,
      0.125934,
      1.865637,
      0,
      0.657884,
      1.751461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1.192907,
      0.864129,
      1.178741,
      NULL,
      4,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.381103,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0.290760,
      2,
      NULL,
      0,
      1.812721,
      NULL,
      NULL,
      0.817244,
      NULL,
      NULL,
      0.442516,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0.817691,
      1.442464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63.590759,
      20,
      3,
      0,
      0.844488,
      '43212',
      '',
      '',
      1,
      '',
      '',
      '',
      1.723248,
      NULL,
      '',
      NULL);
commit;
end;
/


