set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8331407';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '3243044',
      2.465975,
      NULL,
      NULL,
      NULL,
      '1444',
      0.647213,
      1,
      NULL,
      NULL,
      ' 6-25-1992',
      44,
      NULL,
      3,
      2.199668,
      1.648584,
      ' 8-24-1988',
      62,
      1,
      NULL,
      29.029410,
      2,
      ' 6-25-1995',
      NULL,
      ' 5-20-1983',
      1.167708,
      NULL,
      0,
      2.223660,
      3.059686,
      1,
      0,
      1,
      0,
      19,
      6,
      5.790311,
      2,
      NULL,
      8,
      0,
      0.019402,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      8,
      1,
      2,
      1,
      1,
      0.711534,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      8,
      NULL,
      0,
      0.025631,
      2.349836,
      3.210063,
      0,
      3.396206,
      2.585058,
      0,
      NULL,
      2,
      1,
      0.469697,
      NULL,
      1.755685,
      0.770662,
      3,
      0,
      1,
      2,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3,
      3,
      NULL,
      4,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      2,
      2,
      1,
      1,
      3,
      2,
      0,
      2,
      NULL,
      4,
      0,
      3,
      0,
      2,
      5,
      2,
      1,
      2,
      0,
      NULL,
      0,
      4,
      1,
      0,
      1.768243,
      0.279027,
      '11- 4-1977',
      NULL,
      ' 5- 5-1977',
      NULL,
      1.599045,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874460,
      0.948139,
      1,
      3,
      0,
      3,
      0.653876,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.626804,
      1,
      1.381860,
      2,
      39,
      1.737329,
      0.926728,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.276810,
      NULL,
      1,
      2,
      0,
      2,
      1,
      1,
      1,
      2,
      3,
      1,
      13.212345,
      19,
      NULL,
      2,
      18.758579,
      3.033594,
      4.224228,
      8,
      0,
      1.199012,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      5,
      NULL,
      0.981730,
      7.785693,
      0,
      6.899615,
      11.643097,
      6,
      1.929065,
      NULL,
      7.661848,
      NULL,
      2.587090,
      2,
      28,
      NULL,
      2,
      NULL,
      22,
      23,
      18,
      1,
      0.607428,
      1,
      '20020',
      '',
      '',
      0.381499,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      3,
      17,
      254,
      26.098625,
      1.017431,
      NULL,
      7.586879,
      4.150909,
      NULL,
      0,
      NULL,
      NULL,
      0.519384,
      NULL,
      NULL,
      1.590935,
      NULL,
      NULL,
      0.959241,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      1.505770,
      NULL,
      NULL,
      0.695458,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.628818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.229867,
      0.741733,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.919789,
      NULL,
      NULL,
      NULL,
      3.032928,
      0.197815,
      1.569729,
      3,
      1.371989,
      1.851990,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.681631,
      1.316965,
      0.093672,
      3.064739,
      3.835381,
      1.315377,
      NULL,
      NULL,
      0,
      0.856086,
      1,
      NULL,
      1.339841,
      NULL,
      1.576456,
      1,
      0,
      0.613552,
      NULL,
      NULL,
      3.418908,
      1,
      1.040167,
      10.420604,
      1.907336,
      0.792152,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.555486,
      2.015816,
      NULL,
      1.883975,
      1,
      NULL,
      0.980975,
      NULL,
      NULL,
      1,
      2.842148,
      NULL,
      3,
      0.760268,
      1.214502,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.407780,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.442740,
      NULL,
      NULL,
      1,
      1.042227,
      0.986959,
      1.711083,
      3,
      2.227121,
      0,
      3.008682,
      1,
      6,
      0,
      3,
      9.395114,
      3.820181,
      1.008113,
      2.657309,
      NULL,
      0,
      1.880067,
      1,
      0.368240,
      3.126671,
      NULL,
      0.620351,
      3.250289,
      NULL,
      1,
      0,
      NULL,
      0,
      3,
      1.866532,
      0,
      1.818046,
      NULL,
      1.305947,
      NULL,
      1.713638,
      1.824698,
      3,
      7,
      4,
      0,
      2,
      1,
      2,
      0,
      3,
      1.022940,
      0,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1.718379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.997780,
      NULL,
      NULL,
      0.503414,
      NULL,
      NULL,
      0.946031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.630947,
      NULL,
      NULL,
      1.219001,
      NULL,
      NULL,
      0,
      NULL,
      1.844765,
      0.328917,
      0.898366,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185510,
      0.775799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.268435,
      0,
      NULL,
      NULL,
      3.933261,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.241736,
      0,
      NULL,
      NULL,
      3,
      1.035851,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.280980,
      1,
      NULL,
      NULL,
      0.690698,
      NULL,
      NULL,
      NULL,
      1.959155,
      1.833957,
      NULL,
      NULL,
      0,
      1.981870,
      NULL,
      NULL,
      1.276377,
      0,
      NULL,
      NULL,
      3.240999,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      7.461651,
      5.858105,
      1,
      NULL,
      NULL,
      0.444333,
      NULL,
      NULL,
      1.919709,
      NULL,
      NULL,
      1.548890,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      119,
      2,
      1,
      1.906470,
      NULL,
      0,
      NULL,
      1.760916,
      0.976255,
      0,
      0.422171,
      NULL,
      0,
      NULL,
      1.528848,
      0.749546,
      1.454832,
      NULL,
      0.507134,
      1.463929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1.639822,
      2,
      2.575135,
      1,
      3.402232,
      1.903830,
      1.726542,
      1.743461,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.148475,
      NULL,
      1.448480,
      1,
      NULL,
      0,
      2.195743,
      NULL,
      1.540762,
      0.272616,
      NULL,
      1.920738,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.328839,
      NULL,
      0,
      1.115952,
      NULL,
      1,
      0,
      0.262795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      5,
      2,
      1,
      NULL,
      3,
      6,
      NULL,
      NULL,
      0,
      NULL,
      '41442',
      '',
      NULL,
      1.241836,
      '',
      '',
      '',
      1.568304,
      '',
      '',
      '');
commit;
end;
/


