set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9030786';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      '0010',
      2,
      1,
      NULL,
      NULL,
      ' 0-29-1998',
      0,
      NULL,
      0,
      2.998919,
      1.964353,
      ' 5-15-2000',
      33,
      4.545061,
      160.139580,
      55.152521,
      2,
      '10-27-1992',
      '10-22-1994',
      ' 7-18-1982',
      1.989147,
      0,
      2,
      NULL,
      1,
      3.880040,
      1,
      1,
      0,
      NULL,
      NULL,
      6,
      6,
      NULL,
      84.059199,
      NULL,
      12,
      2,
      1,
      2.204313,
      1.539941,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1.359301,
      119,
      3,
      5,
      6,
      NULL,
      1,
      4,
      1,
      1,
      NULL,
      NULL,
      4,
      0,
      1,
      0,
      1,
      1,
      3,
      1,
      0,
      1,
      0,
      0.747524,
      NULL,
      NULL,
      1.135876,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.160741,
      1.279653,
      0,
      0.727566,
      NULL,
      NULL,
      3.257337,
      0,
      2.605367,
      3.675775,
      2,
      NULL,
      2,
      3.330877,
      NULL,
      0,
      1,
      1,
      9.115234,
      0,
      2,
      0.445645,
      NULL,
      NULL,
      NULL,
      1.213765,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      3,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      5.998942,
      1,
      0,
      1,
      1,
      1.262058,
      NULL,
      1,
      4,
      5,
      0,
      1,
      NULL,
      5,
      2,
      3,
      0,
      NULL,
      NULL,
      0,
      0,
      4,
      4,
      5,
      0,
      1,
      1,
      NULL,
      0,
      1,
      4,
      NULL,
      NULL,
      7,
      0.532289,
      ' 7-23-1984',
      345.256279,
      NULL,
      850.946787,
      2.115697,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.144552,
      3.647141,
      6,
      3,
      5.486940,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.002512,
      1,
      0,
      NULL,
      NULL,
      2347,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787091,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      1,
      NULL,
      0,
      3,
      2,
      0,
      0.890219,
      1.090084,
      0,
      0,
      0,
      0.187802,
      1.335468,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.366379,
      1.703888,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      26,
      6,
      49,
      3,
      NULL,
      0,
      '44231',
      '',
      '',
      1.846814,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      3.373077,
      NULL,
      3.544426,
      1,
      16.473395,
      NULL,
      40,
      NULL,
      3.409126,
      1,
      2,
      1,
      0.739268,
      1,
      3,
      2,
      3.586954,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      3.003390,
      2.992134,
      1.603725,
      0,
      NULL,
      NULL,
      NULL,
      3.698645,
      1.344975,
      14,
      NULL,
      0.632224,
      NULL,
      0.686686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2.990122,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.801191,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613479,
      0,
      19.683077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      1.259206,
      NULL,
      NULL,
      1.901255,
      NULL,
      3.301118,
      0,
      0.648374,
      0,
      0.118006,
      0,
      NULL,
      2.818881,
      1.802628,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.145229,
      6,
      NULL,
      2,
      NULL,
      0.996872,
      NULL,
      NULL,
      NULL,
      0.653351,
      NULL,
      NULL,
      NULL,
      1.401890,
      NULL,
      NULL,
      0.703167,
      1.138651,
      1.602936,
      3,
      3.351743,
      0.692124,
      0.223663,
      NULL,
      NULL,
      5,
      2,
      0,
      3.763312,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.923660,
      NULL,
      NULL,
      1.073468,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.752347,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.568876,
      0.326646,
      0.377787,
      NULL,
      NULL,
      5.138625,
      2.219221,
      NULL,
      2,
      6.621768,
      2,
      NULL,
      3.686697,
      2.887631,
      3.544780,
      1.592626,
      NULL,
      0,
      2.488831,
      1,
      1,
      3.079355,
      NULL,
      0.666820,
      6.633981,
      7.577257,
      1,
      0,
      0,
      NULL,
      1.221918,
      NULL,
      NULL,
      9.099841,
      18,
      1,
      0.086266,
      1,
      1.289990,
      7.638064,
      NULL,
      3,
      0.375648,
      NULL,
      3.325436,
      1,
      NULL,
      0.946001,
      0.191786,
      0.857667,
      1.639388,
      0.855505,
      0.288236,
      NULL,
      NULL,
      0.561263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.763800,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.956457,
      1,
      1,
      0.411215,
      NULL,
      3,
      0.138035,
      NULL,
      NULL,
      1.409632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.757488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.781226,
      NULL,
      NULL,
      NULL,
      3.971286,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.163706,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.233746,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.988790,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      3,
      2.774903,
      94.711963,
      202,
      0.786633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186363,
      NULL,
      NULL,
      3,
      5.227144,
      3.377061,
      0.609006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.486433,
      0.934010,
      0.881154,
      NULL,
      0.465014,
      NULL,
      1.323533,
      1.416509,
      0.071292,
      0,
      0.569474,
      1.262220,
      1,
      1.823329,
      1,
      0.516524,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      0.232088,
      NULL,
      3,
      1,
      6.236783,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1.295509,
      1,
      NULL,
      NULL,
      2.255882,
      NULL,
      1.852239,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.490946,
      NULL,
      1.300984,
      3,
      NULL,
      0,
      1.400412,
      NULL,
      0,
      1.338305,
      NULL,
      0,
      2,
      NULL,
      0.213552,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.264370,
      NULL,
      1.593968,
      NULL,
      3,
      3,
      7,
      2,
      NULL,
      1,
      20.386203,
      69.408795,
      2,
      1.950016,
      2,
      '04233',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


