set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '3314030',
      3,
      0,
      NULL,
      2,
      '4030',
      2,
      1.793379,
      NULL,
      NULL,
      NULL,
      34,
      NULL,
      2,
      0.897568,
      0.261177,
      ' 9-29-1979',
      15.699729,
      4,
      164,
      76.047061,
      3,
      ' 0-11-1984',
      '10-18-1987',
      ' 6- 4-1979',
      1.374220,
      1,
      NULL,
      0,
      0,
      1.821567,
      3,
      0.869473,
      NULL,
      5,
      6,
      11.047568,
      NULL,
      4,
      14.481382,
      NULL,
      11.661730,
      2,
      2,
      7,
      NULL,
      2,
      1,
      NULL,
      1.807033,
      0.022035,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      2,
      3,
      0,
      2,
      1,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      6.809156,
      0,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      0.670311,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.787164,
      1,
      0.389160,
      0.704839,
      3.497484,
      1,
      1,
      0,
      NULL,
      1.667036,
      0,
      1,
      3,
      NULL,
      0.634618,
      1.407216,
      0,
      0,
      1,
      2,
      1,
      NULL,
      0.186024,
      0.990340,
      NULL,
      NULL,
      1.261680,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1.515246,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0.216507,
      5,
      3,
      0,
      1,
      0,
      4,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      4,
      2,
      4,
      3,
      1,
      2,
      3,
      4,
      NULL,
      3,
      NULL,
      NULL,
      3,
      3.532199,
      NULL,
      ' 9-17-1991',
      21,
      NULL,
      5,
      0,
      1,
      1,
      2,
      1,
      3,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      5,
      1,
      5,
      1,
      4,
      5,
      1.332796,
      3,
      0.448015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      1,
      0.667339,
      7,
      3,
      0.915899,
      2.548486,
      2.584499,
      NULL,
      0,
      4,
      NULL,
      NULL,
      1,
      0,
      2,
      3.871584,
      0.527836,
      NULL,
      NULL,
      0.722202,
      12.904016,
      0.004516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.620774,
      0.216317,
      0.654215,
      0,
      1,
      NULL,
      1.419965,
      2,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2,
      2.893739,
      0.597559,
      3,
      0.257925,
      2.239559,
      0,
      0,
      0.188997,
      NULL,
      1,
      0,
      0.285528,
      NULL,
      1.642958,
      NULL,
      0,
      NULL,
      4,
      2.485537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.351651,
      NULL,
      9,
      52,
      29.442055,
      5,
      1.812893,
      0,
      '33204',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.984515,
      2.933597,
      NULL,
      1,
      NULL,
      NULL,
      0.934121,
      NULL,
      NULL,
      0.369017,
      0,
      NULL,
      1.961642,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.406584,
      NULL,
      0,
      306.716490,
      2.744545,
      1.890736,
      1.205879,
      0,
      NULL,
      1.358120,
      0.936708,
      1,
      1,
      0,
      1.207775,
      1.357240,
      0.933066,
      0,
      0.493975,
      1.655680,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367947,
      0.838197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.666094,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364450,
      0.901503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.091344,
      3,
      NULL,
      1,
      NULL,
      1.978676,
      NULL,
      NULL,
      NULL,
      1.684657,
      NULL,
      0,
      NULL,
      1,
      1.502097,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.174432,
      1,
      NULL,
      NULL,
      0,
      3.645087,
      NULL,
      2.343027,
      1.625166,
      1,
      0.532844,
      NULL,
      1.486271,
      1,
      NULL,
      1.578097,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      2.111584,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.783530,
      NULL,
      0.433692,
      1.503980,
      NULL,
      0.307438,
      1.552302,
      NULL,
      0,
      0.332546,
      NULL,
      0,
      0,
      0.164676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621485,
      NULL,
      0,
      NULL,
      0.740913,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      28,
      33.262914,
      1,
      0,
      2.928622,
      '22332',
      NULL,
      '',
      0.637262,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


