set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.230216,
      4,
      NULL,
      '0004',
      3,
      0,
      NULL,
      NULL,
      ' 2-18-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      0,
      NULL,
      73,
      NULL,
      ' 5-28-2003',
      ' 7-20-1990',
      ' 8-23-1978',
      2,
      0.522173,
      1.762782,
      1,
      0,
      1.122818,
      NULL,
      1,
      1.689577,
      11,
      6,
      16,
      1.221243,
      NULL,
      NULL,
      1,
      21,
      2,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1.383638,
      1,
      NULL,
      NULL,
      1,
      2,
      0,
      4,
      2.712079,
      2,
      0,
      0,
      3,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      5,
      0,
      5.717771,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1,
      5,
      2.359201,
      0.253534,
      NULL,
      0.416776,
      0.218791,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1.045648,
      NULL,
      1.589500,
      NULL,
      NULL,
      1,
      1,
      7,
      NULL,
      NULL,
      1.749800,
      0.131367,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.942899,
      2,
      2,
      1,
      2,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      2,
      1,
      4,
      NULL,
      3,
      2,
      NULL,
      3,
      4,
      1,
      2,
      3,
      3,
      1,
      5,
      1,
      ' 9-16-2001',
      2,
      ' 4-28-1998',
      4.785118,
      NULL,
      0,
      NULL,
      2,
      0,
      4,
      NULL,
      0,
      1,
      0,
      0,
      3,
      1,
      2,
      3,
      NULL,
      3,
      2,
      1,
      NULL,
      1.535009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.684333,
      0.192421,
      0,
      3,
      10.722635,
      3,
      0,
      1.763408,
      0.859961,
      3,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      4.029089,
      2,
      0,
      NULL,
      NULL,
      1.255300,
      3.479887,
      1.359418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881309,
      0,
      0.919083,
      2,
      0,
      1,
      0.339021,
      1,
      2.122788,
      0.073300,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.388113,
      NULL,
      3,
      NULL,
      0,
      1,
      3,
      NULL,
      3,
      2,
      NULL,
      3,
      3,
      0.589380,
      3,
      NULL,
      2.935021,
      1.184265,
      0.814641,
      NULL,
      NULL,
      NULL,
      1.301264,
      0,
      1.701089,
      1,
      1.362561,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      4.366090,
      5,
      3.770396,
      3.892337,
      4,
      1,
      3,
      3,
      3,
      3.754355,
      58.841483,
      1,
      2,
      NULL,
      NULL,
      19,
      42.762674,
      1,
      0.907487,
      4.516014,
      '21023',
      '13313',
      '',
      0,
      '',
      '',
      NULL,
      1.107912,
      NULL,
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.756735,
      NULL,
      0,
      NULL,
      NULL,
      1.970041,
      NULL,
      NULL,
      2,
      NULL,
      0.398116,
      0.764524,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.781978,
      NULL,
      NULL,
      NULL,
      0.581514,
      0,
      1.483480,
      1,
      1.752193,
      1.315649,
      0.735929,
      0,
      1.233745,
      NULL,
      0,
      NULL,
      0.743458,
      0,
      1,
      0.423660,
      0.187128,
      1.495849,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.291134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.171285,
      0.157349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.417362,
      NULL,
      0.752263,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.383007,
      NULL,
      1,
      NULL,
      0,
      0,
      0.336505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669209,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.415825,
      0.636734,
      1.609435,
      NULL,
      0,
      NULL,
      0.990640,
      NULL,
      234,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.190087,
      0.550969,
      0.273744,
      2,
      35,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      1.719994,
      0,
      3,
      3,
      NULL,
      1,
      0,
      1.356287,
      NULL,
      0,
      NULL,
      0.299706,
      NULL,
      NULL,
      1.234919,
      0.798182,
      NULL,
      1.193478,
      1.015741,
      NULL,
      NULL,
      0.542826,
      NULL,
      0.477254,
      3.898443,
      NULL,
      1,
      NULL,
      NULL,
      0.385254,
      0,
      NULL,
      1.435466,
      1,
      NULL,
      NULL,
      1.074384,
      NULL,
      NULL,
      1.486355,
      NULL,
      3,
      1.181063,
      0.271759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.521579,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      86,
      0,
      1,
      NULL,
      NULL,
      NULL,
      '11044',
      '24000',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


