set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9538351';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '0430123',
      0.980115,
      NULL,
      2,
      NULL,
      '4323',
      0,
      1,
      NULL,
      NULL,
      '10-17-1975',
      NULL,
      NULL,
      3,
      1,
      7,
      '10-10-1998',
      NULL,
      2,
      235.707266,
      124,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.560320,
      0,
      0,
      0,
      1,
      2,
      1.583092,
      0.320445,
      16,
      NULL,
      19.800831,
      1,
      NULL,
      19.519328,
      3,
      NULL,
      0,
      3,
      9,
      NULL,
      0,
      0,
      1.060367,
      1,
      1.027155,
      0.681397,
      1,
      NULL,
      NULL,
      1.570957,
      3,
      3,
      7,
      NULL,
      NULL,
      3,
      0,
      4,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      4,
      3,
      2.282240,
      1,
      0,
      1,
      1,
      1.355638,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.617494,
      0.528137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      1.411031,
      0,
      NULL,
      NULL,
      1.775815,
      NULL,
      NULL,
      3,
      3,
      4,
      NULL,
      2,
      0,
      1,
      0,
      0,
      4,
      3,
      3,
      NULL,
      9,
      1,
      0,
      1,
      0,
      0.821592,
      NULL,
      1,
      0,
      NULL,
      2,
      1,
      0,
      4,
      1,
      0,
      5,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      2,
      0,
      NULL,
      0,
      0,
      4.568951,
      NULL,
      ' 9- 7-1985',
      34.968149,
      '10-16-1988',
      16,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.028937,
      0.982741,
      NULL,
      NULL,
      1,
      1.959781,
      0.323878,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619888,
      1.418775,
      1,
      1,
      0.665711,
      NULL,
      NULL,
      1.231928,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.689997,
      3,
      1,
      1,
      3,
      3,
      1,
      1,
      2,
      0,
      2,
      1,
      3.919921,
      0.107859,
      NULL,
      NULL,
      NULL,
      0.641739,
      0.792920,
      0,
      NULL,
      0,
      0.333786,
      1,
      NULL,
      0.675417,
      0,
      0,
      0.335640,
      0.032174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      59,
      NULL,
      NULL,
      NULL,
      NULL,
      2.811596,
      5,
      '43230',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      25,
      NULL,
      0.222232,
      2.729897,
      NULL,
      3,
      0.741163,
      1.420189,
      1.024544,
      2,
      1,
      NULL,
      0.282796,
      1,
      1,
      0,
      0.041242,
      1.439369,
      1,
      2,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      27,
      NULL,
      4.551219,
      NULL,
      NULL,
      0.523736,
      0.961061,
      NULL,
      NULL,
      0,
      NULL,
      0.583870,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.610292,
      NULL,
      1.684412,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.472124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.985268,
      NULL,
      1.308993,
      NULL,
      3.077065,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      82.011509,
      NULL,
      NULL,
      NULL,
      3.284851,
      NULL,
      0.857824,
      NULL,
      3.817068,
      1.064799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      2.954265,
      0,
      17.863506,
      NULL,
      NULL,
      0.624233,
      NULL,
      1,
      3,
      2.224469,
      1,
      2,
      14.178992,
      232,
      NULL,
      NULL,
      0,
      2.961956,
      0,
      0.475844,
      3.395405,
      0,
      11,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      5,
      3.930534,
      NULL,
      0.357087,
      3,
      8,
      2,
      NULL,
      1,
      1.331928,
      3.174111,
      NULL,
      0,
      0.288564,
      NULL,
      0,
      0.408510,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.823509,
      NULL,
      1.298088,
      2.138355,
      NULL,
      0.573862,
      1.919219,
      NULL,
      0,
      1,
      NULL,
      1.826539,
      1,
      NULL,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.024809,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815675,
      NULL,
      NULL,
      NULL,
      0.362033,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      21.497866,
      NULL,
      0,
      2,
      3.563322,
      '31340',
      NULL,
      '',
      1.693008,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


