set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '0014311',
      NULL,
      1.788609,
      0,
      3,
      '4311',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.395995,
      NULL,
      2,
      NULL,
      NULL,
      '10- 7-1984',
      2.142541,
      NULL,
      179.974548,
      79.255960,
      3,
      NULL,
      ' 8-29-1987',
      '11-11-1976',
      0,
      2.932583,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      185.644501,
      5,
      8.190120,
      7.577244,
      15.569392,
      NULL,
      1,
      17.425109,
      3,
      0,
      5.221662,
      1,
      0,
      0,
      NULL,
      1.436477,
      1.884644,
      NULL,
      3,
      1,
      3.313129,
      1.648264,
      0,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      3,
      1,
      4,
      NULL,
      0,
      1,
      0,
      1,
      7,
      1,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      1.488966,
      0.784965,
      NULL,
      1.909284,
      2.474736,
      3.355562,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      0.958318,
      0,
      0.515046,
      1,
      0,
      0,
      1.344942,
      1,
      0,
      1,
      0.318482,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      3,
      5,
      3,
      1,
      4,
      0,
      NULL,
      1,
      3.995138,
      NULL,
      1,
      1,
      1,
      0.545883,
      NULL,
      1.461801,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      4,
      1,
      4,
      1,
      0,
      5,
      5,
      5,
      4,
      NULL,
      2,
      0,
      1,
      2,
      3,
      5,
      2,
      1,
      2,
      4.837443,
      1.650934,
      ' 8- 7-1996',
      3,
      ' 1-25-1980',
      5,
      0,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      4,
      4,
      NULL,
      1,
      1.239157,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.436991,
      1.461304,
      NULL,
      NULL,
      1.910632,
      4,
      0,
      2,
      5,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.700208,
      1,
      1.487493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.366051,
      0.111846,
      1.212654,
      NULL,
      3.558403,
      NULL,
      NULL,
      NULL,
      46,
      2.504649,
      0,
      49.736293,
      NULL,
      NULL,
      NULL,
      1,
      1.865192,
      2,
      2,
      2,
      0,
      3,
      1,
      NULL,
      2,
      0,
      2,
      NULL,
      NULL,
      3.968772,
      1,
      1.807418,
      1.057066,
      3.743989,
      5,
      1,
      0.857868,
      0.389375,
      1.659509,
      0,
      NULL,
      1.993285,
      0,
      1.313519,
      NULL,
      0.027987,
      4.912006,
      NULL,
      7,
      7,
      NULL,
      6,
      3,
      0.216525,
      5,
      1,
      3,
      1.310803,
      NULL,
      2,
      1.196185,
      NULL,
      3,
      40,
      101.511824,
      0,
      0.113167,
      2,
      '44113',
      NULL,
      '',
      1.856247,
      '',
      NULL,
      '',
      1.298824,
      '',
      '',
      '',
      3.346862,
      1,
      535.778087,
      21.767760,
      NULL,
      36.712571,
      38,
      18.467128,
      NULL,
      3,
      2.541934,
      NULL,
      0,
      NULL,
      NULL,
      1.905559,
      1.924574,
      0.022184,
      0,
      NULL,
      0,
      2.881086,
      2.720443,
      1,
      3,
      1,
      0,
      0,
      3,
      NULL,
      3.591074,
      NULL,
      1.091857,
      0,
      NULL,
      NULL,
      1.967424,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.623603,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.278651,
      NULL,
      NULL,
      NULL,
      2,
      3.827943,
      1.301137,
      NULL,
      2,
      0,
      1.132186,
      1,
      0,
      0.587240,
      2.388485,
      2.150607,
      2.157467,
      0,
      2.884361,
      0,
      0.613001,
      1.840486,
      0.490502,
      3,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.355945,
      NULL,
      1.102540,
      10.045102,
      6,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.175921,
      1.426616,
      NULL,
      1,
      0.434259,
      0,
      1.958151,
      NULL,
      3.672082,
      0.703255,
      3.124969,
      1,
      2.187575,
      4.128319,
      NULL,
      2.132257,
      0.283435,
      1.226566,
      1.632492,
      1.473094,
      2,
      2.524070,
      1.000592,
      0.972887,
      NULL,
      NULL,
      1.924028,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.614070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.591668,
      NULL,
      1,
      3.119458,
      0,
      2.371138,
      7.280365,
      NULL,
      2,
      NULL,
      NULL,
      0.603979,
      NULL,
      3,
      NULL,
      2.062652,
      1,
      0,
      NULL,
      3,
      1,
      2.740921,
      NULL,
      NULL,
      NULL,
      8.605610,
      2.703415,
      NULL,
      3,
      NULL,
      3,
      3,
      2,
      0.456601,
      0.935751,
      0.599173,
      1,
      3,
      1,
      NULL,
      7.165171,
      0.782516,
      NULL,
      2.199028,
      1.224434,
      1,
      NULL,
      4,
      0.679355,
      1.479489,
      1.929440,
      NULL,
      1.220906,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539697,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.394928,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.027074,
      NULL,
      NULL,
      1.460269,
      NULL,
      NULL,
      1.043219,
      NULL,
      NULL,
      1.465389,
      1.297629,
      0.256223,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.299303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.890748,
      1.577985,
      NULL,
      NULL,
      3.176226,
      NULL,
      NULL,
      NULL,
      0.503560,
      NULL,
      NULL,
      NULL,
      2.329348,
      NULL,
      NULL,
      NULL,
      1.028603,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.707138,
      1,
      NULL,
      NULL,
      0.685225,
      0.287634,
      NULL,
      NULL,
      1.578188,
      0.389452,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.055209,
      1,
      NULL,
      NULL,
      5,
      2.727142,
      NULL,
      NULL,
      0.918880,
      NULL,
      NULL,
      NULL,
      NULL,
      88.360679,
      51.229718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.523550,
      NULL,
      NULL,
      0.145411,
      109,
      20.034732,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0.038578,
      1,
      0,
      0.714153,
      1.580914,
      NULL,
      NULL,
      1,
      0.803944,
      0.217326,
      1,
      0.127743,
      NULL,
      NULL,
      1.187902,
      0,
      1.348806,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      4,
      2,
      4,
      1,
      3,
      NULL,
      0.387722,
      3.786771,
      2,
      1.690093,
      1,
      1,
      1,
      1.880226,
      1.383421,
      0.834406,
      0,
      NULL,
      0.853408,
      2.034379,
      1,
      1,
      NULL,
      1.417277,
      1.237128,
      1,
      3,
      1,
      0,
      0.348952,
      1,
      3.884182,
      0.168880,
      2.556559,
      2,
      2,
      1.205308,
      NULL,
      1.247354,
      2,
      3,
      1.643836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768652,
      1,
      1.425445,
      NULL,
      NULL,
      0,
      4,
      3,
      7,
      2,
      2.546915,
      1.284560,
      NULL,
      35.654657,
      4,
      1,
      NULL,
      '03344',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      1.323182,
      '',
      NULL,
      '');
commit;
end;
/


