set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40',
      NULL,
      17,
      36.485691,
      '1322030',
      8.223070,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      ' 0-26-1975',
      66.275530,
      9,
      NULL,
      3.755599,
      1,
      ' 2-27-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '11-27-1977',
      ' 7-20-2002',
      ' 4-15-1986',
      3.565357,
      1.211712,
      2.288293,
      0,
      0.153706,
      0,
      1,
      NULL,
      0,
      NULL,
      8,
      17.176375,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      1,
      0,
      1.351760,
      0.007455,
      0.873010,
      NULL,
      NULL,
      1,
      1,
      0,
      4,
      NULL,
      5,
      0.688112,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1.973372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.079680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.788621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      2,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      5,
      1,
      NULL,
      0,
      NULL,
      0.269532,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.761587,
      0.236783,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.063726,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.344548,
      0,
      1.221047,
      1,
      3,
      0.469880,
      0,
      1.876470,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.256968,
      0.067296,
      0,
      NULL,
      2,
      NULL,
      3,
      3,
      3,
      NULL,
      0,
      NULL,
      1.355344,
      NULL,
      NULL,
      NULL,
      0.550346,
      NULL,
      1.857129,
      1,
      NULL,
      NULL,
      1.696624,
      NULL,
      0.179012,
      0.153678,
      1.722065,
      0,
      NULL,
      2.233975,
      0.502119,
      10.880059,
      NULL,
      0,
      4.156828,
      7.951259,
      1,
      3.334108,
      1.501850,
      7,
      1,
      NULL,
      2.645743,
      38,
      3,
      1.916918,
      NULL,
      NULL,
      46,
      86.051782,
      0,
      2.650782,
      NULL,
      '02200',
      '',
      '',
      0.460133,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.235374,
      11.699103,
      441.590892,
      13.349456,
      0.439050,
      22.125441,
      27,
      17,
      NULL,
      3.573769,
      2.852407,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.390372,
      1.224567,
      NULL,
      NULL,
      1.251665,
      NULL,
      0,
      2,
      3.438401,
      0.565540,
      NULL,
      3.538238,
      3,
      1.798681,
      1,
      1,
      0.053705,
      1,
      NULL,
      NULL,
      1.279023,
      NULL,
      NULL,
      0.949296,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      10,
      1.001191,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.444848,
      NULL,
      NULL,
      NULL,
      1.864221,
      2,
      1,
      3,
      0.086068,
      NULL,
      3.689481,
      3.356654,
      1,
      NULL,
      NULL,
      3.172550,
      NULL,
      NULL,
      0.437591,
      1.907973,
      0.529970,
      0.477772,
      NULL,
      2.801673,
      1,
      0,
      3,
      2.559698,
      1.166167,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.127597,
      0.232151,
      8.126230,
      5.799325,
      1.026580,
      0,
      1.241225,
      NULL,
      NULL,
      NULL,
      0.507629,
      NULL,
      NULL,
      NULL,
      0,
      1.427225,
      NULL,
      3.923954,
      2.505892,
      0.959407,
      1.568777,
      3,
      1,
      0,
      1.510335,
      3.910001,
      NULL,
      4,
      3.075933,
      NULL,
      2.744909,
      NULL,
      0,
      0,
      1,
      9.646317,
      NULL,
      NULL,
      1.997220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850750,
      NULL,
      NULL,
      0.255539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.772010,
      NULL,
      NULL,
      1,
      0.341530,
      2,
      1.371482,
      1.269473,
      NULL,
      1.970955,
      0.497632,
      0.975966,
      3.430220,
      NULL,
      0.230343,
      3,
      0,
      1.868618,
      1.546070,
      3.109993,
      2.195313,
      3,
      NULL,
      0,
      8.825289,
      1,
      2.834835,
      NULL,
      2.020373,
      1.304714,
      2.676497,
      NULL,
      0,
      3.360231,
      1,
      0.576011,
      0.603236,
      3,
      NULL,
      6.723484,
      1,
      2.437800,
      1,
      3,
      0,
      0.941034,
      4,
      1,
      0.343769,
      2.308318,
      1.979673,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.886095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.818256,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.172888,
      0.756077,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.319587,
      2.214130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      2.269705,
      NULL,
      NULL,
      NULL,
      2.800823,
      NULL,
      NULL,
      NULL,
      2.260368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507594,
      3,
      NULL,
      NULL,
      1.402733,
      0.921342,
      NULL,
      NULL,
      0,
      1.192573,
      NULL,
      NULL,
      0.147725,
      1,
      NULL,
      NULL,
      1.307937,
      0,
      NULL,
      NULL,
      1,
      3.766149,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5.406613,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.401057,
      528,
      54,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.607725,
      NULL,
      16,
      0.252929,
      NULL,
      NULL,
      1,
      NULL,
      1.085372,
      0,
      1.124554,
      1.075940,
      1.475912,
      0.116461,
      0.430260,
      NULL,
      1.413322,
      1.409554,
      NULL,
      1,
      NULL,
      NULL,
      0.201668,
      0.415002,
      1.966989,
      0,
      1.566024,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.804276,
      2.317855,
      0.212591,
      4,
      NULL,
      NULL,
      0,
      1.998359,
      2,
      1,
      NULL,
      3,
      NULL,
      0,
      1.400811,
      1,
      1,
      0,
      NULL,
      1.102944,
      1.784138,
      0,
      NULL,
      NULL,
      1.440266,
      1,
      0,
      1.550199,
      1.167047,
      0,
      0.352408,
      3.524693,
      3,
      1,
      2.841688,
      0,
      3.219991,
      0.187678,
      NULL,
      1,
      1.144969,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.313372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.143933,
      1,
      0,
      1.084713,
      NULL,
      1,
      4,
      2.813787,
      NULL,
      3,
      1.461582,
      98,
      0,
      NULL,
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


