set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '3241200',
      3.953835,
      1.258545,
      3,
      1,
      '3213',
      1.623480,
      1,
      NULL,
      NULL,
      ' 1-27-1999',
      52.774382,
      NULL,
      4,
      1.974028,
      0.892058,
      ' 8-25-1987',
      35.781081,
      2.382423,
      3.937743,
      29,
      3,
      ' 2-28-2001',
      ' 9-10-1987',
      ' 0-20-1981',
      2.435780,
      0.914760,
      2,
      1,
      1.605099,
      0,
      NULL,
      2.083765,
      NULL,
      NULL,
      NULL,
      6.296498,
      1,
      NULL,
      23.559468,
      5,
      19,
      0,
      2,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.624264,
      1,
      1.659420,
      0.146613,
      0.195819,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      4,
      1,
      0,
      1,
      NULL,
      0.980342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.573514,
      0.171811,
      1.810553,
      3,
      0,
      1.834113,
      2.061308,
      1.355559,
      0.945329,
      1.910934,
      3.261685,
      1.848621,
      NULL,
      NULL,
      NULL,
      0.400353,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1.462687,
      NULL,
      NULL,
      0.295943,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      4,
      5,
      1,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.721306,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      2,
      1,
      5,
      3,
      1,
      1,
      2,
      0,
      5,
      5,
      1,
      0,
      1.494923,
      2,
      ' 8- 3-1983',
      54.470796,
      ' 8- 1-1982',
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.288490,
      1.043768,
      0,
      0.965558,
      1.350444,
      NULL,
      NULL,
      NULL,
      0.939152,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.896563,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.200158,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.570008,
      1.015975,
      0,
      1,
      0,
      3,
      1,
      2,
      3,
      2,
      0,
      1,
      5.651595,
      1,
      0.083280,
      NULL,
      1.725706,
      1,
      2,
      1,
      0.043540,
      1.500457,
      0.969973,
      0.101611,
      1,
      0.944051,
      0.560123,
      0,
      NULL,
      2.945447,
      1.102060,
      NULL,
      4,
      5.097546,
      4.853898,
      1,
      2.245343,
      3.535109,
      NULL,
      2.640710,
      2,
      NULL,
      0,
      68.327347,
      0,
      1,
      NULL,
      66,
      82,
      NULL,
      0,
      0,
      2,
      '31020',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      18.759334,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.172090,
      NULL,
      NULL,
      1.902323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.816321,
      1,
      NULL,
      NULL,
      0.883274,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.605716,
      NULL,
      NULL,
      NULL,
      3.540261,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.892386,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.499256,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.371904,
      NULL,
      3,
      1,
      NULL,
      2.072581,
      2.666881,
      0.271014,
      0.821063,
      0,
      0,
      3.869601,
      2.195508,
      1.973465,
      0,
      1,
      NULL,
      NULL,
      0.096561,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.399400,
      6.702184,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.014664,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      0.153883,
      2,
      2.256024,
      NULL,
      3.969813,
      1,
      2,
      1.578649,
      0.857843,
      7,
      1.448371,
      0.142878,
      0.778125,
      NULL,
      NULL,
      1.665253,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.049763,
      NULL,
      NULL,
      0.151877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      6,
      6.739059,
      0.177310,
      0,
      4,
      3,
      5,
      1,
      3.743017,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2.125355,
      1,
      3,
      4,
      5.853824,
      5,
      2,
      NULL,
      1,
      1.052190,
      NULL,
      NULL,
      NULL,
      3,
      2.467399,
      0.775308,
      NULL,
      0.509421,
      7,
      6,
      NULL,
      0.441462,
      NULL,
      NULL,
      2.722034,
      0,
      NULL,
      0.787115,
      1.159616,
      1,
      1.166117,
      1,
      3.871307,
      NULL,
      NULL,
      0.103307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392972,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.161039,
      NULL,
      NULL,
      1.033755,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.134327,
      NULL,
      NULL,
      1.294413,
      NULL,
      NULL,
      1,
      1.106347,
      1.542854,
      1.731509,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899427,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.992649,
      NULL,
      NULL,
      NULL,
      1.786786,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082460,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.686066,
      0.003598,
      1.474698,
      0.198574,
      NULL,
      NULL,
      1.057454,
      NULL,
      NULL,
      0.252701,
      NULL,
      NULL,
      1.261087,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.083543,
      0,
      1,
      1,
      0.012899,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0.563457,
      0.677687,
      1.664035,
      0,
      NULL,
      0,
      0,
      0.531816,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.310125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3,
      1.587663,
      0.026158,
      3,
      2,
      0.700667,
      1,
      1.767916,
      NULL,
      0.894573,
      1,
      NULL,
      1.828775,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.705548,
      0.068921,
      NULL,
      1.776118,
      0.098520,
      NULL,
      NULL,
      0,
      NULL,
      0.254819,
      3.889657,
      NULL,
      1,
      1,
      NULL,
      0.778020,
      0.597925,
      NULL,
      3,
      1.387389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.557445,
      NULL,
      1.283948,
      NULL,
      NULL,
      5,
      3,
      2.859344,
      3.502701,
      NULL,
      49,
      65,
      0,
      0.948481,
      3,
      '43232',
      NULL,
      '',
      1.517843,
      '',
      '',
      NULL,
      1.065467,
      NULL,
      '',
      '');
commit;
end;
/


