set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '0044402',
      NULL,
      1,
      3,
      2,
      '3444',
      NULL,
      1,
      NULL,
      NULL,
      '11-11-1997',
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      18,
      NULL,
      135.996982,
      NULL,
      1,
      NULL,
      ' 5-29-1975',
      '11-26-1987',
      1,
      NULL,
      NULL,
      0.338950,
      NULL,
      0,
      1,
      3.790364,
      NULL,
      NULL,
      NULL,
      12.040084,
      2.501842,
      33,
      14,
      3,
      NULL,
      0,
      3,
      2.904822,
      1.737571,
      0,
      0,
      1.472614,
      0.134004,
      0,
      1,
      1,
      NULL,
      NULL,
      0.211107,
      2,
      NULL,
      2,
      3.589751,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      2.154072,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3.320190,
      NULL,
      1.964554,
      0.091881,
      1.813229,
      0.359886,
      1.092306,
      3.126032,
      0.173694,
      1,
      3.920280,
      0,
      0.015673,
      NULL,
      0.130719,
      1,
      NULL,
      NULL,
      1,
      4,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      0,
      1,
      2,
      0,
      0,
      3,
      5,
      0,
      1,
      0.658903,
      0,
      0,
      0,
      1,
      0.547977,
      NULL,
      0.002607,
      3,
      NULL,
      1,
      NULL,
      0,
      0,
      4,
      4,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      5,
      2,
      NULL,
      NULL,
      1,
      1,
      3,
      0.252257,
      NULL,
      ' 8- 4-1993',
      NULL,
      '10-20-2001',
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.431610,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      29,
      0,
      1.646948,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.828983,
      1,
      1,
      2,
      2,
      NULL,
      3,
      0,
      3,
      0,
      NULL,
      5.477715,
      2,
      2,
      1,
      1.196568,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1.437962,
      0.402643,
      1,
      NULL,
      0,
      0.603402,
      0.981197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      16,
      NULL,
      4,
      1,
      3.888463,
      '33302',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2,
      NULL,
      7,
      23,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.358434,
      2,
      2.288743,
      1.737131,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.622092,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.804631,
      NULL,
      0.138031,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.083207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.901527,
      NULL,
      NULL,
      5,
      8.919080,
      1.545945,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.511080,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1.618100,
      NULL,
      NULL,
      3.324089,
      0.600463,
      NULL,
      2.555758,
      0,
      0.784085,
      0,
      0.565440,
      1.240786,
      1.465472,
      3,
      NULL,
      1.588509,
      2,
      NULL,
      1.639241,
      0.096840,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.089838,
      NULL,
      NULL,
      3,
      3.798404,
      5.466294,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.205072,
      NULL,
      3.700064,
      3.373072,
      2.889072,
      NULL,
      1.394984,
      NULL,
      NULL,
      5,
      3.089919,
      5.184979,
      3.444207,
      NULL,
      1.589383,
      NULL,
      NULL,
      NULL,
      5.975910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.268487,
      NULL,
      NULL,
      0.895138,
      NULL,
      NULL,
      0.177591,
      NULL,
      NULL,
      3.689917,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.172922,
      NULL,
      3.106556,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.375806,
      2.679944,
      3.201618,
      3,
      0,
      0.487773,
      1.078227,
      3,
      4.738940,
      3,
      NULL,
      3,
      0,
      1,
      3.286696,
      NULL,
      3,
      3,
      0,
      3.949435,
      3,
      6.176157,
      0.259475,
      1,
      4.898299,
      5,
      0.350208,
      3,
      0,
      4,
      1.186218,
      1.749843,
      0,
      0.846426,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.183017,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.794392,
      NULL,
      NULL,
      NULL,
      1.512474,
      NULL,
      1.068049,
      1,
      NULL,
      0.648060,
      NULL,
      NULL,
      0.309277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      13.046690,
      NULL,
      NULL,
      NULL,
      1.970699,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.301672,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.281417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614304,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1.296674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.770087,
      1.494491,
      1,
      NULL,
      1,
      1.812339,
      1,
      NULL,
      1,
      0,
      1.747586,
      0.977130,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      6.515558,
      3,
      2,
      0,
      2,
      10.001141,
      NULL,
      NULL,
      1.291875,
      1,
      0,
      NULL,
      0.177277,
      0.573710,
      NULL,
      1.379794,
      1.571355,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2.688799,
      3.645438,
      NULL,
      0.717801,
      3.263076,
      NULL,
      1.422376,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      2,
      NULL,
      0.154206,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.945839,
      NULL,
      NULL,
      0,
      NULL,
      0.072658,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      1.475752,
      3,
      '42242',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.581794,
      '',
      '',
      NULL);
commit;
end;
/


