set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '3100204',
      0.481352,
      0,
      1,
      NULL,
      '0424',
      0.041905,
      0,
      NULL,
      NULL,
      '11-26-1979',
      42,
      NULL,
      1,
      0.562090,
      NULL,
      ' 1-12-1987',
      5,
      3.695305,
      218.126369,
      115,
      1,
      '10-13-1997',
      NULL,
      ' 9-16-1990',
      2,
      1,
      3,
      2,
      1.897881,
      1.791430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.262061,
      NULL,
      22.510870,
      9.748059,
      5,
      NULL,
      NULL,
      1,
      4.172100,
      1.435012,
      2,
      NULL,
      0.192811,
      NULL,
      1.482607,
      1,
      0.139077,
      1.147512,
      0,
      0,
      2,
      4,
      1,
      1,
      5,
      1,
      0,
      1,
      NULL,
      1,
      4,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.264029,
      NULL,
      NULL,
      5,
      0,
      1,
      1.126463,
      0,
      0.313580,
      1,
      NULL,
      0.042839,
      NULL,
      NULL,
      1,
      0.286124,
      NULL,
      3.220165,
      1.513585,
      NULL,
      NULL,
      1.166770,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0.926832,
      0.415153,
      NULL,
      NULL,
      0.658766,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4,
      3,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      4.002871,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.968111,
      1,
      3,
      NULL,
      0,
      1,
      5,
      3,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      3,
      NULL,
      1,
      4,
      5,
      2,
      0,
      2,
      5,
      NULL,
      1,
      0,
      1.815110,
      1,
      NULL,
      8.774868,
      NULL,
      18,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0.804846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421565,
      1,
      6,
      0.159849,
      1.674411,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      1.253558,
      0.095747,
      0.721152,
      0.551868,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.174059,
      1.798537,
      1,
      2,
      2,
      2,
      2,
      3,
      1,
      3,
      NULL,
      3,
      NULL,
      NULL,
      2.560412,
      1,
      1.677905,
      NULL,
      1,
      0,
      0.335046,
      0.891694,
      0,
      0,
      0,
      0,
      NULL,
      0,
      3,
      1.416176,
      1.332141,
      NULL,
      NULL,
      0,
      NULL,
      1.683803,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      3,
      47.002432,
      2,
      2.136308,
      NULL,
      NULL,
      NULL,
      31.026134,
      2,
      1.934238,
      1,
      '02442',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      22,
      13.022511,
      1.133345,
      0.086141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912727,
      NULL,
      NULL,
      1.391146,
      1.985975,
      3.730112,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406223,
      NULL,
      NULL,
      3.768465,
      9.109313,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.484956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852997,
      0.700106,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.658512,
      NULL,
      0.660207,
      NULL,
      0.101242,
      1,
      0,
      NULL,
      NULL,
      0.595096,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.366989,
      NULL,
      3.090440,
      1,
      1.435135,
      NULL,
      NULL,
      NULL,
      0.181974,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.454700,
      1,
      0,
      NULL,
      NULL,
      4.975526,
      4.192094,
      5.564710,
      3.814860,
      0,
      1.289464,
      1.906535,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.567439,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.456354,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.218530,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1.061323,
      0,
      NULL,
      NULL,
      5.072399,
      4,
      5,
      1,
      NULL,
      NULL,
      2,
      3.166594,
      2.463154,
      0.380544,
      3.527286,
      2,
      3,
      NULL,
      3,
      2,
      1,
      3.043510,
      1,
      NULL,
      3,
      2.967971,
      NULL,
      2,
      1.222287,
      0.108343,
      3,
      0.707346,
      10.856971,
      1.937124,
      2,
      5.357143,
      3.711711,
      0,
      NULL,
      0,
      0.168006,
      NULL,
      0,
      NULL,
      1.317019,
      2.442340,
      NULL,
      NULL,
      1.064162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.249978,
      NULL,
      NULL,
      0.000160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.044257,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.198459,
      NULL,
      NULL,
      0,
      1.961361,
      0.172528,
      1.395743,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.466126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      15.691411,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.739364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134940,
      NULL,
      NULL,
      NULL,
      0.033317,
      NULL,
      NULL,
      NULL,
      0.443869,
      NULL,
      NULL,
      NULL,
      3.121329,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.399450,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750892,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.912083,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.765646,
      0.679809,
      1.656532,
      0,
      0,
      0,
      1,
      0.962715,
      1.494247,
      0,
      1,
      0.488101,
      NULL,
      1.064491,
      1.108043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.759148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      5,
      NULL,
      0,
      2,
      16,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.332908,
      NULL,
      0,
      1,
      NULL,
      1.273966,
      0.566966,
      NULL,
      3,
      0.735357,
      NULL,
      3,
      0.973070,
      NULL,
      1,
      0,
      NULL,
      1.862476,
      1.636624,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.596763,
      NULL,
      NULL,
      1,
      0.955987,
      0.529221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.630895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.366878,
      NULL,
      1.519221,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      43,
      89,
      1,
      1.488913,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.805890,
      '',
      NULL,
      NULL);
commit;
end;
/


