set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20',
      '03',
      22,
      22.467359,
      '4243224',
      0.906110,
      NULL,
      1,
      3,
      '3003',
      3.599615,
      0,
      NULL,
      NULL,
      '10-19-1989',
      3.152509,
      64,
      NULL,
      0.020090,
      0.184885,
      ' 9-27-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.635833,
      0,
      0.714294,
      3,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5.681439,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      3,
      NULL,
      1.582518,
      0.712744,
      NULL,
      0.363433,
      NULL,
      1,
      NULL,
      0.943013,
      3,
      5,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.870426,
      NULL,
      0.049552,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      3,
      4,
      5,
      5,
      0,
      0,
      2.226068,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      1.119860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896079,
      1.931820,
      NULL,
      NULL,
      0.012300,
      3,
      0.284207,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0.300277,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      2,
      2,
      0,
      3,
      2,
      1,
      1,
      3,
      2,
      0.032169,
      3,
      3,
      1,
      1,
      0.615337,
      3,
      1.489297,
      0.032152,
      0.018046,
      1,
      0.484911,
      1.709244,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      3,
      NULL,
      5,
      8.540766,
      NULL,
      4,
      2,
      NULL,
      2,
      NULL,
      3.507360,
      2,
      41,
      2,
      1.111751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '40342',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0.207755,
      11.044108,
      202.824383,
      20.594029,
      0,
      5,
      3,
      NULL,
      NULL,
      2.557242,
      NULL,
      0.148393,
      1.607047,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.915901,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.415958,
      1.082514,
      2.648198,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480189,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      1,
      0.773887,
      NULL,
      NULL,
      NULL,
      1.617767,
      NULL,
      NULL,
      NULL,
      1.724702,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.560657,
      NULL,
      NULL,
      2.570784,
      1.827407,
      0,
      1,
      1.913214,
      0.824648,
      0,
      0.092299,
      3,
      0,
      2,
      1.544524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819824,
      3.934401,
      NULL,
      8.003740,
      11,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.823438,
      NULL,
      NULL,
      NULL,
      0.852104,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4.343046,
      0.403134,
      1.187967,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      5,
      6,
      2.704763,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.963836,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.728185,
      3,
      NULL,
      NULL,
      NULL,
      1.031307,
      1,
      NULL,
      1.445343,
      4.145897,
      5,
      0,
      0.676007,
      NULL,
      NULL,
      1.488643,
      3,
      3,
      0,
      NULL,
      NULL,
      6.458125,
      NULL,
      NULL,
      3,
      0.365947,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      0.464211,
      1,
      NULL,
      5,
      0,
      5.521562,
      1.550828,
      NULL,
      1,
      1,
      0.528686,
      1.896946,
      0,
      0,
      0,
      3.947955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.526186,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.020416,
      1,
      NULL,
      0.271920,
      1,
      2.932926,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338325,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.290917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.131714,
      NULL,
      NULL,
      NULL,
      0.014224,
      NULL,
      NULL,
      NULL,
      0.372726,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0.223160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.972556,
      1.512576,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.483648,
      0.381202,
      NULL,
      NULL,
      NULL,
      2.640764,
      NULL,
      NULL,
      1.321868,
      NULL,
      NULL,
      NULL,
      0.369497,
      183,
      31,
      0.695914,
      18.419194,
      2.997709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.956889,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      16.487017,
      1.869699,
      0.977223,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1.018178,
      0.668143,
      1.526498,
      0.346038,
      1.449948,
      1,
      1,
      NULL,
      1.730773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      3,
      NULL,
      5,
      3,
      NULL,
      12.285643,
      NULL,
      2.367068,
      NULL,
      1.010775,
      0.870875,
      1,
      0.806642,
      0.117520,
      3.521163,
      0,
      1.452335,
      0.805453,
      1,
      NULL,
      1.260209,
      0.502114,
      2,
      0.154387,
      NULL,
      3,
      0.495580,
      NULL,
      1.295591,
      NULL,
      0.074831,
      1.631771,
      NULL,
      1.315231,
      NULL,
      1.829189,
      NULL,
      3,
      0.458494,
      0.642294,
      0.719729,
      1.674802,
      2,
      0.491931,
      1.047440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.426818,
      1,
      0.255103,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      0,
      0.069090,
      NULL,
      7,
      24,
      4,
      0,
      5,
      '40213',
      '13133',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


