set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8500287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2,
      3,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      '42204003',
      85.669950,
      0,
      '4413113',
      0.805405,
      0.327985,
      3,
      NULL,
      '4311',
      3.431430,
      NULL,
      NULL,
      NULL,
      ' 0-19-2001',
      33,
      8.761200,
      NULL,
      3,
      3,
      ' 3-17-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 4- 3-1993',
      0,
      NULL,
      2,
      NULL,
      1,
      1.140037,
      1,
      2,
      NULL,
      NULL,
      NULL,
      12.577902,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1.641162,
      2,
      0,
      NULL,
      0.298491,
      0,
      2,
      1,
      2.917279,
      4,
      1,
      0,
      0,
      1,
      2,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      9.867110,
      NULL,
      0,
      1,
      2,
      1.403843,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0.380268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      5,
      NULL,
      4,
      2,
      2,
      1,
      0,
      5,
      3,
      3,
      0,
      3.295198,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      2,
      5,
      4,
      2,
      NULL,
      3,
      0,
      1,
      5,
      5,
      0,
      5,
      0,
      3,
      3,
      1,
      4,
      4,
      0,
      2,
      NULL,
      1,
      4,
      3,
      5.629011,
      1,
      ' 8- 1-1984',
      0,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.568527,
      0.785235,
      0.758309,
      1,
      2,
      8.405731,
      0.463369,
      4,
      NULL,
      1,
      7,
      1,
      NULL,
      NULL,
      NULL,
      1.775524,
      9.473129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830611,
      NULL,
      NULL,
      1.336059,
      0,
      0,
      1,
      0,
      NULL,
      1.058103,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      2,
      2,
      0,
      2,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      2.804208,
      3.563239,
      1.374804,
      1.518748,
      3.177198,
      0.542998,
      1.576194,
      1.694933,
      1,
      0,
      0.677759,
      0.305899,
      1,
      0,
      NULL,
      0,
      1.786721,
      NULL,
      0,
      7.878437,
      9,
      1,
      1,
      3.659612,
      2,
      1.269026,
      3.913753,
      2,
      1,
      6,
      1,
      0,
      41,
      NULL,
      22,
      33.107585,
      1,
      5.393167,
      3.400731,
      '3034',
      '40042',
      '42031',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.372706,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.988296,
      NULL,
      NULL,
      1.615385,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.872348,
      1,
      1.912518,
      0.818180,
      0.431637,
      1,
      NULL,
      0.491114,
      1.102237,
      0.513249,
      0.909438,
      NULL,
      NULL,
      2,
      1,
      0.462557,
      NULL,
      1,
      NULL,
      0.015279,
      NULL,
      0.933400,
      NULL,
      0,
      NULL,
      5.009527,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      1.249359,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.042991,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.039247,
      NULL,
      0.813971,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.785412,
      NULL,
      0.239144,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.739701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.188481,
      3,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.462130,
      NULL,
      3.214332,
      NULL,
      32,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.721115,
      0.846354,
      1,
      1.181308,
      3,
      1.548471,
      3,
      NULL,
      1,
      0,
      1,
      0.422693,
      NULL,
      1,
      2,
      0,
      3,
      0,
      0.692418,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0.732482,
      2,
      3.919548,
      0,
      1.708101,
      2.895519,
      0.727603,
      1,
      0.038495,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107811,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      153,
      66,
      0,
      3,
      4.072145,
      '4134',
      '23124',
      '00202',
      0.011709,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


