set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6403615';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      NULL,
      NULL,
      9.725738,
      '2003340',
      3.694651,
      1.095634,
      3,
      NULL,
      '4001',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      56.692087,
      5,
      NULL,
      NULL,
      1.743429,
      ' 1- 9-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 1- 5-1982',
      1,
      2.563266,
      1,
      NULL,
      0,
      0,
      6,
      1,
      3.024895,
      NULL,
      4,
      6,
      4.802665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503133,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.710954,
      0.923654,
      0,
      0,
      4,
      0.997473,
      NULL,
      0,
      3,
      3,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      3.840025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      0,
      3,
      1,
      1,
      2,
      1,
      NULL,
      1,
      0,
      5,
      NULL,
      2.760683,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0.855189,
      1.584905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.629241,
      0.620232,
      NULL,
      NULL,
      1.576728,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687108,
      0.256450,
      0.593798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.728520,
      0.664194,
      1,
      1.988777,
      2,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.419967,
      1.462787,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      2,
      1,
      2,
      1,
      1.150395,
      2,
      NULL,
      2.224269,
      NULL,
      0.650224,
      3,
      0,
      1,
      0,
      0.632923,
      1.551146,
      1,
      0.696961,
      0.261795,
      0,
      1.593835,
      NULL,
      0.460691,
      1.506939,
      6,
      2,
      1.133889,
      7.966079,
      0.185108,
      5,
      0,
      0.819498,
      0,
      NULL,
      3,
      10.331044,
      3,
      1.667890,
      51,
      NULL,
      36,
      NULL,
      1,
      0,
      3,
      '00343',
      NULL,
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      5,
      211.533859,
      49,
      0.989291,
      NULL,
      4.983784,
      NULL,
      1,
      0.568653,
      NULL,
      1.091264,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.484243,
      3,
      0.838549,
      0.963935,
      NULL,
      NULL,
      NULL,
      0.493837,
      NULL,
      NULL,
      0,
      0,
      1.230652,
      0.936690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.592791,
      NULL,
      NULL,
      1.077412,
      NULL,
      NULL,
      8,
      2.185549,
      0,
      NULL,
      3.681053,
      NULL,
      0,
      1,
      3.151196,
      0.652882,
      1.234552,
      0.917966,
      0.812928,
      NULL,
      NULL,
      0.895907,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.870336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.837928,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.924213,
      NULL,
      NULL,
      1.173082,
      0.752537,
      1,
      0,
      NULL,
      NULL,
      3.444975,
      3.485473,
      0,
      0,
      1.186180,
      2,
      3.557164,
      1,
      1,
      6,
      2,
      2.925402,
      1,
      NULL,
      NULL,
      1.456939,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.627475,
      NULL,
      NULL,
      NULL,
      1.740592,
      1,
      1,
      0,
      3,
      0.363145,
      NULL,
      NULL,
      0.355296,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.885786,
      NULL,
      NULL,
      3.894066,
      NULL,
      NULL,
      0,
      0.011254,
      1.665533,
      1.538025,
      0.844664,
      1,
      0,
      1,
      0.616366,
      0,
      1.244462,
      0,
      2.722544,
      0.896679,
      0,
      0,
      1,
      1.626706,
      NULL,
      0.663072,
      NULL,
      2,
      0.532989,
      0,
      5.844023,
      4,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      1.637749,
      0.958802,
      2,
      1,
      0.772670,
      2,
      0,
      NULL,
      1.186813,
      29.495356,
      NULL,
      NULL,
      1.193054,
      NULL,
      NULL,
      0.335178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.155600,
      NULL,
      0.586426,
      0.539565,
      NULL,
      NULL,
      0,
      NULL,
      1.361748,
      3.972818,
      NULL,
      3.726379,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      NULL,
      3.700451,
      0.659716,
      NULL,
      2,
      NULL,
      0.548914,
      1,
      NULL,
      3.341759,
      0.443851,
      NULL,
      NULL,
      0.092965,
      1,
      NULL,
      NULL,
      5.717979,
      18.651037,
      NULL,
      NULL,
      3.098439,
      2.409973,
      NULL,
      NULL,
      0.904278,
      0,
      NULL,
      NULL,
      1.602745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.871294,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100568,
      0,
      NULL,
      NULL,
      0.182270,
      1.001733,
      NULL,
      NULL,
      3,
      0.573224,
      NULL,
      NULL,
      NULL,
      0.435673,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.786677,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.600713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.554720,
      57,
      173,
      1,
      221.047439,
      36,
      0.896837,
      NULL,
      NULL,
      NULL,
      3.986475,
      2,
      NULL,
      NULL,
      3.341217,
      0,
      NULL,
      NULL,
      2.136279,
      10,
      0,
      690.271801,
      74,
      1.800626,
      2,
      NULL,
      1,
      0.402464,
      1,
      0.679584,
      0,
      0,
      0,
      NULL,
      3.926570,
      0.774660,
      0.945590,
      1,
      0.581268,
      1,
      2.892097,
      NULL,
      0.821135,
      NULL,
      0.790105,
      NULL,
      1,
      NULL,
      0.445154,
      NULL,
      0.152992,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      4.531948,
      0.283195,
      1,
      0.664029,
      1,
      0,
      NULL,
      0,
      0.545945,
      1,
      1.605204,
      1,
      NULL,
      NULL,
      1.105530,
      1.812363,
      NULL,
      1,
      0,
      0,
      0.131190,
      0.761529,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1.443594,
      NULL,
      0,
      1.906533,
      1,
      1.623012,
      1,
      1,
      1.095260,
      3,
      0.625467,
      0,
      0,
      1,
      1.106522,
      2.506495,
      2,
      0,
      2.527509,
      0,
      1,
      1,
      1.343429,
      0,
      1.324815,
      1,
      1.878863,
      0,
      1,
      1.650436,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.160966,
      1,
      3.710093,
      0,
      NULL,
      1,
      1,
      33,
      NULL,
      NULL,
      2.107119,
      1,
      1,
      0.846104,
      NULL,
      1,
      1.129176,
      0,
      0.210109,
      1,
      0.293959,
      0.937162,
      1,
      0,
      1.160911,
      1.251910,
      NULL,
      0,
      2.347768,
      0,
      0,
      1.947780,
      0.196513,
      0,
      0.099237,
      1.892579,
      3.762732,
      28.197178,
      NULL,
      NULL,
      0.760918,
      3,
      1.537208,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1.900242,
      NULL,
      NULL,
      108,
      NULL,
      1,
      1.498228,
      1.440234,
      '22132',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


