set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '0011330',
      NULL,
      NULL,
      6,
      3,
      '4120',
      3,
      1.902247,
      NULL,
      NULL,
      ' 8-11-1975',
      NULL,
      NULL,
      4,
      2.424336,
      NULL,
      ' 9-20-1996',
      18.905284,
      1,
      37,
      116,
      2,
      '10-12-1992',
      ' 6-12-1996',
      '10-14-1995',
      3.651557,
      2.584035,
      2.472158,
      NULL,
      0.978847,
      0,
      1,
      0.790803,
      NULL,
      NULL,
      NULL,
      1.719860,
      NULL,
      14.071407,
      23,
      NULL,
      23.657810,
      NULL,
      NULL,
      6,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.489156,
      1.575090,
      0.768410,
      0,
      1,
      0.898713,
      1,
      3,
      2,
      0.708851,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      2,
      1,
      1,
      1,
      3.987739,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0.477868,
      NULL,
      NULL,
      2,
      3,
      3.734985,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      3,
      3,
      0,
      1,
      1,
      0,
      NULL,
      0,
      2,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0.513012,
      0,
      4,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      4,
      5,
      1,
      0,
      0,
      NULL,
      2,
      4,
      0,
      NULL,
      1.403106,
      1,
      ' 6-25-1999',
      20.636106,
      ' 7-10-1989',
      5.793470,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      5,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      1,
      1,
      5,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.017706,
      1,
      0,
      0,
      1.360470,
      NULL,
      0,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      2,
      2,
      3,
      NULL,
      NULL,
      2,
      1.624978,
      NULL,
      0,
      0.629421,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1.675996,
      0.859090,
      0,
      0.498571,
      4.414285,
      1,
      NULL,
      5.505736,
      1,
      1.024444,
      3.149196,
      NULL,
      1,
      1.354130,
      3,
      2,
      0,
      1.143521,
      49,
      1,
      3,
      NULL,
      52,
      23,
      52,
      1,
      2.683115,
      5,
      NULL,
      NULL,
      '23022',
      0.863801,
      '',
      '',
      NULL,
      3,
      '4123',
      '',
      '',
      0.913509,
      3.904523,
      24,
      32.704098,
      1.132175,
      NULL,
      3,
      0.745466,
      3,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.198678,
      0,
      1,
      3,
      NULL,
      1.583929,
      1.337713,
      NULL,
      NULL,
      1,
      3,
      3,
      0,
      NULL,
      NULL,
      1.802077,
      1.346791,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.924823,
      1,
      0.327415,
      0,
      NULL,
      NULL,
      1.462985,
      NULL,
      NULL,
      1.237627,
      5.758504,
      2.479438,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      4.104015,
      3.144293,
      4,
      1.989638,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235971,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.617902,
      NULL,
      NULL,
      1.366280,
      NULL,
      NULL,
      2.879500,
      3,
      3,
      3,
      3.668935,
      0.511442,
      NULL,
      NULL,
      NULL,
      3.446947,
      4.576351,
      5.322766,
      1.027684,
      1,
      0,
      NULL,
      NULL,
      3,
      3.360938,
      NULL,
      1,
      2,
      0.595961,
      NULL,
      0.548281,
      3,
      0.495464,
      NULL,
      0,
      NULL,
      0,
      1,
      3.849968,
      NULL,
      NULL,
      NULL,
      NULL,
      3.269444,
      2,
      NULL,
      0,
      3,
      3.157035,
      1,
      3,
      1.979051,
      NULL,
      0,
      1.582921,
      1.038045,
      3.931002,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908476,
      NULL,
      NULL,
      0.726623,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.524057,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1.508126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.307609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.118552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.803256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.985417,
      NULL,
      NULL,
      NULL,
      0.743806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.891948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.811780,
      1.971011,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335834,
      NULL,
      NULL,
      1.824938,
      NULL,
      0,
      14,
      NULL,
      0,
      1,
      0,
      1.092598,
      1,
      0,
      0,
      1.171707,
      0.767231,
      0,
      0,
      1,
      0.365379,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.749111,
      NULL,
      0.157788,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.211624,
      NULL,
      0.941733,
      NULL,
      1.752221,
      NULL,
      1,
      0,
      2.923889,
      NULL,
      1.177881,
      NULL,
      1.675010,
      NULL,
      46.376173,
      NULL,
      1,
      NULL,
      1.878658,
      NULL,
      0.393510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.273767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.839791,
      2,
      NULL,
      3,
      NULL,
      441,
      NULL,
      NULL,
      NULL,
      1.554284,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.131638,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.959932,
      2,
      0,
      0,
      3.343924,
      0,
      2,
      NULL,
      0.305252,
      0.114766,
      NULL,
      1.132422,
      NULL,
      NULL,
      0.086197,
      2.411166,
      NULL,
      NULL,
      0.405601,
      NULL,
      1.885431,
      0.603465,
      NULL,
      0.128278,
      0.221008,
      NULL,
      1,
      1.102719,
      NULL,
      0.085227,
      1.608110,
      NULL,
      NULL,
      0.805415,
      NULL,
      NULL,
      0,
      NULL,
      0.060735,
      0,
      NULL,
      0,
      NULL,
      0.790639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496694,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1,
      1.913131,
      7.787027,
      NULL,
      NULL,
      '33302',
      NULL,
      NULL,
      '',
      '',
      1.330139,
      NULL,
      NULL,
      '');
commit;
end;
/


