set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.808583,
      17,
      '4204401',
      1.380900,
      1.079954,
      NULL,
      3,
      NULL,
      4.384327,
      1.581960,
      NULL,
      NULL,
      ' 6- 9-1991',
      127,
      NULL,
      NULL,
      1,
      0.210609,
      ' 6-14-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 4-25-1974',
      '11-13-1996',
      1,
      0,
      NULL,
      0,
      0.451056,
      2,
      2,
      0.131099,
      NULL,
      NULL,
      NULL,
      0.439930,
      2.161465,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      NULL,
      1,
      1,
      1.686323,
      1.162223,
      0,
      NULL,
      3,
      0.870434,
      1,
      NULL,
      NULL,
      4,
      2,
      NULL,
      2,
      0,
      0,
      3,
      0,
      1,
      4,
      0,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.230846,
      NULL,
      NULL,
      0.567963,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0,
      5,
      0,
      1,
      0,
      0,
      0,
      0,
      4.445315,
      0,
      0,
      1,
      NULL,
      1.846967,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      2,
      2,
      NULL,
      3,
      NULL,
      0,
      1,
      2,
      4,
      3,
      2,
      5,
      3,
      NULL,
      2,
      5,
      NULL,
      0,
      1,
      3,
      1.533936,
      NULL,
      ' 3-20-1986',
      145,
      ' 8- 5-2000',
      118,
      2,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.088082,
      0.927573,
      0.228830,
      0,
      0,
      NULL,
      NULL,
      1.001765,
      NULL,
      2,
      1,
      0,
      0,
      0.064952,
      1.623217,
      0,
      6,
      0,
      0,
      NULL,
      1.287729,
      0,
      0.416413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869000,
      1,
      0.800183,
      0,
      NULL,
      NULL,
      1.023488,
      1.322753,
      25,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0.078322,
      1.759043,
      1.448118,
      0.291540,
      NULL,
      0,
      NULL,
      0,
      1.340035,
      1.216049,
      1,
      NULL,
      NULL,
      5.724396,
      NULL,
      5,
      11,
      5.161011,
      3,
      8.458625,
      5.883017,
      NULL,
      0,
      1.913339,
      1.779930,
      3,
      1.508912,
      64.474338,
      1,
      0.016783,
      65,
      NULL,
      6,
      22,
      NULL,
      4.869534,
      1.345079,
      '23323',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.934907,
      '2044',
      '',
      '',
      0,
      5,
      115.416324,
      NULL,
      3,
      21.162728,
      2.604639,
      NULL,
      NULL,
      3.630358,
      3,
      0.756094,
      0.496169,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.473442,
      3,
      NULL,
      0.900196,
      1.644036,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.496101,
      NULL,
      NULL,
      2,
      2.414993,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.844540,
      NULL,
      NULL,
      5,
      2,
      1.241568,
      0,
      0.525250,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422249,
      NULL,
      NULL,
      1.608386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.306999,
      NULL,
      NULL,
      3,
      2.457469,
      1,
      3,
      NULL,
      0.624579,
      0,
      NULL,
      NULL,
      1.777781,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.871317,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      6,
      NULL,
      0,
      1.924339,
      NULL,
      NULL,
      4,
      5.423746,
      1,
      1,
      0.990095,
      2,
      0.337178,
      0,
      3.855332,
      2,
      3,
      2,
      NULL,
      0,
      2,
      3,
      NULL,
      NULL,
      0.701635,
      2,
      NULL,
      NULL,
      3.914937,
      NULL,
      2.056047,
      1.525404,
      NULL,
      NULL,
      0.597857,
      4.245135,
      3,
      5,
      1.906164,
      3,
      0,
      2,
      1,
      1.421546,
      NULL,
      1.319409,
      1.342854,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969849,
      NULL,
      NULL,
      0.274915,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.450845,
      NULL,
      NULL,
      0.549257,
      NULL,
      NULL,
      0.873730,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.546609,
      1,
      1.983543,
      0,
      0,
      0.899434,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.876690,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.101064,
      2,
      5,
      2,
      3,
      1,
      80.606790,
      0.284664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.149292,
      NULL,
      NULL,
      162,
      1703,
      1.271839,
      1.619061,
      1.806716,
      1,
      0.094342,
      0,
      1.661342,
      0.742651,
      NULL,
      3.772972,
      1,
      0,
      1.361093,
      1,
      1,
      0.418715,
      1,
      1,
      NULL,
      1,
      NULL,
      0.411487,
      NULL,
      3.641407,
      NULL,
      0.399975,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      21.754014,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.843426,
      NULL,
      0.380847,
      NULL,
      1.446384,
      NULL,
      1,
      NULL,
      0.025042,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.075432,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.284714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.219311,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.135329,
      NULL,
      0.730473,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.036414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.205180,
      NULL,
      2.100817,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.448303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.167750,
      0.950124,
      0,
      NULL,
      1,
      NULL,
      571.355574,
      NULL,
      1,
      NULL,
      0.503997,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.347726,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.838487,
      3.159530,
      3.669417,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.942127,
      0,
      NULL,
      1.267495,
      NULL,
      NULL,
      1.145615,
      0.685464,
      NULL,
      1,
      1.105641,
      NULL,
      1,
      1,
      NULL,
      1,
      1.097056,
      NULL,
      1.276328,
      NULL,
      NULL,
      1.426291,
      3.648493,
      NULL,
      0.855365,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.510287,
      NULL,
      0,
      NULL,
      0.892796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3,
      5,
      6,
      NULL,
      NULL,
      NULL,
      19,
      12,
      3,
      NULL,
      0.471509,
      '40101',
      NULL,
      '04220',
      0.307214,
      '',
      '',
      NULL,
      1.505580,
      '0244',
      NULL,
      '');
commit;
end;
/


