set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8828277';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3244004',
      NULL,
      0,
      1,
      2,
      '4224',
      1.656886,
      1.331444,
      NULL,
      NULL,
      ' 0-11-1999',
      18,
      NULL,
      1,
      2.636464,
      12.980630,
      '10-12-1994',
      2,
      5.421310,
      252,
      68.653086,
      0,
      ' 4-12-2003',
      ' 9-15-1983',
      ' 2-21-1989',
      1.785782,
      2,
      3.318524,
      0.607678,
      0,
      1.206255,
      1,
      2.338613,
      NULL,
      NULL,
      NULL,
      6,
      5,
      3.196860,
      NULL,
      1,
      13.163743,
      2,
      5,
      NULL,
      1.965563,
      1,
      1,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0.571027,
      41,
      8,
      0,
      2,
      2,
      1,
      0,
      0,
      1,
      2,
      NULL,
      1,
      0,
      1,
      2,
      0,
      1,
      3,
      2,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.135231,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      0,
      1,
      1.471286,
      0.330670,
      0.528990,
      3.099672,
      3.283539,
      1,
      NULL,
      3.063955,
      NULL,
      0,
      0.351224,
      0.454905,
      NULL,
      2,
      1,
      1,
      NULL,
      3,
      1,
      3.627902,
      0.127879,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      3,
      0,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      3,
      5,
      0,
      2,
      0,
      3,
      5,
      NULL,
      1,
      NULL,
      0,
      3,
      3,
      0,
      0,
      4,
      2,
      3,
      0,
      0,
      4,
      0,
      2,
      2,
      0,
      4,
      0.735217,
      ' 2-18-1995',
      410,
      ' 6- 2-1996',
      64.269935,
      1.398079,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      1,
      5,
      NULL,
      1.407386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      330.187585,
      3.118492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.438860,
      2,
      1,
      1,
      0.444814,
      8.971171,
      1,
      1.329321,
      1,
      0.343865,
      0,
      7,
      1,
      NULL,
      NULL,
      3.966237,
      5.099688,
      1.368219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592149,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      78.650879,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.416186,
      3,
      0,
      NULL,
      0,
      1,
      3,
      1,
      NULL,
      3,
      NULL,
      NULL,
      8,
      13,
      16,
      116,
      164.256043,
      64,
      85,
      82,
      0.206963,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      17,
      10,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11,
      37.605690,
      5,
      0,
      NULL,
      '04110',
      '4222',
      '',
      1,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      5.056082,
      11.586715,
      NULL,
      1,
      26.518244,
      16,
      12,
      2,
      2.956108,
      1.461520,
      NULL,
      0.971413,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.289234,
      NULL,
      NULL,
      2.218202,
      1,
      NULL,
      NULL,
      1.368743,
      NULL,
      15.001986,
      NULL,
      NULL,
      16.223569,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      0.647012,
      2.161728,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.752937,
      NULL,
      NULL,
      NULL,
      3,
      1,
      15.505992,
      16,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      1,
      1.934581,
      NULL,
      NULL,
      2.728192,
      1.542823,
      NULL,
      3,
      0,
      2,
      3.167527,
      1,
      3,
      0,
      3.615347,
      3.680519,
      7.896083,
      NULL,
      NULL,
      0.171030,
      NULL,
      NULL,
      19.942883,
      NULL,
      NULL,
      3,
      1.756911,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.420779,
      NULL,
      NULL,
      2.711499,
      NULL,
      NULL,
      0,
      4.452643,
      0.422689,
      0.535003,
      NULL,
      NULL,
      0.299934,
      0,
      2,
      NULL,
      4,
      12,
      0,
      NULL,
      NULL,
      4.213130,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.731025,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.391197,
      NULL,
      NULL,
      1.246653,
      NULL,
      NULL,
      0.956650,
      NULL,
      NULL,
      1.725421,
      12.269462,
      17.659904,
      3.026257,
      NULL,
      11.758418,
      7,
      0,
      1,
      5.229422,
      1,
      3.245378,
      0.163142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015634,
      8.519458,
      7.364317,
      NULL,
      11,
      10.632206,
      8,
      3.466211,
      2,
      3,
      17,
      19.338787,
      0.145657,
      NULL,
      NULL,
      NULL,
      15.868004,
      6,
      3,
      10,
      10.772128,
      4,
      2,
      0.205707,
      5,
      0,
      NULL,
      2,
      2,
      1,
      NULL,
      0.621892,
      1,
      NULL,
      1.025450,
      2.454276,
      NULL,
      NULL,
      3.944033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.641183,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.146977,
      0.388647,
      0,
      1.794754,
      1,
      0.508760,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.631448,
      NULL,
      NULL,
      NULL,
      16.731382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.368217,
      NULL,
      NULL,
      NULL,
      0.739451,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.729674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.044511,
      NULL,
      NULL,
      NULL,
      1.943145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0,
      2.064294,
      7,
      4,
      3,
      988,
      111,
      3,
      1806.088059,
      1132.615157,
      0,
      NULL,
      NULL,
      0.235002,
      NULL,
      NULL,
      NULL,
      1734.871704,
      1064.024493,
      0.560973,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      18546.040291,
      NULL,
      NULL,
      1.811807,
      1,
      0.825209,
      NULL,
      1.664834,
      1,
      0,
      1.923086,
      0.692754,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0.166080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.201862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147461,
      1.865373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240967,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.163707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.042116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372199,
      0,
      0,
      1,
      0.091227,
      0.962276,
      NULL,
      NULL,
      1.086308,
      1,
      1,
      1,
      1.138442,
      1.166302,
      0,
      1.956373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.922592,
      NULL,
      4,
      0,
      3,
      15.607909,
      NULL,
      0,
      0.093552,
      1.802166,
      0.933748,
      NULL,
      1,
      1.652745,
      NULL,
      0,
      2,
      NULL,
      1.741967,
      0,
      NULL,
      3,
      NULL,
      NULL,
      3.919326,
      3,
      NULL,
      1.282122,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.497073,
      NULL,
      1,
      1.923751,
      NULL,
      0.302362,
      NULL,
      NULL,
      NULL,
      1.238084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.384561,
      NULL,
      1,
      NULL,
      2,
      2,
      1,
      0.581858,
      NULL,
      NULL,
      93,
      81.307888,
      1,
      1.376195,
      NULL,
      NULL,
      '2142',
      '',
      0.650336,
      '10240',
      NULL,
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


