set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '3421032',
      0,
      1,
      NULL,
      2,
      '4011',
      1,
      NULL,
      NULL,
      NULL,
      '11- 6-1985',
      31,
      NULL,
      NULL,
      2,
      1,
      ' 0-14-1974',
      NULL,
      2.304992,
      16.234082,
      NULL,
      3,
      ' 9- 8-1979',
      NULL,
      ' 0- 4-1980',
      2,
      NULL,
      1.059183,
      1.158029,
      1.199356,
      NULL,
      0,
      NULL,
      1.952211,
      NULL,
      3,
      18,
      2.521836,
      NULL,
      23,
      2,
      NULL,
      2,
      5,
      0,
      NULL,
      3,
      1,
      0.940251,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.068396,
      1,
      3,
      4,
      NULL,
      3.387979,
      4,
      2,
      NULL,
      0,
      2,
      0,
      3,
      NULL,
      1,
      0,
      0,
      0,
      7,
      0,
      1,
      1,
      NULL,
      1.437849,
      NULL,
      NULL,
      0.646991,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4.182186,
      0,
      0,
      NULL,
      1.735176,
      NULL,
      NULL,
      0.201154,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.578300,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      3,
      1,
      0,
      NULL,
      0,
      1,
      2,
      1,
      4,
      4,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      2,
      1.739081,
      NULL,
      ' 2-16-1984',
      NULL,
      NULL,
      NULL,
      0.165038,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      5,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8.681216,
      2.116010,
      3.048631,
      NULL,
      0.738415,
      0,
      0,
      2.651447,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2,
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      6,
      1.935714,
      0,
      0,
      0,
      NULL,
      ' 7-22-1978',
      7,
      NULL,
      16.951432,
      0,
      0,
      NULL,
      NULL,
      0.676302,
      1.346548,
      2,
      1,
      0,
      1.877880,
      1.912585,
      105.454587,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      1,
      1,
      0,
      3,
      1,
      3,
      3,
      2,
      0.881944,
      0.521438,
      3.784425,
      2,
      0,
      NULL,
      0.479356,
      1.306814,
      0,
      NULL,
      57.487070,
      19.619582,
      0.223856,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1.858596,
      0.870179,
      7.249123,
      7.151910,
      3.588932,
      NULL,
      0.104286,
      0.303933,
      7.145371,
      0.137367,
      3,
      0.666593,
      2.443170,
      0,
      1,
      NULL,
      63,
      74,
      86,
      4,
      0.726750,
      1.521460,
      '04314',
      '12420',
      '',
      1,
      '',
      '',
      NULL,
      1,
      '2211',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.310303,
      NULL,
      0,
      NULL,
      NULL,
      3.009400,
      1,
      NULL,
      0.432442,
      NULL,
      NULL,
      1.453892,
      NULL,
      NULL,
      0,
      NULL,
      1,
      295.180217,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.950789,
      0,
      3,
      NULL,
      2.887807,
      1.431415,
      NULL,
      1.045346,
      0,
      1.589819,
      1.813938,
      0.709899,
      2.941854,
      NULL,
      1.596741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.448961,
      NULL,
      NULL,
      NULL,
      0,
      1,
      6.363163,
      1,
      NULL,
      NULL,
      NULL,
      1.595912,
      NULL,
      0.240901,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.979550,
      NULL,
      0,
      NULL,
      1.133941,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.592187,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.951291,
      0.242943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.380591,
      1.108800,
      0,
      1,
      NULL,
      NULL,
      0,
      0.053885,
      NULL,
      2.488391,
      NULL,
      1,
      1.204452,
      NULL,
      1,
      1.611057,
      NULL,
      0.892920,
      1.021426,
      NULL,
      1.104831,
      0.604834,
      NULL,
      NULL,
      NULL,
      NULL,
      1.198982,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0.227326,
      NULL,
      NULL,
      1.248661,
      1.458555,
      NULL,
      0,
      0.432565,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.500779,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      1.996740,
      NULL,
      NULL,
      NULL,
      121.267819,
      0,
      0,
      2.635913,
      NULL,
      '42132',
      '',
      1,
      '',
      '',
      '',
      0.374520,
      '4014',
      '',
      '');
commit;
end;
/


