set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '2211230',
      2.736205,
      0,
      2,
      3,
      '0110',
      3.258459,
      0,
      NULL,
      NULL,
      NULL,
      47.749191,
      NULL,
      1,
      NULL,
      4,
      ' 3-19-1991',
      0,
      2,
      141.599379,
      166,
      2,
      NULL,
      ' 8-26-1995',
      '11-22-1986',
      2,
      1,
      1.528245,
      NULL,
      NULL,
      3.865820,
      1,
      0,
      0.877903,
      2,
      3,
      NULL,
      5,
      20.572797,
      1.109844,
      5,
      12,
      NULL,
      1,
      9,
      1,
      0,
      NULL,
      0,
      0.199753,
      1.497680,
      1,
      NULL,
      1,
      1,
      1.213948,
      NULL,
      5,
      NULL,
      1,
      4,
      0,
      NULL,
      1,
      2,
      1,
      5,
      1,
      1,
      1,
      NULL,
      1,
      3.857613,
      2,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3,
      3.366186,
      0,
      1,
      3.996912,
      1,
      NULL,
      NULL,
      1.309374,
      NULL,
      NULL,
      0,
      1,
      5,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1.803359,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      1,
      2,
      5,
      1,
      0,
      3,
      1,
      4,
      3,
      1,
      1,
      3,
      NULL,
      3,
      4,
      1,
      5,
      1,
      2,
      1,
      3,
      3.248495,
      1.802310,
      '10-14-1983',
      30.345457,
      ' 1-21-1975',
      22.078360,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      0,
      2,
      0,
      0.048419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      25.644507,
      0.917467,
      0.901839,
      3,
      0.499040,
      1,
      NULL,
      1,
      NULL,
      0,
      3.584674,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.659203,
      NULL,
      4,
      NULL,
      NULL,
      7.074304,
      0,
      NULL,
      1,
      2,
      0,
      0.674499,
      NULL,
      2,
      2,
      6,
      ' 3-23-1992',
      7,
      ' 4-19-1981',
      9,
      NULL,
      2,
      1,
      1.501388,
      0.232347,
      1.988966,
      3.487644,
      0,
      0.549025,
      0,
      2.459116,
      NULL,
      1.262058,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.115872,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      2,
      1.110543,
      3,
      2,
      NULL,
      1,
      0.571113,
      1,
      1.403151,
      NULL,
      126.975829,
      163,
      101,
      NULL,
      1.926433,
      1.455409,
      1,
      3,
      0,
      1,
      3.678757,
      NULL,
      0.354111,
      NULL,
      8,
      NULL,
      NULL,
      1,
      6.151361,
      0.358561,
      0.957450,
      2,
      68,
      0,
      NULL,
      NULL,
      68,
      NULL,
      45,
      5,
      0.468520,
      5.878680,
      '30112',
      NULL,
      NULL,
      0.770197,
      '',
      '',
      NULL,
      0,
      '4211',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.869217,
      0,
      NULL,
      NULL,
      0,
      1.286025,
      1,
      1,
      NULL,
      NULL,
      1.110888,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424249,
      19,
      0.848851,
      0,
      1,
      0.689027,
      NULL,
      0,
      0.344708,
      NULL,
      3,
      NULL,
      0.899141,
      0.165457,
      0,
      NULL,
      1.788761,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.275797,
      NULL,
      NULL,
      NULL,
      0.121675,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      22.564830,
      NULL,
      2,
      NULL,
      23.827983,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125276,
      NULL,
      0.253832,
      NULL,
      0.771562,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.304041,
      NULL,
      0,
      NULL,
      0.658446,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0.973774,
      NULL,
      1,
      0,
      3.247266,
      3,
      3.501842,
      0,
      2.950035,
      3,
      NULL,
      1,
      1.847992,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904862,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.612400,
      1,
      NULL,
      0.997152,
      NULL,
      NULL,
      NULL,
      1.567698,
      NULL,
      1.184811,
      0,
      NULL,
      1.722737,
      0,
      NULL,
      3.307803,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.569194,
      NULL,
      0,
      0,
      0,
      1.507267,
      NULL,
      NULL,
      147.141527,
      15,
      1,
      0,
      3,
      '01030',
      '01233',
      '',
      1.439586,
      NULL,
      '',
      '',
      2,
      '4321',
      NULL,
      '');
commit;
end;
/


