set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215884';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      NULL,
      2.168107,
      1,
      0.022782,
      0,
      NULL,
      3.127242,
      '320',
      '10031343',
      72.112383,
      NULL,
      '2141241',
      2.433429,
      0,
      0,
      1,
      NULL,
      1.206324,
      1.581592,
      NULL,
      NULL,
      NULL,
      106.616945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '10-21-1995',
      NULL,
      ' 0-21-1992',
      2.854037,
      1.609080,
      NULL,
      0.678858,
      NULL,
      NULL,
      5,
      NULL,
      0.855257,
      2.776342,
      4,
      10.631192,
      6.007902,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      6,
      NULL,
      5,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      7,
      1,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      0.083321,
      1.582988,
      2.786529,
      NULL,
      0.655749,
      NULL,
      1.671244,
      1,
      1,
      3.485453,
      1.404711,
      1,
      1,
      2,
      NULL,
      1,
      0,
      1,
      2,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1.796400,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      3,
      0,
      1,
      NULL,
      5,
      4,
      0,
      1,
      2,
      4,
      2,
      1,
      0,
      1.219729,
      2.725805,
      ' 9- 6-2000',
      677,
      NULL,
      NULL,
      1.354178,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      0.528505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.699779,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      7.999275,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.956293,
      8.515552,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.162981,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843096,
      0,
      0,
      NULL,
      0.754247,
      NULL,
      0,
      0.623648,
      6,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.903763,
      1,
      0,
      1,
      1,
      2,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1.411286,
      3.003003,
      NULL,
      1.806194,
      1.296566,
      NULL,
      NULL,
      1.215613,
      1.382789,
      0,
      NULL,
      NULL,
      NULL,
      1.339550,
      0,
      1,
      1,
      4,
      0.406273,
      11.452801,
      5.000162,
      6.302641,
      3,
      10,
      NULL,
      2.512241,
      1,
      1,
      1.943186,
      0,
      3.774966,
      71.632852,
      NULL,
      1,
      24,
      NULL,
      65,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      0.865076,
      '04440',
      '4044',
      '3123',
      3.978426,
      NULL,
      102.276177,
      3,
      1,
      27,
      3.911731,
      2,
      4,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931644,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.548668,
      1,
      0,
      NULL,
      NULL,
      3,
      1.285503,
      NULL,
      1.116629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205422,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.507558,
      NULL,
      NULL,
      NULL,
      0.773028,
      0,
      1,
      1,
      NULL,
      NULL,
      0.702505,
      NULL,
      NULL,
      3.532698,
      0,
      1.473973,
      0.913148,
      0,
      0.714940,
      0.471070,
      NULL,
      1.687981,
      1.182195,
      0,
      1,
      0.580187,
      NULL,
      0.659827,
      1,
      0.666256,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.704078,
      1,
      0.572110,
      0,
      0.046953,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.573120,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.189589,
      0,
      0,
      1.507569,
      NULL,
      NULL,
      7,
      0,
      NULL,
      2,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2.000330,
      1.181370,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.671729,
      NULL,
      NULL,
      1.423975,
      NULL,
      NULL,
      1.808234,
      NULL,
      NULL,
      1.992931,
      NULL,
      NULL,
      0.260397,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.830318,
      1,
      4.953197,
      1.897954,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.990125,
      3.351382,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      0,
      NULL,
      2,
      1,
      3,
      0.116809,
      3.319242,
      0.694951,
      0.446023,
      1.339460,
      4.995339,
      0,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.183235,
      0,
      1,
      NULL,
      NULL,
      1.365888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.308636,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.078251,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.338482,
      NULL,
      NULL,
      1.077331,
      NULL,
      NULL,
      0.759128,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.720493,
      NULL,
      NULL,
      0.968056,
      0,
      0.113127,
      1.813372,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.072505,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.678968,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.241903,
      NULL,
      NULL,
      NULL,
      1.962478,
      NULL,
      NULL,
      NULL,
      1.481809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.447927,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.099687,
      6.956113,
      12,
      0.774834,
      67.209785,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      135.312226,
      23.231173,
      1.922282,
      5.680175,
      0,
      0.814694,
      NULL,
      NULL,
      0.358731,
      NULL,
      1,
      205.598131,
      4.501918,
      NULL,
      2,
      1.956775,
      0.464949,
      NULL,
      3.738772,
      1.390904,
      2.311293,
      1.107441,
      1,
      1.150272,
      2,
      NULL,
      0,
      0,
      0,
      0.873087,
      2,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2.898380,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.309004,
      0.046693,
      2,
      1.448753,
      NULL,
      2.884107,
      NULL,
      1.289207,
      NULL,
      1.151355,
      NULL,
      0.991855,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0.936539,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.941396,
      NULL,
      1.555710,
      NULL,
      1,
      NULL,
      1.626314,
      3.842093,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.303625,
      NULL,
      1.244078,
      NULL,
      NULL,
      NULL,
      2.866081,
      NULL,
      0.981954,
      NULL,
      1.567566,
      NULL,
      NULL,
      NULL,
      0.730453,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.965528,
      1,
      2.829661,
      NULL,
      1.146605,
      NULL,
      1.504408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464532,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.738403,
      2.034555,
      1.801524,
      0.009157,
      0,
      1.339885,
      NULL,
      NULL,
      NULL,
      NULL,
      1.313570,
      0,
      0.757467,
      0.069321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.141173,
      1.635757,
      0,
      1,
      0,
      NULL,
      0,
      3.376787,
      0.761270,
      NULL,
      NULL,
      NULL,
      1,
      0.009131,
      NULL,
      0,
      0.147646,
      NULL,
      1.143446,
      0,
      NULL,
      3.129520,
      2,
      NULL,
      NULL,
      1.585505,
      NULL,
      NULL,
      0.363380,
      NULL,
      0.082020,
      1,
      NULL,
      1,
      1.159368,
      NULL,
      0,
      1.866558,
      NULL,
      1,
      0,
      NULL,
      0.346415,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      3,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      5,
      3,
      '14421',
      NULL,
      '',
      0,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      '0242');
commit;
end;
/


