set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8020079';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '1032221',
      NULL,
      1.399093,
      NULL,
      3,
      '4213',
      2,
      0.948864,
      NULL,
      NULL,
      ' 1-23-1984',
      3.115863,
      NULL,
      4,
      NULL,
      NULL,
      ' 4-15-1974',
      14,
      NULL,
      140.829077,
      9,
      2,
      ' 1-24-1974',
      ' 5-27-1997',
      ' 1-11-1994',
      3,
      1,
      NULL,
      0.045413,
      1.357795,
      NULL,
      3,
      NULL,
      1,
      NULL,
      8,
      13,
      8.715318,
      NULL,
      127,
      1,
      25.904458,
      NULL,
      0,
      7.525533,
      1.717569,
      3,
      1,
      0.147937,
      0,
      0.759664,
      1.758124,
      0,
      1,
      1.166117,
      1,
      2,
      5,
      0,
      2,
      5,
      0,
      NULL,
      1,
      0,
      4,
      NULL,
      3,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      3.809167,
      1,
      1,
      0.824930,
      NULL,
      1.478965,
      1.921500,
      1.116896,
      NULL,
      1,
      1,
      1.203963,
      1,
      1,
      1,
      1.935904,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.877538,
      1,
      NULL,
      NULL,
      0.704854,
      NULL,
      NULL,
      1,
      4,
      3,
      1,
      1,
      2,
      0,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      0.276190,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      4,
      0,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2,
      5,
      NULL,
      NULL,
      4,
      0,
      NULL,
      5,
      NULL,
      5,
      5,
      NULL,
      0,
      NULL,
      3,
      0,
      2.550056,
      3,
      ' 8-24-2003',
      19,
      ' 6-26-1993',
      565,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      1.231708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.506827,
      1,
      5.994247,
      2,
      NULL,
      4,
      0.936730,
      NULL,
      NULL,
      NULL,
      NULL,
      3.510390,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.495020,
      0,
      NULL,
      NULL,
      1,
      1.258662,
      1.000750,
      1,
      3.711108,
      NULL,
      0.448831,
      NULL,
      NULL,
      NULL,
      3,
      0.987898,
      0.671392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.837539,
      3,
      6,
      9,
      4.321220,
      5,
      2.844524,
      5,
      NULL,
      3,
      1.609616,
      44,
      0,
      2,
      NULL,
      NULL,
      30,
      60.234390,
      2,
      0.921091,
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.943441,
      '',
      NULL,
      NULL,
      3,
      NULL,
      152,
      13,
      3,
      6.677439,
      14.027726,
      15,
      2,
      1.732256,
      2,
      2.539408,
      NULL,
      NULL,
      NULL,
      1.655888,
      NULL,
      NULL,
      0.735397,
      NULL,
      NULL,
      1.773603,
      NULL,
      NULL,
      2,
      0,
      3.862250,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.534151,
      0.843604,
      NULL,
      NULL,
      4,
      NULL,
      2.259431,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      15,
      NULL,
      0,
      2,
      0.388572,
      10.842689,
      NULL,
      NULL,
      0.438865,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0.704647,
      0.810768,
      0,
      1,
      1.905175,
      1.198002,
      1,
      0,
      1,
      3,
      NULL,
      0.898429,
      0,
      NULL,
      NULL,
      0.881635,
      NULL,
      NULL,
      8,
      3,
      8.263305,
      0,
      1.866033,
      NULL,
      NULL,
      NULL,
      1.279784,
      NULL,
      NULL,
      NULL,
      1.218605,
      NULL,
      NULL,
      2,
      3.485588,
      1,
      NULL,
      1,
      0,
      1.822463,
      NULL,
      NULL,
      9.280373,
      5.073525,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.943233,
      NULL,
      NULL,
      0.858884,
      NULL,
      NULL,
      0.234734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.324814,
      NULL,
      NULL,
      1.236986,
      1,
      0,
      1,
      1.781810,
      NULL,
      0,
      NULL,
      3.472277,
      0.150350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.725484,
      1.369445,
      NULL,
      0,
      2,
      3,
      1.711171,
      NULL,
      NULL,
      6.643004,
      3.404178,
      7.913347,
      0.394487,
      0.533734,
      0.056998,
      1,
      NULL,
      2.880820,
      3.072149,
      1.188706,
      3.146022,
      0,
      2,
      2,
      5,
      2.182581,
      3,
      2,
      NULL,
      NULL,
      2.850765,
      NULL,
      NULL,
      1.961766,
      1.401912,
      NULL,
      0,
      0.720866,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335941,
      NULL,
      NULL,
      0.443150,
      NULL,
      NULL,
      0.896056,
      NULL,
      NULL,
      0.658396,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.539465,
      1,
      NULL,
      1.898392,
      NULL,
      NULL,
      0.175725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.426394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.128362,
      NULL,
      NULL,
      NULL,
      3.736372,
      167.208315,
      1554.452903,
      0.385270,
      NULL,
      NULL,
      0.952878,
      NULL,
      NULL,
      3,
      845.777449,
      1136,
      0.957329,
      NULL,
      NULL,
      1.306045,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      12811,
      1605.485079,
      1.469628,
      1,
      0.413241,
      0,
      0,
      NULL,
      1,
      0.748325,
      0,
      0,
      NULL,
      1.044886,
      0,
      1.664932,
      NULL,
      0.851903,
      0,
      0.674134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.526761,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706397,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.366098,
      1.465665,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.787776,
      1.769397,
      0.017562,
      NULL,
      0.996896,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.516169,
      NULL,
      NULL,
      NULL,
      1.837885,
      NULL,
      NULL,
      0.871776,
      1.764403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049360,
      NULL,
      1.448574,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262544,
      NULL,
      0.984271,
      NULL,
      0.383816,
      1.218985,
      0.800172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      1.352706,
      1,
      NULL,
      1.748149,
      NULL,
      NULL,
      NULL,
      1.861384,
      NULL,
      1.718626,
      0.906812,
      NULL,
      1,
      0.950877,
      NULL,
      NULL,
      1.012728,
      NULL,
      1,
      0.721940,
      NULL,
      NULL,
      1,
      NULL,
      0.795286,
      0.621292,
      NULL,
      1,
      0,
      NULL,
      1.694856,
      1.421315,
      NULL,
      NULL,
      1.271548,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.962618,
      NULL,
      3,
      5,
      4,
      0.660801,
      NULL,
      1,
      70,
      28.177027,
      2,
      2.748155,
      3,
      '23400',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      0.769700,
      '',
      NULL,
      NULL);
commit;
end;
/


